/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.File;
import java.io.FileFilter;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.ResourcePackFolder;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    private static final FileFilter RESOURCEPACK_FILTER = var0 -> {
        boolean var1 = var0.isFile() && var0.getName().endsWith(".zip");
        boolean var2 = var0.isDirectory() && new File(var0, "pack.mcmeta").isFile();
        return var1 || var2;
    };
    private final File folder;
    private final PackSource packSource;

    public ResourcePackSourceFolder(File var0, PackSource var1) {
        this.folder = var0;
        this.packSource = var1;
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> var0, ResourcePackLoader.a var1) {
        File[] var2;
        if (!this.folder.isDirectory()) {
            this.folder.mkdirs();
        }
        if ((var2 = this.folder.listFiles(RESOURCEPACK_FILTER)) == null) {
            return;
        }
        for (File var6 : var2) {
            String var7 = "file/" + var6.getName();
            ResourcePackLoader var8 = ResourcePackLoader.create(var7, false, this.createSupplier(var6), var1, ResourcePackLoader.Position.TOP, this.packSource);
            if (var8 == null) continue;
            var0.accept(var8);
        }
    }

    private Supplier<IResourcePack> createSupplier(File var0) {
        if (var0.isDirectory()) {
            return () -> new ResourcePackFolder(var0);
        }
        return () -> new ResourcePackFile(var0);
    }
}

