/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackLoader
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String id;
    private final Supplier<IResourcePack> supplier;
    private final IChatBaseComponent title;
    private final IChatBaseComponent description;
    private final EnumResourcePackVersion compatibility;
    private final Position defaultPosition;
    private final boolean required;
    private final boolean fixedPosition;
    private final PackSource packSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ResourcePackLoader create(String var0, boolean var1, Supplier<IResourcePack> var2, a var3, Position var4, PackSource var5) {
        try (IResourcePack var6 = var2.get();){
            ResourcePackInfo var7 = var6.getMetadataSection(ResourcePackInfo.SERIALIZER);
            if (var7 != null) {
                ResourcePackLoader resourcePackLoader = var3.create(var0, new ChatComponentText(var6.getName()), var1, var2, var7, var4, var5);
                return resourcePackLoader;
            }
            LOGGER.warn("Couldn't find pack meta for pack {}", (Object)var0);
            return null;
        }
        catch (IOException var62) {
            LOGGER.warn("Couldn't get pack info for: {}", (Object)var62.toString());
        }
        return null;
    }

    public ResourcePackLoader(String var0, boolean var1, Supplier<IResourcePack> var2, IChatBaseComponent var3, IChatBaseComponent var4, EnumResourcePackVersion var5, Position var6, boolean var7, PackSource var8) {
        this.id = var0;
        this.supplier = var2;
        this.title = var3;
        this.description = var4;
        this.compatibility = var5;
        this.required = var1;
        this.defaultPosition = var6;
        this.fixedPosition = var7;
        this.packSource = var8;
    }

    public ResourcePackLoader(String var0, IChatBaseComponent var1, boolean var2, Supplier<IResourcePack> var3, ResourcePackInfo var4, EnumResourcePackType var5, Position var6, PackSource var7) {
        this(var0, var2, var3, var1, var4.getDescription(), EnumResourcePackVersion.forMetadata(var4, var5), var6, false, var7);
    }

    public IChatBaseComponent getTitle() {
        return this.title;
    }

    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public IChatBaseComponent getChatLink(boolean var0) {
        return ChatComponentUtils.wrapInSquareBrackets(this.packSource.decorate(new ChatComponentText(this.id))).withStyle(var1 -> var1.withColor(var0 ? EnumChatFormat.GREEN : EnumChatFormat.RED).withInsertion(StringArgumentType.escapeIfRequired((String)this.id)).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, new ChatComponentText("").append(this.title).append("\n").append(this.description))));
    }

    public EnumResourcePackVersion getCompatibility() {
        return this.compatibility;
    }

    public IResourcePack open() {
        return this.supplier.get();
    }

    public String getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public Position getDefaultPosition() {
        return this.defaultPosition;
    }

    public PackSource getPackSource() {
        return this.packSource;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader var1 = (ResourcePackLoader)var0;
        return this.id.equals(var1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void close() {
    }

    @FunctionalInterface
    public static interface a {
        @Nullable
        public ResourcePackLoader create(String var1, IChatBaseComponent var2, boolean var3, Supplier<IResourcePack> var4, ResourcePackInfo var5, Position var6, PackSource var7);
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String var0) {
            return Enum.valueOf(Position.class, var0);
        }

        public <T> int insert(List<T> var0, T var1, Function<T, ResourcePackLoader> var2, boolean var3) {
            ResourcePackLoader var6;
            int var5;
            Position var4;
            Position position = var4 = var3 ? this.opposite() : this;
            if (var4 == BOTTOM) {
                ResourcePackLoader var62;
                int var52;
                for (var52 = 0; var52 < var0.size() && (var62 = var2.apply(var0.get(var52))).isFixedPosition() && var62.getDefaultPosition() == this; ++var52) {
                }
                var0.add(var52, var1);
                return var52;
            }
            for (var5 = var0.size() - 1; var5 >= 0 && (var6 = var2.apply(var0.get(var5))).isFixedPosition() && var6.getDefaultPosition() == this; --var5) {
            }
            var0.add(var5 + 1, var1);
            return var5 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            c = Position.b();
        }
    }
}

