/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.world.level.ChunkCoordIntPair;

public class TickingTracker
extends ChunkMap {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    protected final Long2ByteMap chunks = new Long2ByteOpenHashMap();
    private final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();

    public TickingTracker() {
        super(34, 16, 256);
        this.chunks.defaultReturnValue((byte)33);
    }

    private ArraySetSorted<Ticket<?>> getTickets(long var02) {
        return (ArraySetSorted)this.tickets.computeIfAbsent(var02, var0 -> ArraySetSorted.create(4));
    }

    private int getTicketLevelAt(ArraySetSorted<Ticket<?>> var0) {
        return var0.isEmpty() ? 34 : var0.first().getTicketLevel();
    }

    public void addTicket(long var0, Ticket<?> var2) {
        ArraySetSorted<Ticket<?>> var3 = this.getTickets(var0);
        int var4 = this.getTicketLevelAt(var3);
        var3.add(var2);
        if (var2.getTicketLevel() < var4) {
            this.update(var0, var2.getTicketLevel(), true);
        }
    }

    public void removeTicket(long var0, Ticket<?> var2) {
        ArraySetSorted<Ticket<?>> var3 = this.getTickets(var0);
        var3.remove(var2);
        if (var3.isEmpty()) {
            this.tickets.remove(var0);
        }
        this.update(var0, this.getTicketLevelAt(var3), false);
    }

    public <T> void addTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        this.addTicket(var1.toLong(), new Ticket<T>(var0, var2, var3));
    }

    public <T> void removeTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        Ticket<T> var4 = new Ticket<T>(var0, var2, var3);
        this.removeTicket(var1.toLong(), var4);
    }

    public void replacePlayerTicketsLevel(int var0) {
        ArrayList<Pair> var1 = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket var5 : (ArraySetSorted)entry.getValue()) {
                if (var5.getType() != TicketType.PLAYER) continue;
                var1.add(Pair.of((Object)var5, (Object)entry.getLongKey()));
            }
        }
        for (Pair pair : var1) {
            Ticket var5;
            Long var4 = (Long)pair.getSecond();
            var5 = (Ticket)pair.getFirst();
            this.removeTicket(var4, var5);
            ChunkCoordIntPair var6 = new ChunkCoordIntPair(var4);
            TicketType var7 = var5.getType();
            this.addTicket(var7, var6, var0, var6);
        }
    }

    @Override
    protected int getLevelFromSource(long var0) {
        ArraySetSorted var2 = (ArraySetSorted)this.tickets.get(var0);
        if (var2 == null || var2.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return ((Ticket)var2.first()).getTicketLevel();
    }

    public int getLevel(ChunkCoordIntPair var0) {
        return this.getLevel(var0.toLong());
    }

    @Override
    protected int getLevel(long var0) {
        return this.chunks.get(var0);
    }

    @Override
    protected void setLevel(long var0, int var2) {
        if (var2 > 33) {
            this.chunks.remove(var0);
        } else {
            this.chunks.put(var0, (byte)var2);
        }
    }

    public void runAllUpdates() {
        this.runUpdates(Integer.MAX_VALUE);
    }

    public String getTicketDebugString(long var0) {
        ArraySetSorted var2 = (ArraySetSorted)this.tickets.get(var0);
        if (var2 == null || var2.isEmpty()) {
            return "no_ticket";
        }
        return ((Ticket)var2.first()).toString();
    }
}

