/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.DebugBuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LightEngine;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> UNLOADED_CHUNK = Either.right((Object)Failure.UNLOADED);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    public static final Either<Chunk, Failure> UNLOADED_LEVEL_CHUNK = Either.right((Object)Failure.UNLOADED);
    private static final CompletableFuture<Either<Chunk, Failure>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private static final State[] FULL_CHUNK_STATUSES = State.values();
    private static final int BLOCKS_BEFORE_RESEND_FUDGE = 64;
    private final AtomicReferenceArray<CompletableFuture<Either<IChunkAccess, Failure>>> futures = new AtomicReferenceArray(CHUNK_STATUSES.size());
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<Either<Chunk, Failure>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<Either<Chunk, Failure>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<Either<Chunk, Failure>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private CompletableFuture<IChunkAccess> chunkToSave = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<b> chunkToSaveHistory = null;
    public int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    final ChunkCoordIntPair pos;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LightEngine lightEngine;
    private final d onLevelChange;
    public final e playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private boolean resendLight;
    private CompletableFuture<Void> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair var0, int var1, LevelHeightAccessor var2, LightEngine var3, d var4, e var5) {
        this.pos = var0;
        this.levelHeightAccessor = var2;
        this.lightEngine = var3;
        this.onLevelChange = var4;
        this.playerProvider = var5;
        this.ticketLevel = this.oldTicketLevel = PlayerChunkMap.MAX_CHUNK_DISTANCE + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel(var1);
        this.changedBlocksPerSection = new ShortSet[var2.getSectionsCount()];
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getFutureIfPresentUnchecked(ChunkStatus var0) {
        CompletableFuture<Either<IChunkAccess, Failure>> var1 = this.futures.get(var0.getIndex());
        return var1 == null ? UNLOADED_CHUNK_FUTURE : var1;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getFutureIfPresent(ChunkStatus var0) {
        if (PlayerChunk.getStatus(this.ticketLevel).isOrAfter(var0)) {
            return this.getFutureIfPresentUnchecked(var0);
        }
        return UNLOADED_CHUNK_FUTURE;
    }

    public CompletableFuture<Either<Chunk, Failure>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<Either<Chunk, Failure>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<Either<Chunk, Failure>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public Chunk getTickingChunk() {
        CompletableFuture<Either<Chunk, Failure>> var0 = this.getTickingChunkFuture();
        Either var1 = var0.getNow(null);
        if (var1 == null) {
            return null;
        }
        return var1.left().orElse(null);
    }

    @Nullable
    public ChunkStatus getLastAvailableStatus() {
        for (int var0 = CHUNK_STATUSES.size() - 1; var0 >= 0; --var0) {
            ChunkStatus var1 = CHUNK_STATUSES.get(var0);
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.getFutureIfPresentUnchecked(var1);
            if (!var2.getNow(UNLOADED_CHUNK).left().isPresent()) continue;
            return var1;
        }
        return null;
    }

    @Nullable
    public IChunkAccess getLastAvailable() {
        for (int var0 = CHUNK_STATUSES.size() - 1; var0 >= 0; --var0) {
            Optional var3;
            ChunkStatus var1 = CHUNK_STATUSES.get(var0);
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.getFutureIfPresentUnchecked(var1);
            if (var2.isCompletedExceptionally() || !(var3 = var2.getNow(UNLOADED_CHUNK).left()).isPresent()) continue;
            return (IChunkAccess)var3.get();
        }
        return null;
    }

    public CompletableFuture<IChunkAccess> getChunkToSave() {
        return this.chunkToSave;
    }

    public void blockChanged(BlockPosition var0) {
        Chunk var1 = this.getTickingChunk();
        if (var1 == null) {
            return;
        }
        int var2 = this.levelHeightAccessor.getSectionIndex(var0.getY());
        if (this.changedBlocksPerSection[var2] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[var2] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[var2].add(SectionPosition.sectionRelativePos(var0));
    }

    public void sectionLightChanged(EnumSkyBlock var0, int var1) {
        Chunk var2 = this.getTickingChunk();
        if (var2 == null) {
            return;
        }
        var2.setUnsaved(true);
        int var3 = this.lightEngine.getMinLightSection();
        int var4 = this.lightEngine.getMaxLightSection();
        if (var1 < var3 || var1 > var4) {
            return;
        }
        int var5 = var1 - var3;
        if (var0 == EnumSkyBlock.SKY) {
            this.skyChangedLightSectionFilter.set(var5);
        } else {
            this.blockChangedLightSectionFilter.set(var5);
        }
    }

    public void broadcastChanges(Chunk var0) {
        int var3;
        if (!this.hasChangedSections && this.skyChangedLightSectionFilter.isEmpty() && this.blockChangedLightSectionFilter.isEmpty()) {
            return;
        }
        World var12 = var0.getLevel();
        int var22 = 0;
        for (var3 = 0; var3 < this.changedBlocksPerSection.length; ++var3) {
            var22 += this.changedBlocksPerSection[var3] != null ? this.changedBlocksPerSection[var3].size() : 0;
        }
        this.resendLight |= var22 >= 64;
        if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            this.broadcast(new PacketPlayOutLightUpdate(var0.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter, true), !this.resendLight);
            this.skyChangedLightSectionFilter.clear();
            this.blockChangedLightSectionFilter.clear();
        }
        for (var3 = 0; var3 < this.changedBlocksPerSection.length; ++var3) {
            ShortSet var4 = this.changedBlocksPerSection[var3];
            if (var4 == null) continue;
            int var5 = this.levelHeightAccessor.getSectionYFromSectionIndex(var3);
            SectionPosition var6 = SectionPosition.of(var0.getPos(), var5);
            if (var4.size() == 1) {
                var7 = var6.relativeToBlockPos(var4.iterator().nextShort());
                var8 = var12.getBlockState((BlockPosition)var7);
                this.broadcast(new PacketPlayOutBlockChange((BlockPosition)var7, (IBlockData)var8), false);
                this.broadcastBlockEntityIfNeeded(var12, (BlockPosition)var7, (IBlockData)var8);
            } else {
                var7 = var0.getSection(var3);
                var8 = new PacketPlayOutMultiBlockChange(var6, var4, (ChunkSection)var7, this.resendLight);
                this.broadcast((Packet<?>)var8, false);
                ((PacketPlayOutMultiBlockChange)var8).runUpdates((var1, var2) -> this.broadcastBlockEntityIfNeeded(var12, (BlockPosition)var1, (IBlockData)var2));
            }
            this.changedBlocksPerSection[var3] = null;
        }
        this.hasChangedSections = false;
    }

    private void broadcastBlockEntityIfNeeded(World var0, BlockPosition var1, IBlockData var2) {
        if (var2.hasBlockEntity()) {
            this.broadcastBlockEntity(var0, var1);
        }
    }

    private void broadcastBlockEntity(World var0, BlockPosition var1) {
        Packet<PacketListenerPlayOut> var3;
        TileEntity var2 = var0.getBlockEntity(var1);
        if (var2 != null && (var3 = var2.getUpdatePacket()) != null) {
            this.broadcast(var3, false);
        }
    }

    private void broadcast(Packet<?> var0, boolean var12) {
        this.playerProvider.getPlayers(this.pos, var12).forEach(var1 -> var1.connection.send(var0));
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getOrScheduleFuture(ChunkStatus var0, PlayerChunkMap var1) {
        Object var4;
        int var2 = var0.getIndex();
        CompletableFuture<Either<IChunkAccess, Failure>> var3 = this.futures.get(var2);
        if (var3 != null) {
            boolean var5;
            var4 = var3.getNow(null);
            boolean bl = var5 = var4 != null && var4.right().isPresent();
            if (!var5) {
                return var3;
            }
        }
        if (PlayerChunk.getStatus(this.ticketLevel).isOrAfter(var0)) {
            var4 = var1.schedule(this, var0);
            this.updateChunkToSave((CompletableFuture<? extends Either<? extends IChunkAccess, Failure>>)var4, "schedule " + var0);
            this.futures.set(var2, (CompletableFuture<Either<IChunkAccess, Failure>>)var4);
            return var4;
        }
        return var3 == null ? UNLOADED_CHUNK_FUTURE : var3;
    }

    protected void addSaveDependency(String var02, CompletableFuture<?> var12) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new b(Thread.currentThread(), var12, var02));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(var12, (var0, var1) -> var0);
    }

    private void updateChunkToSave(CompletableFuture<? extends Either<? extends IChunkAccess, Failure>> var0, String var1) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new b(Thread.currentThread(), var0, var1));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(var0, (var02, var12) -> (IChunkAccess)var12.map(var0 -> var0, var1 -> var02));
    }

    public State getFullStatus() {
        return PlayerChunk.getFullChunkStatus(this.ticketLevel);
    }

    public ChunkCoordIntPair getPos() {
        return this.pos;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int var0) {
        this.queueLevel = var0;
    }

    public void setTicketLevel(int var0) {
        this.ticketLevel = var0;
    }

    private void scheduleFullChunkPromotion(PlayerChunkMap var0, CompletableFuture<Either<Chunk, Failure>> var1, Executor var2, State var3) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture var4 = new CompletableFuture();
        var4.thenRunAsync(() -> var0.onFullChunkStatusChange(this.pos, var3), var2);
        this.pendingFullStateConfirmation = var4;
        var1.thenAccept(var12 -> var12.ifLeft(var1 -> var4.complete(null)));
    }

    private void demoteFullChunk(PlayerChunkMap var0, State var1) {
        this.pendingFullStateConfirmation.cancel(false);
        var0.onFullChunkStatusChange(this.pos, var1);
    }

    protected void updateFutures(PlayerChunkMap var0, Executor var1) {
        int var9;
        ChunkStatus var2 = PlayerChunk.getStatus(this.oldTicketLevel);
        ChunkStatus var3 = PlayerChunk.getStatus(this.ticketLevel);
        boolean var4 = this.oldTicketLevel <= PlayerChunkMap.MAX_CHUNK_DISTANCE;
        boolean var5 = this.ticketLevel <= PlayerChunkMap.MAX_CHUNK_DISTANCE;
        State var6 = PlayerChunk.getFullChunkStatus(this.oldTicketLevel);
        State var7 = PlayerChunk.getFullChunkStatus(this.ticketLevel);
        if (var4) {
            Either var8 = Either.right((Object)new Failure(){

                public String toString() {
                    return "Unloaded ticket level " + PlayerChunk.this.pos;
                }
            });
            int n2 = var9 = var5 ? var3.getIndex() + 1 : 0;
            while (var9 <= var2.getIndex()) {
                CompletableFuture<Either<IChunkAccess, Failure>> var10 = this.futures.get(var9);
                if (var10 == null) {
                    this.futures.set(var9, CompletableFuture.completedFuture(var8));
                }
                ++var9;
            }
        }
        boolean var8 = var6.isOrAfter(State.BORDER);
        var9 = var7.isOrAfter(State.BORDER);
        this.wasAccessibleSinceLastSave |= var9;
        if (!var8 && var9 != 0) {
            this.fullChunkFuture = var0.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion(var0, this.fullChunkFuture, var1, State.BORDER);
            this.updateChunkToSave(this.fullChunkFuture, "full");
        }
        if (var8 && var9 == 0) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var10 = var6.isOrAfter(State.TICKING);
        boolean var11 = var7.isOrAfter(State.TICKING);
        if (!var10 && var11) {
            this.tickingChunkFuture = var0.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion(var0, this.tickingChunkFuture, var1, State.TICKING);
            this.updateChunkToSave(this.tickingChunkFuture, "ticking");
        }
        if (var10 && !var11) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var12 = var6.isOrAfter(State.ENTITY_TICKING);
        boolean var13 = var7.isOrAfter(State.ENTITY_TICKING);
        if (!var12 && var13) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw SystemUtils.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = var0.prepareEntityTickingChunk(this.pos);
            this.scheduleFullChunkPromotion(var0, this.entityTickingChunkFuture, var1, State.ENTITY_TICKING);
            this.updateChunkToSave(this.entityTickingChunkFuture, "entity ticking");
        }
        if (var12 && !var13) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!var7.isOrAfter(var6)) {
            this.demoteFullChunk(var0, var7);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
    }

    public static ChunkStatus getStatus(int var0) {
        if (var0 < 33) {
            return ChunkStatus.FULL;
        }
        return ChunkStatus.getStatusAroundFullChunk(var0 - 33);
    }

    public static State getFullChunkStatus(int var0) {
        return FULL_CHUNK_STATUSES[MathHelper.clamp(33 - var0 + 1, 0, FULL_CHUNK_STATUSES.length - 1)];
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = PlayerChunk.getFullChunkStatus(this.ticketLevel).isOrAfter(State.BORDER);
    }

    public void replaceProtoChunk(ProtoChunkExtension var0) {
        for (int var1 = 0; var1 < this.futures.length(); ++var1) {
            Optional var3;
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.futures.get(var1);
            if (var2 == null || !(var3 = var2.getNow(UNLOADED_CHUNK).left()).isPresent() || !(var3.get() instanceof ProtoChunk)) continue;
            this.futures.set(var1, CompletableFuture.completedFuture(Either.left((Object)var0)));
        }
        this.updateChunkToSave(CompletableFuture.completedFuture(Either.left((Object)var0.getWrapped())), "replaceProto");
    }

    @FunctionalInterface
    public static interface d {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface e {
        public List<EntityPlayer> getPlayers(ChunkCoordIntPair var1, boolean var2);
    }

    static final class b {
        private final Thread thread;
        private final CompletableFuture<?> future;
        private final String source;

        b(Thread var0, CompletableFuture<?> var1, String var2) {
            this.thread = var0;
            this.future = var1;
            this.source = var2;
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INACCESSIBLE = new State();
        public static final /* enum */ State BORDER = new State();
        public static final /* enum */ State TICKING = new State();
        public static final /* enum */ State ENTITY_TICKING = new State();
        private static final /* synthetic */ State[] e;

        public static State[] values() {
            return (State[])e.clone();
        }

        public static State valueOf(String var0) {
            return Enum.valueOf(State.class, var0);
        }

        public boolean isOrAfter(State var0) {
            return this.ordinal() >= var0.ordinal();
        }

        private static /* synthetic */ State[] a() {
            return new State[]{INACCESSIBLE, BORDER, TICKING, ENTITY_TICKING};
        }

        static {
            e = State.a();
        }
    }

    public static interface Failure {
        public static final Failure UNLOADED = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

