/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class DemoPlayerInteractManager
extends PlayerInteractManager {
    public static final int DEMO_DAYS = 5;
    public static final int TOTAL_PLAY_TICKS = 120500;
    private boolean displayedIntro;
    private boolean demoHasEnded;
    private int demoEndedReminder;
    private int gameModeTicks;

    public DemoPlayerInteractManager(EntityPlayer var0) {
        super(var0);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.gameModeTicks;
        long var0 = this.level.getGameTime();
        long var2 = var0 / 24000L + 1L;
        if (!this.displayedIntro && this.gameModeTicks > 20) {
            this.displayedIntro = true;
            this.player.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.DEMO_EVENT, 0.0f));
        }
        boolean bl = this.demoHasEnded = var0 > 120500L;
        if (this.demoHasEnded) {
            ++this.demoEndedReminder;
        }
        if (var0 % 24000L == 500L) {
            if (var2 <= 6L) {
                if (var2 == 6L) {
                    this.player.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.DEMO_EVENT, 104.0f));
                } else {
                    this.player.sendMessage(new ChatMessage("demo.day." + var2), SystemUtils.NIL_UUID);
                }
            }
        } else if (var2 == 1L) {
            if (var0 == 100L) {
                this.player.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.DEMO_EVENT, 101.0f));
            } else if (var0 == 175L) {
                this.player.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.DEMO_EVENT, 102.0f));
            } else if (var0 == 250L) {
                this.player.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.DEMO_EVENT, 103.0f));
            }
        } else if (var2 == 5L && var0 % 24000L == 22000L) {
            this.player.sendMessage(new ChatMessage("demo.day.warning"), SystemUtils.NIL_UUID);
        }
    }

    private void outputDemoReminder() {
        if (this.demoEndedReminder > 100) {
            this.player.sendMessage(new ChatMessage("demo.reminder"), SystemUtils.NIL_UUID);
            this.demoEndedReminder = 0;
        }
    }

    @Override
    public void handleBlockBreakAction(BlockPosition var0, PacketPlayInBlockDig.EnumPlayerDigType var1, EnumDirection var2, int var3) {
        if (this.demoHasEnded) {
            this.outputDemoReminder();
            return;
        }
        super.handleBlockBreakAction(var0, var1, var2, var3);
    }

    @Override
    public EnumInteractionResult useItem(EntityPlayer var0, World var1, ItemStack var2, EnumHand var3) {
        if (this.demoHasEnded) {
            this.outputDemoReminder();
            return EnumInteractionResult.PASS;
        }
        return super.useItem(var0, var1, var2, var3);
    }

    @Override
    public EnumInteractionResult useItemOn(EntityPlayer var0, World var1, ItemStack var2, EnumHand var3, MovingObjectPositionBlock var4) {
        if (this.demoHasEnded) {
            this.outputDemoReminder();
            return EnumInteractionResult.PASS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4);
    }
}

