/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.world.level.biome.BiomeBase;

public class CommandLocateBiome {
    public static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locatebiome.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locatebiome.notFound", var0));
    private static final int MAX_SEARCH_RADIUS = 6400;
    private static final int SEARCH_STEP = 8;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locatebiome").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("biome", ArgumentMinecraftKeyRegistered.id()).suggests(CompletionProviders.AVAILABLE_BIOMES).executes(var0 -> CommandLocateBiome.locateBiome((CommandListenerWrapper)var0.getSource(), (MinecraftKey)var0.getArgument("biome", MinecraftKey.class)))));
    }

    private static int locateBiome(CommandListenerWrapper var0, MinecraftKey var1) throws CommandSyntaxException {
        BiomeBase var2 = var0.getServer().registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY).getOptional(var1).orElseThrow(() -> ERROR_INVALID_BIOME.create((Object)var1));
        BlockPosition var3 = new BlockPosition(var0.getPosition());
        BlockPosition var4 = var0.getLevel().findNearestBiome(var2, var3, 6400, 8);
        String var5 = var1.toString();
        if (var4 == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)var5);
        }
        return CommandLocate.showLocateResult(var0, var5, var3, var4, "commands.locatebiome.success");
    }
}

