/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandDebug {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType ERROR_NOT_RUNNING = new SimpleCommandExceptionType((Message)new ChatMessage("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_RUNNING = new SimpleCommandExceptionType((Message)new ChatMessage("commands.debug.alreadyRunning"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("debug").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("start").executes(var0 -> CommandDebug.start((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> CommandDebug.stop((CommandListenerWrapper)var0.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("function").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(CommandFunction.SUGGEST_FUNCTION).executes(var0 -> CommandDebug.traceFunction((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var0, "name"))))));
    }

    private static int start(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (var1.isTimeProfilerRunning()) {
            throw ERROR_ALREADY_RUNNING.create();
        }
        var1.startTimeProfiler();
        var0.sendSuccess(new ChatMessage("commands.debug.started"), true);
        return 0;
    }

    private static int stop(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (!var1.isTimeProfilerRunning()) {
            throw ERROR_NOT_RUNNING.create();
        }
        MethodProfilerResults var2 = var1.stopTimeProfiler();
        double var3 = (double)var2.getNanoDuration() / (double)TimeRange.NANOSECONDS_PER_SECOND;
        double var5 = (double)var2.getTickDuration() / var3;
        var0.sendSuccess(new ChatMessage("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", var3), var2.getTickDuration(), String.format("%.2f", var5)), true);
        return (int)var5;
    }

    private static int traceFunction(CommandListenerWrapper var0, Collection<CustomFunction> var1) {
        int var2 = 0;
        MinecraftServer var3 = var0.getServer();
        String var4 = "debug-trace-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt";
        try {
            Path var5 = var3.getFile("debug").toPath();
            Files.createDirectories(var5, new FileAttribute[0]);
            try (BufferedWriter var6 = Files.newBufferedWriter(var5.resolve(var4), StandardCharsets.UTF_8, new OpenOption[0]);){
                PrintWriter var7 = new PrintWriter(var6);
                for (CustomFunction var9 : var1) {
                    var7.println(var9.getId());
                    a var10 = new a(var7);
                    var2 += var0.getServer().getFunctions().execute(var9, var0.withSource(var10).withMaximumPermission(2), var10);
                }
            }
        }
        catch (IOException | UncheckedIOException var5) {
            LOGGER.warn("Tracing failed", (Throwable)var5);
            var0.sendFailure(new ChatMessage("commands.debug.function.traceFailed"));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(new ChatMessage("commands.debug.function.success.single", var2, var1.iterator().next().getId(), var4), true);
        } else {
            var0.sendSuccess(new ChatMessage("commands.debug.function.success.multiple", var2, var1.size(), var4), true);
        }
        return var2;
    }

    static class a
    implements ICommandListener,
    CustomFunctionData.c {
        public static final int INDENT_OFFSET = 1;
        private final PrintWriter output;
        private int lastIndent;
        private boolean waitingForResult;

        a(PrintWriter var0) {
            this.output = var0;
        }

        private void indentAndSave(int var0) {
            this.printIndent(var0);
            this.lastIndent = var0;
        }

        private void printIndent(int var0) {
            for (int var1 = 0; var1 < var0 + 1; ++var1) {
                this.output.write("    ");
            }
        }

        private void newLine() {
            if (this.waitingForResult) {
                this.output.println();
                this.waitingForResult = false;
            }
        }

        @Override
        public void onCommand(int var0, String var1) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[C] ");
            this.output.print(var1);
            this.waitingForResult = true;
        }

        @Override
        public void onReturn(int var0, String var1, int var2) {
            if (this.waitingForResult) {
                this.output.print(" -> ");
                this.output.println(var2);
                this.waitingForResult = false;
            } else {
                this.indentAndSave(var0);
                this.output.print("[R = ");
                this.output.print(var2);
                this.output.print("] ");
                this.output.println(var1);
            }
        }

        @Override
        public void onCall(int var0, MinecraftKey var1, int var2) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[F] ");
            this.output.print(var1);
            this.output.print(" size=");
            this.output.println(var2);
        }

        @Override
        public void onError(int var0, String var1) {
            this.newLine();
            this.indentAndSave(var0 + 1);
            this.output.print("[E] ");
            this.output.print(var1);
        }

        @Override
        public void sendMessage(IChatBaseComponent var0, UUID var1) {
            this.newLine();
            this.printIndent(this.lastIndent + 1);
            this.output.print("[M] ");
            if (var1 != SystemUtils.NIL_UUID) {
                this.output.print(var1);
                this.output.print(": ");
            }
            this.output.println(var0.getString());
        }

        @Override
        public boolean acceptsSuccess() {
            return true;
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }

        @Override
        public boolean alwaysAccepts() {
            return true;
        }
    }
}

