/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;

public class CommandDatapack {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PACK = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.datapack.unknown", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_ENABLED = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.datapack.enable.failed", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_DISABLED = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.datapack.disable.failed", var0));
    private static final SuggestionProvider<CommandListenerWrapper> SELECTED_PACKS = (var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository().getSelectedIds().stream().map(StringArgumentType::escapeIfRequired), var1);
    private static final SuggestionProvider<CommandListenerWrapper> UNSELECTED_PACKS = (var0, var12) -> {
        ResourcePackRepository var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository();
        Collection<String> var3 = var2.getSelectedIds();
        return ICompletionProvider.suggest(var2.getAvailableIds().stream().filter(var1 -> !var3.contains(var1)).map(StringArgumentType::escapeIfRequired), var12);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("datapack").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.string()).suggests(UNSELECTED_PACKS).executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), (var02, var1) -> var1.getDefaultPosition().insert(var02, var1, var0 -> var0, false)))).then(net.minecraft.commands.CommandDispatcher.literal("after").then(net.minecraft.commands.CommandDispatcher.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), (var1, var2) -> var1.add(var1.indexOf(CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "existing", false)) + 1, var2)))))).then(net.minecraft.commands.CommandDispatcher.literal("before").then(net.minecraft.commands.CommandDispatcher.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), (var1, var2) -> var1.add(var1.indexOf(CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "existing", false)), var2)))))).then(net.minecraft.commands.CommandDispatcher.literal("last").executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.literal("first").executes(var02 -> CommandDatapack.enablePack((CommandListenerWrapper)var02.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var02, "name", true), (var0, var1) -> var0.add(0, var1))))))).then(net.minecraft.commands.CommandDispatcher.literal("disable").then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.disablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandDatapack.listPacks((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.literal("available").executes(var0 -> CommandDatapack.listAvailablePacks((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("enabled").executes(var0 -> CommandDatapack.listEnabledPacks((CommandListenerWrapper)var0.getSource())))));
    }

    private static int enablePack(CommandListenerWrapper var0, ResourcePackLoader var1, a var2) throws CommandSyntaxException {
        ResourcePackRepository var3 = var0.getServer().getPackRepository();
        ArrayList var4 = Lists.newArrayList(var3.getSelectedPacks());
        var2.apply(var4, var1);
        var0.sendSuccess(new ChatMessage("commands.datapack.modify.enable", var1.getChatLink(true)), true);
        CommandReload.reloadPacks(var4.stream().map(ResourcePackLoader::getId).collect(Collectors.toList()), var0);
        return var4.size();
    }

    private static int disablePack(CommandListenerWrapper var0, ResourcePackLoader var1) {
        ResourcePackRepository var2 = var0.getServer().getPackRepository();
        ArrayList var3 = Lists.newArrayList(var2.getSelectedPacks());
        var3.remove(var1);
        var0.sendSuccess(new ChatMessage("commands.datapack.modify.disable", var1.getChatLink(true)), true);
        CommandReload.reloadPacks(var3.stream().map(ResourcePackLoader::getId).collect(Collectors.toList()), var0);
        return var3.size();
    }

    private static int listPacks(CommandListenerWrapper var0) {
        return CommandDatapack.listEnabledPacks(var0) + CommandDatapack.listAvailablePacks(var0);
    }

    private static int listAvailablePacks(CommandListenerWrapper var02) {
        ResourcePackRepository var12 = var02.getServer().getPackRepository();
        var12.reload();
        Collection<ResourcePackLoader> var2 = var12.getSelectedPacks();
        Collection<ResourcePackLoader> var3 = var12.getAvailablePacks();
        List var4 = var3.stream().filter(var1 -> !var2.contains(var1)).collect(Collectors.toList());
        if (var4.isEmpty()) {
            var02.sendSuccess(new ChatMessage("commands.datapack.list.available.none"), false);
        } else {
            var02.sendSuccess(new ChatMessage("commands.datapack.list.available.success", var4.size(), ChatComponentUtils.formatList(var4, var0 -> var0.getChatLink(false))), false);
        }
        return var4.size();
    }

    private static int listEnabledPacks(CommandListenerWrapper var02) {
        ResourcePackRepository var1 = var02.getServer().getPackRepository();
        var1.reload();
        Collection<ResourcePackLoader> var2 = var1.getSelectedPacks();
        if (var2.isEmpty()) {
            var02.sendSuccess(new ChatMessage("commands.datapack.list.enabled.none"), false);
        } else {
            var02.sendSuccess(new ChatMessage("commands.datapack.list.enabled.success", var2.size(), ChatComponentUtils.formatList(var2, var0 -> var0.getChatLink(true))), false);
        }
        return var2.size();
    }

    private static ResourcePackLoader getPack(CommandContext<CommandListenerWrapper> var0, String var1, boolean var2) throws CommandSyntaxException {
        String var3 = StringArgumentType.getString(var0, (String)var1);
        ResourcePackRepository var4 = ((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository();
        ResourcePackLoader var5 = var4.getPack(var3);
        if (var5 == null) {
            throw ERROR_UNKNOWN_PACK.create((Object)var3);
        }
        boolean var6 = var4.getSelectedPacks().contains(var5);
        if (var2 && var6) {
            throw ERROR_PACK_ALREADY_ENABLED.create((Object)var3);
        }
        if (!var2 && !var6) {
            throw ERROR_PACK_ALREADY_DISABLED.create((Object)var3);
        }
        return var5;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

