/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger LOGGER = LogManager.getLogger();

    @DontObfuscate
    public static void main(String[] var0) {
        SharedConstants.tryDetectVersion();
        OptionParser var1 = new OptionParser();
        OptionSpecBuilder var2 = var1.accepts("nogui");
        OptionSpecBuilder var3 = var1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder var4 = var1.accepts("demo");
        OptionSpecBuilder var5 = var1.accepts("bonusChest");
        OptionSpecBuilder var6 = var1.accepts("forceUpgrade");
        OptionSpecBuilder var7 = var1.accepts("eraseCache");
        OptionSpecBuilder var8 = var1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec var9 = var1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec var10 = var1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec var11 = var1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec var12 = var1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec var13 = var1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec var14 = var1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder var15 = var1.accepts("jfrProfile");
        NonOptionArgumentSpec var16 = var1.nonOptions();
        try {
            Object var42;
            Object var41;
            Object var40;
            DataPackResources var37;
            OptionSet var17 = var1.parse(var0);
            if (var17.has((OptionSpec)var9)) {
                var1.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.preload();
            if (var17.has((OptionSpec)var15)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            IRegistryCustom.Dimension var18 = IRegistryCustom.builtin();
            Path var19 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings var20 = new DedicatedServerSettings(var19);
            var20.forceSave();
            Path var21 = Paths.get("eula.txt", new String[0]);
            EULA var22 = new EULA(var21);
            if (var17.has((OptionSpec)var3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)var19.toAbsolutePath(), (Object)var21.toAbsolutePath());
                return;
            }
            if (!var22.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File var23 = new File((String)var17.valueOf((OptionSpec)var11));
            YggdrasilAuthenticationService var24 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService var25 = var24.createMinecraftSessionService();
            GameProfileRepository var26 = var24.createProfileRepository();
            UserCache var27 = new UserCache(var26, new File(var23, MinecraftServer.USERID_CACHE_FILE.getName()));
            String var28 = Optional.ofNullable((String)var17.valueOf((OptionSpec)var12)).orElse(var20.getProperties().levelName);
            Convertable var29 = Convertable.createDefault(var23.toPath());
            Convertable.ConversionSession var30 = var29.createAccess(var28);
            WorldInfo var31 = var30.getSummary();
            if (var31 != null) {
                if (var31.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!var31.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            }
            DataPackConfiguration var32 = var30.getDataPacks();
            boolean var33 = var17.has((OptionSpec)var8);
            if (var33) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository var34 = new ResourcePackRepository(EnumResourcePackType.SERVER_DATA, new ResourcePackSourceVanilla(), new ResourcePackSourceFolder(var30.getLevelPath(SavedFile.DATAPACK_DIR).toFile(), PackSource.WORLD));
            DataPackConfiguration var35 = MinecraftServer.configurePackRepository(var34, var32 == null ? DataPackConfiguration.DEFAULT : var32, var33);
            CompletableFuture<DataPackResources> var36 = DataPackResources.loadResources(var34.openAllSelected(), var18, CommandDispatcher.ServerType.DEDICATED, var20.getProperties().functionPermissionLevel, SystemUtils.backgroundExecutor(), Runnable::run);
            try {
                var37 = var36.get();
            }
            catch (Exception var38) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var38);
                var34.close();
                return;
            }
            var37.updateGlobals();
            RegistryReadOps<NBTBase> var38 = RegistryReadOps.createAndLoad(DynamicOpsNBT.INSTANCE, var37.getResourceManager(), (IRegistryCustom)var18);
            var20.getProperties().getWorldGenSettings(var18);
            SaveData var39 = var30.getDataTag(var38, var35);
            if (var39 == null) {
                if (var17.has((OptionSpec)var4)) {
                    var40 = MinecraftServer.DEMO_SETTINGS;
                    var41 = GeneratorSettings.demoSettings(var18);
                } else {
                    var42 = var20.getProperties();
                    var40 = new WorldSettings(((DedicatedServerProperties)var42).levelName, ((DedicatedServerProperties)var42).gamemode, ((DedicatedServerProperties)var42).hardcore, ((DedicatedServerProperties)var42).difficulty, false, new GameRules(), var35);
                    var41 = var17.has((OptionSpec)var5) ? ((DedicatedServerProperties)var42).getWorldGenSettings(var18).withBonusChest() : ((DedicatedServerProperties)var42).getWorldGenSettings(var18);
                }
                var39 = new WorldDataServer((WorldSettings)var40, (GeneratorSettings)var41, Lifecycle.stable());
            }
            if (var17.has((OptionSpec)var6)) {
                Main.forceUpgrade(var30, DataConverterRegistry.getDataFixer(), var17.has((OptionSpec)var7), () -> true, var39.worldGenSettings());
            }
            var30.saveDataTag(var18, var39);
            var40 = var39;
            var41 = MinecraftServer.spin(arg_0 -> Main.a(var18, var30, var34, var37, (SaveData)var40, var20, var25, var26, var27, var17, (OptionSpec)var10, (OptionSpec)var13, (OptionSpec)var4, (OptionSpec)var14, (OptionSpec)var2, (OptionSpec)var16, arg_0));
            var42 = new Thread("Server Shutdown Thread", (DedicatedServer)var41){
                final /* synthetic */ DedicatedServer a;
                {
                    this.a = dedicatedServer;
                    super(var0);
                }

                @Override
                public void run() {
                    this.a.halt(true);
                }
            };
            ((Thread)var42).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook((Thread)var42);
        }
        catch (Exception var17) {
            LOGGER.fatal("Failed to start the minecraft server", (Throwable)var17);
        }
    }

    public static void forceUpgrade(Convertable.ConversionSession var0, DataFixer var1, boolean var2, BooleanSupplier var3, GeneratorSettings var4) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader var5 = new WorldUpgrader(var0, var1, var4, var2);
        IChatBaseComponent var6 = null;
        while (!var5.isFinished()) {
            int var8;
            IChatBaseComponent var7 = var5.getStatus();
            if (var6 != var7) {
                var6 = var7;
                LOGGER.info(var5.getStatus().getString());
            }
            if ((var8 = var5.getTotalChunks()) > 0) {
                int var9 = var5.getConverted() + var5.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.floor((float)var9 / (float)var8 * 100.0f), (Object)var9, (Object)var8);
            }
            if (!var3.getAsBoolean()) {
                var5.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer a(IRegistryCustom.Dimension var0, Convertable.ConversionSession var1, ResourcePackRepository var2, DataPackResources var3, SaveData var4, DedicatedServerSettings var5, MinecraftSessionService var6, GameProfileRepository var7, UserCache var8, OptionSet var9, OptionSpec var10, OptionSpec var11, OptionSpec var12, OptionSpec var13, OptionSpec var14, OptionSpec var15, Thread var16) {
        boolean var18;
        DedicatedServer var17 = new DedicatedServer(var16, var0, var1, var2, var3, var4, var5, DataConverterRegistry.getDataFixer(), var6, var7, var8, WorldLoadListenerLogger::new);
        var17.setSingleplayerName((String)var9.valueOf(var10));
        var17.setPort((Integer)var9.valueOf(var11));
        var17.setDemo(var9.has(var12));
        var17.setId((String)var9.valueOf(var13));
        boolean bl = var18 = !var9.has(var14) && !var9.valuesOf(var15).contains("nogui");
        if (var18 && !GraphicsEnvironment.isHeadless()) {
            var17.showGui();
        }
        return var17;
    }
}

