/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.resources.ResourceKey;

public final class RegistryFileCodec<E>
implements Codec<Supplier<E>> {
    private final ResourceKey<? extends IRegistry<E>> registryKey;
    private final Codec<E> elementCodec;
    private final boolean allowInline;

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1) {
        return RegistryFileCodec.create(var0, var1, true);
    }

    public static <E> Codec<List<Supplier<E>>> homogeneousList(ResourceKey<? extends IRegistry<E>> var03, Codec<E> var1) {
        return Codec.either((Codec)RegistryFileCodec.create(var03, var1, false).listOf(), (Codec)var1.xmap(var0 -> () -> var0, Supplier::get).listOf()).xmap(var02 -> (List)var02.map(var0 -> var0, var0 -> var0), Either::left);
    }

    private static <E> RegistryFileCodec<E> create(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        return new RegistryFileCodec<E>(var0, var1, var2);
    }

    private RegistryFileCodec(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        this.registryKey = var0;
        this.elementCodec = var1;
        this.allowInline = var2;
    }

    public <T> DataResult<T> encode(Supplier<E> var0, DynamicOps<T> var1, T var2) {
        if (var1 instanceof RegistryWriteOps) {
            return ((RegistryWriteOps)var1).encode(var0.get(), var2, this.registryKey, this.elementCodec);
        }
        return this.elementCodec.encode(var0.get(), var1, var2);
    }

    public <T> DataResult<Pair<Supplier<E>, T>> decode(DynamicOps<T> var0, T var1) {
        if (var0 instanceof RegistryReadOps) {
            return ((RegistryReadOps)var0).decodeElement(var1, this.registryKey, this.elementCodec, this.allowInline);
        }
        return this.elementCodec.decode(var0, var1).map(var02 -> var02.mapFirst(var0 -> () -> var0));
    }

    public String toString() {
        return "RegistryFileCodec[" + this.registryKey + " " + this.elementCodec + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((Supplier)object, dynamicOps, object2);
    }
}

