/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.google.common.collect.Lists;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataWatcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> ENTITY_ID_POOL = new Object2IntOpenHashMap();
    private static final int EOF_MARKER = 255;
    private static final int MAX_ID_VALUE = 254;
    private final Entity entity;
    private final Int2ObjectMap<Item<?>> itemsById = new Int2ObjectOpenHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isEmpty = true;
    private boolean isDirty;

    public DataWatcher(Entity var0) {
        this.entity = var0;
    }

    public static <T> DataWatcherObject<T> defineId(Class<? extends Entity> var0, DataWatcherSerializer<T> var1) {
        int var2;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> var22 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!var22.equals(var0)) {
                    LOGGER.debug("defineId called for: {} from {}", var0, var22, (Object)new RuntimeException());
                }
            }
            catch (ClassNotFoundException var22) {
                // empty catch block
            }
        }
        if (ENTITY_ID_POOL.containsKey(var0)) {
            var2 = ENTITY_ID_POOL.getInt(var0) + 1;
        } else {
            int var3 = 0;
            Class<? extends Entity> var4 = var0;
            while (var4 != Entity.class) {
                if (!ENTITY_ID_POOL.containsKey(var4 = var4.getSuperclass())) continue;
                var3 = ENTITY_ID_POOL.getInt(var4) + 1;
                break;
            }
            var2 = var3;
        }
        if (var2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is 254)");
        }
        ENTITY_ID_POOL.put(var0, var2);
        return var1.createAccessor(var2);
    }

    public <T> void define(DataWatcherObject<T> var0, T var1) {
        int var2 = var0.getId();
        if (var2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is 254)");
        }
        if (this.itemsById.containsKey(var2)) {
            throw new IllegalArgumentException("Duplicate id value for " + var2 + "!");
        }
        if (DataWatcherRegistry.getSerializedId(var0.getSerializer()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + var0.getSerializer() + " for " + var2 + "!");
        }
        this.createDataItem(var0, var1);
    }

    private <T> void createDataItem(DataWatcherObject<T> var0, T var1) {
        Item<T> var2 = new Item<T>(var0, var1);
        this.lock.writeLock().lock();
        this.itemsById.put(var0.getId(), var2);
        this.isEmpty = false;
        this.lock.writeLock().unlock();
    }

    private <T> Item<T> getItem(DataWatcherObject<T> var0) {
        Item var1;
        this.lock.readLock().lock();
        try {
            var1 = (Item)this.itemsById.get(var0.getId());
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Getting synched entity data");
            CrashReportSystemDetails var4 = var3.addCategory("Synched entity data");
            var4.setDetail("Data ID", var0);
            throw new ReportedException(var3);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return var1;
    }

    public <T> T get(DataWatcherObject<T> var0) {
        return this.getItem(var0).getValue();
    }

    public <T> void set(DataWatcherObject<T> var0, T var1) {
        Item<T> var2 = this.getItem(var0);
        if (ObjectUtils.notEqual(var1, var2.getValue())) {
            var2.setValue(var1);
            this.entity.onSyncedDataUpdated(var0);
            var2.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public static void pack(@Nullable List<Item<?>> var0, PacketDataSerializer var1) {
        if (var0 != null) {
            for (Item<?> var3 : var0) {
                DataWatcher.writeDataItem(var1, var3);
            }
        }
        var1.writeByte(255);
    }

    @Nullable
    public List<Item<?>> packDirty() {
        ArrayList var0 = null;
        if (this.isDirty) {
            this.lock.readLock().lock();
            for (Item var2 : this.itemsById.values()) {
                if (!var2.isDirty()) continue;
                var2.setDirty(false);
                if (var0 == null) {
                    var0 = Lists.newArrayList();
                }
                var0.add(var2.copy());
            }
            this.lock.readLock().unlock();
        }
        this.isDirty = false;
        return var0;
    }

    @Nullable
    public List<Item<?>> getAll() {
        ArrayList var0 = null;
        this.lock.readLock().lock();
        for (Item var2 : this.itemsById.values()) {
            if (var0 == null) {
                var0 = Lists.newArrayList();
            }
            var0.add(var2.copy());
        }
        this.lock.readLock().unlock();
        return var0;
    }

    private static <T> void writeDataItem(PacketDataSerializer var0, Item<T> var1) {
        DataWatcherObject<T> var2 = var1.getAccessor();
        int var3 = DataWatcherRegistry.getSerializedId(var2.getSerializer());
        if (var3 < 0) {
            throw new EncoderException("Unknown serializer type " + var2.getSerializer());
        }
        var0.writeByte(var2.getId());
        var0.writeVarInt(var3);
        var2.getSerializer().write(var0, var1.getValue());
    }

    @Nullable
    public static List<Item<?>> unpack(PacketDataSerializer var0) {
        short var2;
        ArrayList var1 = null;
        while ((var2 = var0.readUnsignedByte()) != 255) {
            int var3;
            DataWatcherSerializer<?> var4;
            if (var1 == null) {
                var1 = Lists.newArrayList();
            }
            if ((var4 = DataWatcherRegistry.getSerializer(var3 = var0.readVarInt())) == null) {
                throw new DecoderException("Unknown serializer type " + var3);
            }
            var1.add(DataWatcher.genericHelper(var0, var2, var4));
        }
        return var1;
    }

    private static <T> Item<T> genericHelper(PacketDataSerializer var0, int var1, DataWatcherSerializer<T> var2) {
        return new Item<T>(var2.createAccessor(var1), var2.read(var0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignValues(List<Item<?>> var0) {
        this.lock.writeLock().lock();
        try {
            for (Item<?> var2 : var0) {
                Item var3 = (Item)this.itemsById.get(var2.getAccessor().getId());
                if (var3 == null) continue;
                this.assignValue(var3, var2);
                this.entity.onSyncedDataUpdated(var2.getAccessor());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.isDirty = true;
    }

    private <T> void assignValue(Item<T> var0, Item<?> var1) {
        if (!Objects.equals(var1.accessor.getSerializer(), var0.accessor.getSerializer())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", var0.accessor.getId(), this.entity, var0.value, var0.value.getClass(), var1.value, var1.value.getClass()));
        }
        var0.setValue(var1.getValue());
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void clearDirty() {
        this.isDirty = false;
        this.lock.readLock().lock();
        for (Item var1 : this.itemsById.values()) {
            var1.setDirty(false);
        }
        this.lock.readLock().unlock();
    }

    public static class Item<T> {
        final DataWatcherObject<T> accessor;
        T value;
        private boolean dirty;

        public Item(DataWatcherObject<T> var0, T var1) {
            this.accessor = var0;
            this.value = var1;
            this.dirty = true;
        }

        public DataWatcherObject<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T var0) {
            this.value = var0;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean var0) {
            this.dirty = var0;
        }

        public Item<T> copy() {
            return new Item<T>(this.accessor, this.accessor.getSerializer().copy(this.value));
        }
    }
}

