/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutTabComplete
implements Packet<PacketListenerPlayOut> {
    private final int id;
    private final Suggestions suggestions;

    public PacketPlayOutTabComplete(int var0, Suggestions var1) {
        this.id = var0;
        this.suggestions = var1;
    }

    public PacketPlayOutTabComplete(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        int var12 = var0.readVarInt();
        int var2 = var0.readVarInt();
        StringRange var3 = StringRange.between((int)var12, (int)(var12 + var2));
        List<Suggestion> var4 = var0.readList(var1 -> {
            String var2 = var1.readUtf();
            IChatBaseComponent var3 = var1.readBoolean() ? var1.readComponent() : null;
            return new Suggestion(var3, var2, (Message)var3);
        });
        this.suggestions = new Suggestions(var3, var4);
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.id);
        var02.writeVarInt(this.suggestions.getRange().getStart());
        var02.writeVarInt(this.suggestions.getRange().getLength());
        var02.writeCollection(this.suggestions.getList(), (var0, var1) -> {
            var0.writeUtf(var1.getText());
            var0.writeBoolean(var1.getTooltip() != null);
            if (var1.getTooltip() != null) {
                var0.writeComponent(ChatComponentUtils.fromMessage(var1.getTooltip()));
            }
        });
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommandSuggestions(this);
    }

    public int getId() {
        return this.id;
    }

    public Suggestions getSuggestions() {
        return this.suggestions;
    }
}

