/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.scores.ScoreboardTeam;

public class PacketPlayOutScoreboardTeam
implements Packet<PacketListenerPlayOut> {
    private static final int METHOD_ADD = 0;
    private static final int METHOD_REMOVE = 1;
    private static final int METHOD_CHANGE = 2;
    private static final int METHOD_JOIN = 3;
    private static final int METHOD_LEAVE = 4;
    private static final int MAX_VISIBILITY_LENGTH = 40;
    private static final int MAX_COLLISION_LENGTH = 40;
    private final int method;
    private final String name;
    private final Collection<String> players;
    private final Optional<b> parameters;

    private PacketPlayOutScoreboardTeam(String var0, int var1, Optional<b> var2, Collection<String> var3) {
        this.name = var0;
        this.method = var1;
        this.parameters = var2;
        this.players = ImmutableList.copyOf(var3);
    }

    public static PacketPlayOutScoreboardTeam createAddOrModifyPacket(ScoreboardTeam var0, boolean var1) {
        return new PacketPlayOutScoreboardTeam(var0.getName(), var1 ? 0 : 2, Optional.of(new b(var0)), var1 ? var0.getPlayers() : ImmutableList.of());
    }

    public static PacketPlayOutScoreboardTeam createRemovePacket(ScoreboardTeam var0) {
        return new PacketPlayOutScoreboardTeam(var0.getName(), 1, Optional.empty(), (Collection<String>)ImmutableList.of());
    }

    public static PacketPlayOutScoreboardTeam createPlayerPacket(ScoreboardTeam var0, String var1, a var2) {
        return new PacketPlayOutScoreboardTeam(var0.getName(), var2 == a.ADD ? 3 : 4, Optional.empty(), (Collection<String>)ImmutableList.of((Object)var1));
    }

    public PacketPlayOutScoreboardTeam(PacketDataSerializer var0) {
        this.name = var0.readUtf();
        this.method = var0.readByte();
        this.parameters = PacketPlayOutScoreboardTeam.shouldHaveParameters(this.method) ? Optional.of(new b(var0)) : Optional.empty();
        this.players = PacketPlayOutScoreboardTeam.shouldHavePlayerList(this.method) ? var0.readList(PacketDataSerializer::readUtf) : ImmutableList.of();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.name);
        var0.writeByte(this.method);
        if (PacketPlayOutScoreboardTeam.shouldHaveParameters(this.method)) {
            this.parameters.orElseThrow(() -> new IllegalStateException("Parameters not present, but method is" + this.method)).write(var0);
        }
        if (PacketPlayOutScoreboardTeam.shouldHavePlayerList(this.method)) {
            var0.writeCollection(this.players, PacketDataSerializer::writeUtf);
        }
    }

    private static boolean shouldHavePlayerList(int var0) {
        return var0 == 0 || var0 == 3 || var0 == 4;
    }

    private static boolean shouldHaveParameters(int var0) {
        return var0 == 0 || var0 == 2;
    }

    @Nullable
    public a getPlayerAction() {
        switch (this.method) {
            case 0: 
            case 3: {
                return a.ADD;
            }
            case 4: {
                return a.REMOVE;
            }
        }
        return null;
    }

    @Nullable
    public a getTeamAction() {
        switch (this.method) {
            case 0: {
                return a.ADD;
            }
            case 1: {
                return a.REMOVE;
            }
        }
        return null;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetPlayerTeamPacket(this);
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public Optional<b> getParameters() {
        return this.parameters;
    }

    public static class b {
        private final IChatBaseComponent displayName;
        private final IChatBaseComponent playerPrefix;
        private final IChatBaseComponent playerSuffix;
        private final String nametagVisibility;
        private final String collisionRule;
        private final EnumChatFormat color;
        private final int options;

        public b(ScoreboardTeam var0) {
            this.displayName = var0.getDisplayName();
            this.options = var0.packOptions();
            this.nametagVisibility = var0.getNameTagVisibility().name;
            this.collisionRule = var0.getCollisionRule().name;
            this.color = var0.getColor();
            this.playerPrefix = var0.getPlayerPrefix();
            this.playerSuffix = var0.getPlayerSuffix();
        }

        public b(PacketDataSerializer var0) {
            this.displayName = var0.readComponent();
            this.options = var0.readByte();
            this.nametagVisibility = var0.readUtf(40);
            this.collisionRule = var0.readUtf(40);
            this.color = var0.readEnum(EnumChatFormat.class);
            this.playerPrefix = var0.readComponent();
            this.playerSuffix = var0.readComponent();
        }

        public IChatBaseComponent getDisplayName() {
            return this.displayName;
        }

        public int getOptions() {
            return this.options;
        }

        public EnumChatFormat getColor() {
            return this.color;
        }

        public String getNametagVisibility() {
            return this.nametagVisibility;
        }

        public String getCollisionRule() {
            return this.collisionRule;
        }

        public IChatBaseComponent getPlayerPrefix() {
            return this.playerPrefix;
        }

        public IChatBaseComponent getPlayerSuffix() {
            return this.playerSuffix;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeComponent(this.displayName);
            var0.writeByte(this.options);
            var0.writeUtf(this.nametagVisibility);
            var0.writeUtf(this.collisionRule);
            var0.writeEnum(this.color);
            var0.writeComponent(this.playerPrefix);
            var0.writeComponent(this.playerSuffix);
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a ADD = new a();
        public static final /* enum */ a REMOVE = new a();
        private static final /* synthetic */ a[] c;

        public static a[] values() {
            return (a[])c.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{ADD, REMOVE};
        }

        static {
            c = a.a();
        }
    }
}

