/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class PacketPlayOutMap
implements Packet<PacketListenerPlayOut> {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    @Nullable
    private final List<MapIcon> decorations;
    @Nullable
    private final WorldMap.b colorPatch;

    public PacketPlayOutMap(int var0, byte var1, boolean var2, @Nullable Collection<MapIcon> var3, @Nullable WorldMap.b var4) {
        this.mapId = var0;
        this.scale = var1;
        this.locked = var2;
        this.decorations = var3 != null ? Lists.newArrayList(var3) : null;
        this.colorPatch = var4;
    }

    public PacketPlayOutMap(PacketDataSerializer var02) {
        this.mapId = var02.readVarInt();
        this.scale = var02.readByte();
        this.locked = var02.readBoolean();
        this.decorations = var02.readBoolean() ? var02.readList(var0 -> {
            MapIcon.Type var1 = var0.readEnum(MapIcon.Type.class);
            return new MapIcon(var1, var0.readByte(), var0.readByte(), (byte)(var0.readByte() & 0xF), var0.readBoolean() ? var0.readComponent() : null);
        }) : null;
        short var1 = var02.readUnsignedByte();
        if (var1 > 0) {
            short var2 = var02.readUnsignedByte();
            short var3 = var02.readUnsignedByte();
            short var4 = var02.readUnsignedByte();
            byte[] var5 = var02.readByteArray();
            this.colorPatch = new WorldMap.b(var3, var4, var1, var2, var5);
        } else {
            this.colorPatch = null;
        }
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.mapId);
        var02.writeByte(this.scale);
        var02.writeBoolean(this.locked);
        if (this.decorations != null) {
            var02.writeBoolean(true);
            var02.writeCollection(this.decorations, (var0, var1) -> {
                var0.writeEnum(var1.getType());
                var0.writeByte(var1.getX());
                var0.writeByte(var1.getY());
                var0.writeByte(var1.getRot() & 0xF);
                if (var1.getName() != null) {
                    var0.writeBoolean(true);
                    var0.writeComponent(var1.getName());
                } else {
                    var0.writeBoolean(false);
                }
            });
        } else {
            var02.writeBoolean(false);
        }
        if (this.colorPatch != null) {
            var02.writeByte(this.colorPatch.width);
            var02.writeByte(this.colorPatch.height);
            var02.writeByte(this.colorPatch.startX);
            var02.writeByte(this.colorPatch.startY);
            var02.writeByteArray(this.colorPatch.mapColors);
        } else {
            var02.writeByte(0);
        }
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMapItemData(this);
    }

    public int getMapId() {
        return this.mapId;
    }

    public void applyToMap(WorldMap var0) {
        if (this.decorations != null) {
            var0.addClientSideDecorations(this.decorations);
        }
        if (this.colorPatch != null) {
            this.colorPatch.applyToMap(var0);
        }
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

