/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayOutCustomPayload
implements Packet<PacketListenerPlayOut> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    public static final MinecraftKey BRAND = new MinecraftKey("brand");
    public static final MinecraftKey DEBUG_PATHFINDING_PACKET = new MinecraftKey("debug/path");
    public static final MinecraftKey DEBUG_NEIGHBORSUPDATE_PACKET = new MinecraftKey("debug/neighbors_update");
    public static final MinecraftKey DEBUG_STRUCTURES_PACKET = new MinecraftKey("debug/structures");
    public static final MinecraftKey DEBUG_WORLDGENATTEMPT_PACKET = new MinecraftKey("debug/worldgen_attempt");
    public static final MinecraftKey DEBUG_POI_TICKET_COUNT_PACKET = new MinecraftKey("debug/poi_ticket_count");
    public static final MinecraftKey DEBUG_POI_ADDED_PACKET = new MinecraftKey("debug/poi_added");
    public static final MinecraftKey DEBUG_POI_REMOVED_PACKET = new MinecraftKey("debug/poi_removed");
    public static final MinecraftKey DEBUG_VILLAGE_SECTIONS = new MinecraftKey("debug/village_sections");
    public static final MinecraftKey DEBUG_GOAL_SELECTOR = new MinecraftKey("debug/goal_selector");
    public static final MinecraftKey DEBUG_BRAIN = new MinecraftKey("debug/brain");
    public static final MinecraftKey DEBUG_BEE = new MinecraftKey("debug/bee");
    public static final MinecraftKey DEBUG_HIVE = new MinecraftKey("debug/hive");
    public static final MinecraftKey DEBUG_GAME_TEST_ADD_MARKER = new MinecraftKey("debug/game_test_add_marker");
    public static final MinecraftKey DEBUG_GAME_TEST_CLEAR = new MinecraftKey("debug/game_test_clear");
    public static final MinecraftKey DEBUG_RAIDS = new MinecraftKey("debug/raids");
    public static final MinecraftKey DEBUG_GAME_EVENT = new MinecraftKey("debug/game_event");
    public static final MinecraftKey DEBUG_GAME_EVENT_LISTENER = new MinecraftKey("debug/game_event_listeners");
    private final MinecraftKey identifier;
    private final PacketDataSerializer data;

    public PacketPlayOutCustomPayload(MinecraftKey var0, PacketDataSerializer var1) {
        this.identifier = var0;
        this.data = var1;
        if (var1.writerIndex() > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
    }

    public PacketPlayOutCustomPayload(PacketDataSerializer var0) {
        this.identifier = var0.readResourceLocation();
        int var1 = var0.readableBytes();
        if (var1 < 0 || var1 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new PacketDataSerializer(var0.readBytes(var1));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.identifier);
        var0.writeBytes(this.data.copy());
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCustomPayload(this);
    }

    public MinecraftKey getIdentifier() {
        return this.identifier;
    }

    public PacketDataSerializer getData() {
        return new PacketDataSerializer(this.data.copy());
    }
}

