/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutChat
implements Packet<PacketListenerPlayOut> {
    private final IChatBaseComponent message;
    private final ChatMessageType type;
    private final UUID sender;

    public PacketPlayOutChat(IChatBaseComponent var0, ChatMessageType var1, UUID var2) {
        this.message = var0;
        this.type = var1;
        this.sender = var2;
    }

    public PacketPlayOutChat(PacketDataSerializer var0) {
        this.message = var0.readComponent();
        this.type = ChatMessageType.getForIndex(var0.readByte());
        this.sender = var0.readUUID();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeComponent(this.message);
        var0.writeByte(this.type.getIndex());
        var0.writeUUID(this.sender);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleChat(this);
    }

    public IChatBaseComponent getMessage() {
        return this.message;
    }

    public ChatMessageType getType() {
        return this.type;
    }

    public UUID getSender() {
        return this.sender;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }
}

