/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class PacketPlayOutBlockChange
implements Packet<PacketListenerPlayOut> {
    private final BlockPosition pos;
    public final IBlockData blockState;

    public PacketPlayOutBlockChange(BlockPosition var0, IBlockData var1) {
        this.pos = var0;
        this.blockState = var1;
    }

    public PacketPlayOutBlockChange(IBlockAccess var0, BlockPosition var1) {
        this(var1, var0.getBlockState(var1));
    }

    public PacketPlayOutBlockChange(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.blockState = Block.BLOCK_STATE_REGISTRY.byId(var0.readVarInt());
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeVarInt(Block.getId(this.blockState));
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockUpdate(this);
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    public BlockPosition getPos() {
        return this.pos;
    }
}

