/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.IntFunction;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.item.ItemStack;

public class PacketPlayInWindowClick
implements Packet<PacketListenerPlayIn> {
    private static final int MAX_SLOT_COUNT = 128;
    private final int containerId;
    private final int stateId;
    private final int slotNum;
    private final int buttonNum;
    private final InventoryClickType clickType;
    private final ItemStack carriedItem;
    private final Int2ObjectMap<ItemStack> changedSlots;

    public PacketPlayInWindowClick(int var0, int var1, int var2, int var3, InventoryClickType var4, ItemStack var5, Int2ObjectMap<ItemStack> var6) {
        this.containerId = var0;
        this.stateId = var1;
        this.slotNum = var2;
        this.buttonNum = var3;
        this.clickType = var4;
        this.carriedItem = var5;
        this.changedSlots = Int2ObjectMaps.unmodifiable(var6);
    }

    public PacketPlayInWindowClick(PacketDataSerializer var02) {
        this.containerId = var02.readByte();
        this.stateId = var02.readVarInt();
        this.slotNum = var02.readShort();
        this.buttonNum = var02.readByte();
        this.clickType = var02.readEnum(InventoryClickType.class);
        IntFunction<Int2ObjectOpenHashMap> var1 = PacketDataSerializer.limitValue(Int2ObjectOpenHashMap::new, 128);
        this.changedSlots = Int2ObjectMaps.unmodifiable((Int2ObjectMap)((Int2ObjectMap)var02.readMap(var1, var0 -> var0.readShort(), PacketDataSerializer::readItem)));
        this.carriedItem = var02.readItem();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByte(this.containerId);
        var0.writeVarInt(this.stateId);
        var0.writeShort(this.slotNum);
        var0.writeByte(this.buttonNum);
        var0.writeEnum(this.clickType);
        var0.writeMap(this.changedSlots, PacketDataSerializer::writeShort, PacketDataSerializer::writeItem);
        var0.writeItem(this.carriedItem);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleContainerClick(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public int getButtonNum() {
        return this.buttonNum;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public Int2ObjectMap<ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public InventoryClickType getClickType() {
        return this.clickType;
    }

    public int getStateId() {
        return this.stateId;
    }
}

