/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;

public class ChatComponentScore
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final String SCORER_PLACEHOLDER = "*";
    private final String name;
    @Nullable
    private final EntitySelector selector;
    private final String objective;

    @Nullable
    private static EntitySelector parseSelector(String var0) {
        try {
            return new ArgumentParserSelector(new StringReader(var0)).parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ChatComponentScore(String var0, String var1) {
        this(var0, ChatComponentScore.parseSelector(var0), var1);
    }

    private ChatComponentScore(String var0, @Nullable EntitySelector var1, String var2) {
        this.name = var0;
        this.selector = var1;
        this.objective = var2;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public String getObjective() {
        return this.objective;
    }

    private String findTargetName(CommandListenerWrapper var0) throws CommandSyntaxException {
        List<? extends Entity> var1;
        if (this.selector != null && !(var1 = this.selector.findEntities(var0)).isEmpty()) {
            if (var1.size() != 1) {
                throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return var1.get(0).getScoreboardName();
        }
        return this.name;
    }

    private String getScore(String var0, CommandListenerWrapper var1) {
        ScoreboardObjective var4;
        ScoreboardServer var3;
        MinecraftServer var2 = var1.getServer();
        if (var2 != null && (var3 = var2.getScoreboard()).hasPlayerScore(var0, var4 = var3.getObjective(this.objective))) {
            ScoreboardScore var5 = var3.getOrCreatePlayerScore(var0, var4);
            return Integer.toString(var5.getScore());
        }
        return "";
    }

    @Override
    public ChatComponentScore plainCopy() {
        return new ChatComponentScore(this.name, this.selector, this.objective);
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null) {
            return new ChatComponentText("");
        }
        String var3 = this.findTargetName(var0);
        String var4 = var1 != null && var3.equals(SCORER_PLACEHOLDER) ? var1.getScoreboardName() : var3;
        return new ChatComponentText(this.getScore(var4, var0));
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatComponentScore) {
            ChatComponentScore var1 = (ChatComponentScore)var0;
            return this.name.equals(var1.name) && this.objective.equals(var1.objective) && super.equals(var0);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ScoreComponent{name='" + this.name + "'objective='" + this.objective + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    @Override
    public /* synthetic */ ChatBaseComponent plainCopy() {
        return this.plainCopy();
    }

    @Override
    public /* synthetic */ IChatMutableComponent plainCopy() {
        return this.plainCopy();
    }
}

