/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"PACKET_SENT", (Marker)NetworkManager.PACKET_MARKER);
    private final EnumProtocolDirection flow;

    public PacketEncoder(EnumProtocolDirection var0) {
        this.flow = var0;
    }

    protected void encode(ChannelHandlerContext var0, Packet<?> var1, ByteBuf var2) throws Exception {
        EnumProtocol var3 = (EnumProtocol)((Object)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get());
        if (var3 == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + var1);
        }
        Integer var4 = var3.getPacketId(this.flow, var1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MARKER, "OUT: [{}:{}] {}", var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get(), (Object)var4, (Object)var1.getClass().getName());
        }
        if (var4 == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketDataSerializer var5 = new PacketDataSerializer(var2);
        var5.writeVarInt(var4);
        try {
            int var6 = var5.writerIndex();
            var1.write(var5);
            int var7 = var5.writerIndex() - var6;
            if (var7 > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + var7 + ", should be less than 8388608): " + var1);
            }
            int var8 = ((EnumProtocol)((Object)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get())).getId();
            JvmProfiler.INSTANCE.onPacketSent(var8, var4, var0.channel().remoteAddress(), var7);
        }
        catch (Throwable var6) {
            LOGGER.error((Object)var6);
            if (var1.isSkippable()) {
                throw new SkipEncodeException(var6);
            }
            throw var6;
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

