/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectToTag;

public class CollectFields
extends CollectToTag {
    private int fieldsToGetCount;
    private final Set<NBTTagType<?>> wantedTypes;
    private final Deque<a> stack = new ArrayDeque<a>();

    public CollectFields(b ... var0) {
        this.fieldsToGetCount = var0.length;
        ImmutableSet.Builder var1 = ImmutableSet.builder();
        a var2 = new a(1);
        for (b var6 : var0) {
            var2.addEntry(var6);
            var1.add(var6.type);
        }
        this.stack.push(var2);
        var1.add(NBTTagCompound.TYPE);
        this.wantedTypes = var1.build();
    }

    @Override
    public StreamTagVisitor.b visitRootEntry(NBTTagType<?> var0) {
        if (var0 != NBTTagCompound.TYPE) {
            return StreamTagVisitor.b.HALT;
        }
        return super.visitRootEntry(var0);
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0) {
        a var1 = this.stack.element();
        if (this.depth() > var1.depth()) {
            return super.visitEntry(var0);
        }
        if (this.fieldsToGetCount <= 0) {
            return StreamTagVisitor.a.HALT;
        }
        if (!this.wantedTypes.contains(var0)) {
            return StreamTagVisitor.a.SKIP;
        }
        return super.visitEntry(var0);
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0, String var1) {
        a var3;
        a var2 = this.stack.element();
        if (this.depth() > var2.depth()) {
            return super.visitEntry(var0, var1);
        }
        if (var2.fieldsToGet.remove(var1, var0)) {
            --this.fieldsToGetCount;
            return super.visitEntry(var0, var1);
        }
        if (var0 == NBTTagCompound.TYPE && (var3 = var2.fieldsToRecurse.get(var1)) != null) {
            this.stack.push(var3);
            return super.visitEntry(var0, var1);
        }
        return StreamTagVisitor.a.SKIP;
    }

    @Override
    public StreamTagVisitor.b visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }

    public int getMissingFieldCount() {
        return this.fieldsToGetCount;
    }

    static final class a
    extends Record {
        private final int depth;
        final Map<String, NBTTagType<?>> fieldsToGet;
        final Map<String, a> fieldsToRecurse;

        public a(int var0) {
            this(var0, new HashMap(), new HashMap<String, a>());
        }

        private a(int var0, Map<String, NBTTagType<?>> var1, Map<String, a> var2) {
            this.depth = var0;
            this.fieldsToGet = var1;
            this.fieldsToRecurse = var2;
        }

        public void addEntry(b var02) {
            if (this.depth <= var02.path.size()) {
                this.fieldsToRecurse.computeIfAbsent(var02.path.get(this.depth - 1), var0 -> new a(this.depth + 1)).addEntry(var02);
            } else {
                this.fieldsToGet.put(var02.name, var02.type);
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "depth;fieldsToGet;fieldsToRecurse", "depth", "fieldsToGet", "fieldsToRecurse"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "depth;fieldsToGet;fieldsToRecurse", "depth", "fieldsToGet", "fieldsToRecurse"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "depth;fieldsToGet;fieldsToRecurse", "depth", "fieldsToGet", "fieldsToRecurse"}, this, var0);
        }

        public int depth() {
            return this.depth;
        }

        public Map<String, NBTTagType<?>> fieldsToGet() {
            return this.fieldsToGet;
        }

        public Map<String, a> fieldsToRecurse() {
            return this.fieldsToRecurse;
        }
    }

    public static final class b
    extends Record {
        final List<String> path;
        final NBTTagType<?> type;
        final String name;

        public b(NBTTagType<?> var0, String var1) {
            this(List.of(), var0, var1);
        }

        public b(String var0, NBTTagType<?> var1, String var2) {
            this(List.of(var0), var1, var2);
        }

        public b(String var0, String var1, NBTTagType<?> var2, String var3) {
            this(List.of(var0, var1), var2, var3);
        }

        public b(List<String> var0, NBTTagType<?> var1, String var2) {
            this.path = var0;
            this.type = var1;
            this.name = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path;type;name", "path", "type", "name"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path;type;name", "path", "type", "name"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path;type;name", "path", "type", "name"}, this, var0);
        }

        public List<String> path() {
            return this.path;
        }

        public NBTTagType<?> type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }
    }
}

