/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagShort
extends NBTNumber {
    private static final int SELF_SIZE_IN_BITS = 80;
    public static final NBTTagType<NBTTagShort> TYPE = new NBTTagType.a<NBTTagShort>(){

        @Override
        public NBTTagShort load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBits(80L);
            return NBTTagShort.valueOf(var0.readShort());
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            return var1.visit(var0.readShort());
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public String getName() {
            return "SHORT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Short";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private final short data;

    NBTTagShort(short var0) {
        this.data = var0;
    }

    public static NBTTagShort valueOf(short var0) {
        if (var0 >= -128 && var0 <= 1024) {
            return a.cache[var0 - -128];
        }
        return new NBTTagShort(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeShort(this.data);
    }

    @Override
    public byte getId() {
        return 2;
    }

    public NBTTagType<NBTTagShort> getType() {
        return TYPE;
    }

    @Override
    public NBTTagShort copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagShort && this.data == ((NBTTagShort)var0).data;
    }

    public int hashCode() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitShort(this);
    }

    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    public int getAsInt() {
        return this.data;
    }

    @Override
    public short getAsShort() {
        return this.data;
    }

    @Override
    public byte getAsByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    static class a {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final NBTTagShort[] cache = new NBTTagShort[1153];

        private a() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                a.cache[var0] = new NBTTagShort((short)(-128 + var0));
            }
        }
    }
}

