/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.data.worldgen.BiomeSettings;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;

public class OverworldBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float var0) {
        float var1 = var0;
        var1 /= 3.0f;
        var1 = MathHelper.clamp(var1, -1.0f, 1.0f);
        return MathHelper.hsvToRgb(0.62222224f - var1 * 0.05f, 0.5f + var1 * 0.1f, 1.0f);
    }

    private static BiomeBase biome(BiomeBase.Precipitation var0, BiomeBase.Geography var1, float var2, float var3, BiomeSettingsMobs.a var4, BiomeSettingsGeneration.a var5, @Nullable Music var6) {
        return OverworldBiomes.biome(var0, var1, var2, var3, 4159204, 329011, var4, var5, var6);
    }

    private static BiomeBase biome(BiomeBase.Precipitation var0, BiomeBase.Geography var1, float var2, float var3, int var4, int var5, BiomeSettingsMobs.a var6, BiomeSettingsGeneration.a var7, @Nullable Music var8) {
        return new BiomeBase.a().precipitation(var0).biomeCategory(var1).temperature(var2).downfall(var3).specialEffects(new BiomeFog.a().waterColor(var4).waterFogColor(var5).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var2)).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var8).build()).mobSpawnSettings(var6.build()).generationSettings(var7.build()).build();
    }

    private static void globalOverworldGeneration(BiomeSettingsGeneration.a var0) {
        BiomeSettings.addDefaultCarversAndLakes(var0);
        BiomeSettings.addDefaultCrystalFormations(var0);
        BiomeSettings.addDefaultMonsterRoom(var0);
        BiomeSettings.addDefaultUndergroundVariety(var0);
        BiomeSettings.addDefaultSprings(var0);
        BiomeSettings.addSurfaceFreezing(var0);
    }

    public static BiomeBase oldGrowthTaiga(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var1);
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4));
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3));
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        if (var0) {
            BiomeSettings.commonSpawns(var1);
        } else {
            BiomeSettings.caveSpawns(var1);
            BiomeSettings.monsters(var1, 100, 25, 100, false);
        }
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addMossyStoneBlock(var2);
        BiomeSettings.addFerns(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        var2.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var0 ? VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA : VegetationPlacements.TREES_OLD_GROWTH_PINE_TAIGA);
        BiomeSettings.addDefaultFlowers(var2);
        BiomeSettings.addGiantTaigaVegetation(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        BiomeSettings.addCommonBerryBushes(var2);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.TAIGA, var0 ? 0.25f : 0.3f, 0.8f, var1, var2, NORMAL_MUSIC);
    }

    public static BiomeBase sparseJungle() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var0);
        return OverworldBiomes.baseJungle(0.8f, false, true, false, var0);
    }

    public static BiomeBase jungle() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var0);
        var0.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PARROT, 40, 1, 2)).addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 2, 1, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PANDA, 1, 1, 2));
        return OverworldBiomes.baseJungle(0.9f, false, false, true, var0);
    }

    public static BiomeBase bambooJungle() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.baseJungleSpawns(var0);
        var0.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PARROT, 40, 1, 2)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.PANDA, 80, 1, 2)).addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.OCELOT, 2, 1, 1));
        return OverworldBiomes.baseJungle(0.9f, true, false, true, var0);
    }

    private static BiomeBase baseJungle(float var0, boolean var1, boolean var2, boolean var3, BiomeSettingsMobs.a var4) {
        BiomeSettingsGeneration.a var5 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeSettings.addDefaultOres(var5);
        BiomeSettings.addDefaultSoftDisks(var5);
        if (var1) {
            BiomeSettings.addBambooVegetation(var5);
        } else {
            if (var3) {
                BiomeSettings.addLightBambooVegetation(var5);
            }
            if (var2) {
                BiomeSettings.addSparseJungleTrees(var5);
            } else {
                BiomeSettings.addJungleTrees(var5);
            }
        }
        BiomeSettings.addWarmFlowers(var5);
        BiomeSettings.addJungleGrass(var5);
        BiomeSettings.addDefaultMushrooms(var5);
        BiomeSettings.addDefaultExtraVegetation(var5);
        BiomeSettings.addJungleVines(var5);
        if (var2) {
            BiomeSettings.addSparseJungleMelons(var5);
        } else {
            BiomeSettings.addJungleMelons(var5);
        }
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.JUNGLE, 0.95f, var0, var4, var5, NORMAL_MUSIC);
    }

    public static BiomeBase windsweptHills(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var1);
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 5, 4, 6));
        BiomeSettings.commonSpawns(var1);
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        if (var0) {
            BiomeSettings.addMountainForestTrees(var2);
        } else {
            BiomeSettings.addMountainTrees(var2);
        }
        BiomeSettings.addDefaultFlowers(var2);
        BiomeSettings.addDefaultGrass(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        BiomeSettings.addExtraEmeralds(var2);
        BiomeSettings.addInfestedStone(var2);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.EXTREME_HILLS, 0.2f, 0.3f, var1, var2, NORMAL_MUSIC);
    }

    public static BiomeBase desert() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.desertSpawns(var0);
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        BiomeSettings.addFossilDecoration(var1);
        OverworldBiomes.globalOverworldGeneration(var1);
        BiomeSettings.addDefaultOres(var1);
        BiomeSettings.addDefaultSoftDisks(var1);
        BiomeSettings.addDefaultFlowers(var1);
        BiomeSettings.addDefaultGrass(var1);
        BiomeSettings.addDesertVegetation(var1);
        BiomeSettings.addDefaultMushrooms(var1);
        BiomeSettings.addDesertExtraVegetation(var1);
        BiomeSettings.addDesertExtraDecoration(var1);
        return OverworldBiomes.biome(BiomeBase.Precipitation.NONE, BiomeBase.Geography.DESERT, 2.0f, 0.0f, var0, var1, NORMAL_MUSIC);
    }

    public static BiomeBase plains(boolean var0, boolean var1, boolean var2) {
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var4);
        if (var1) {
            var3.creatureGenerationProbability(0.07f);
            BiomeSettings.snowySpawns(var3);
            if (var2) {
                var4.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_SPIKE);
                var4.addFeature(WorldGenStage.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_PATCH);
            }
        } else {
            BiomeSettings.plainsSpawns(var3);
            BiomeSettings.addPlainGrass(var4);
            if (var0) {
                var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUNFLOWER);
            }
        }
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        if (var1) {
            BiomeSettings.addSnowyTrees(var4);
            BiomeSettings.addDefaultFlowers(var4);
            BiomeSettings.addDefaultGrass(var4);
        } else {
            BiomeSettings.addPlainVegetation(var4);
        }
        BiomeSettings.addDefaultMushrooms(var4);
        if (var0) {
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUGAR_CANE);
            var4.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_PUMPKIN);
        } else {
            BiomeSettings.addDefaultExtraVegetation(var4);
        }
        float var5 = var1 ? 0.0f : 0.8f;
        return OverworldBiomes.biome(var1 ? BiomeBase.Precipitation.SNOW : BiomeBase.Precipitation.RAIN, var1 ? BiomeBase.Geography.ICY : BiomeBase.Geography.PLAINS, var5, var1 ? 0.5f : 0.4f, var3, var4, NORMAL_MUSIC);
    }

    public static BiomeBase mushroomFields() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.mooshroomSpawns(var0);
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var1);
        BiomeSettings.addDefaultOres(var1);
        BiomeSettings.addDefaultSoftDisks(var1);
        BiomeSettings.addMushroomFieldVegetation(var1);
        BiomeSettings.addDefaultExtraVegetation(var1);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.MUSHROOM, 0.9f, 1.0f, var0, var1, NORMAL_MUSIC);
    }

    public static BiomeBase savanna(boolean var0, boolean var1) {
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var2);
        if (!var0) {
            BiomeSettings.addSavannaGrass(var2);
        }
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        if (var0) {
            BiomeSettings.addShatteredSavannaTrees(var2);
            BiomeSettings.addDefaultFlowers(var2);
            BiomeSettings.addShatteredSavannaGrass(var2);
        } else {
            BiomeSettings.addSavannaTrees(var2);
            BiomeSettings.addWarmFlowers(var2);
            BiomeSettings.addSavannaExtraGrass(var2);
        }
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        BiomeSettingsMobs.a var3 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var3);
        var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.HORSE, 1, 2, 6)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.DONKEY, 1, 1, 1));
        BiomeSettings.commonSpawns(var3);
        if (var1) {
            var3.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.LLAMA, 8, 4, 4));
        }
        return OverworldBiomes.biome(BiomeBase.Precipitation.NONE, BiomeBase.Geography.SAVANNA, 2.0f, 0.0f, var3, var2, NORMAL_MUSIC);
    }

    public static BiomeBase badlands(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var1);
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addExtraGold(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        if (var0) {
            BiomeSettings.addBadlandsTrees(var2);
        }
        BiomeSettings.addBadlandGrass(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addBadlandExtraVegetation(var2);
        return new BiomeBase.a().precipitation(BiomeBase.Precipitation.NONE).biomeCategory(BiomeBase.Geography.MESA).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeFog.a().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(2.0f)).foliageColorOverride(10387789).grassColorOverride(9470285).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var1.build()).generationSettings(var2.build()).build();
    }

    private static BiomeBase baseOcean(BiomeSettingsMobs.a var0, int var1, int var2, BiomeSettingsGeneration.a var3) {
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.OCEAN, 0.5f, 0.5f, var1, var2, var0, var3, NORMAL_MUSIC);
    }

    private static BiomeSettingsGeneration.a baseOceanGeneration() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addWaterTrees(var0);
        BiomeSettings.addDefaultFlowers(var0);
        BiomeSettings.addDefaultGrass(var0);
        BiomeSettings.addDefaultMushrooms(var0);
        BiomeSettings.addDefaultExtraVegetation(var0);
        return var0;
    }

    public static BiomeBase coldOcean(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var1, 3, 4, 15);
        var1.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 15, 1, 5));
        BiomeSettingsGeneration.a var2 = OverworldBiomes.baseOceanGeneration();
        var2.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var0 ? AquaticPlacements.SEAGRASS_DEEP_COLD : AquaticPlacements.SEAGRASS_COLD);
        BiomeSettings.addDefaultSeagrass(var2);
        BiomeSettings.addColdOceanExtraVegetation(var2);
        return OverworldBiomes.baseOcean(var1, 4020182, 329011, var2);
    }

    public static BiomeBase ocean(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.oceanSpawns(var1, 1, 4, 10);
        var1.addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 1, 1, 2));
        BiomeSettingsGeneration.a var2 = OverworldBiomes.baseOceanGeneration();
        var2.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var0 ? AquaticPlacements.SEAGRASS_DEEP : AquaticPlacements.SEAGRASS_NORMAL);
        BiomeSettings.addDefaultSeagrass(var2);
        BiomeSettings.addColdOceanExtraVegetation(var2);
        return OverworldBiomes.baseOcean(var1, 4159204, 329011, var2);
    }

    public static BiomeBase lukeWarmOcean(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        if (var0) {
            BiomeSettings.oceanSpawns(var1, 8, 4, 8);
        } else {
            BiomeSettings.oceanSpawns(var1, 10, 2, 15);
        }
        var1.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 5, 1, 3)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 25, 8, 8)).addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.DOLPHIN, 2, 1, 2));
        BiomeSettingsGeneration.a var2 = OverworldBiomes.baseOceanGeneration();
        var2.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, var0 ? AquaticPlacements.SEAGRASS_DEEP_WARM : AquaticPlacements.SEAGRASS_WARM);
        if (var0) {
            BiomeSettings.addDefaultSeagrass(var2);
        }
        BiomeSettings.addLukeWarmKelp(var2);
        return OverworldBiomes.baseOcean(var1, 4566514, 267827, var2);
    }

    public static BiomeBase warmOcean() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.PUFFERFISH, 15, 1, 3));
        BiomeSettings.warmOceanSpawns(var0, 10, 4);
        BiomeSettingsGeneration.a var1 = OverworldBiomes.baseOceanGeneration().addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        return OverworldBiomes.baseOcean(var0, 4445678, 270131, var1);
    }

    public static BiomeBase frozenOcean(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.SQUID, 1, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 15, 1, 5)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.POLAR_BEAR, 1, 1, 2));
        BiomeSettings.commonSpawns(var1);
        var1.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.DROWNED, 5, 1, 1));
        float var2 = var0 ? 0.5f : 0.0f;
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a();
        BiomeSettings.addIcebergs(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addBlueIce(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addWaterTrees(var3);
        BiomeSettings.addDefaultFlowers(var3);
        BiomeSettings.addDefaultGrass(var3);
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        return new BiomeBase.a().precipitation(var0 ? BiomeBase.Precipitation.RAIN : BiomeBase.Precipitation.SNOW).biomeCategory(BiomeBase.Geography.OCEAN).temperature(var2).temperatureAdjustment(BiomeBase.TemperatureModifier.FROZEN).downfall(0.5f).specialEffects(new BiomeFog.a().waterColor(3750089).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var2)).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var1.build()).generationSettings(var3.build()).build();
    }

    public static BiomeBase forest(boolean var0, boolean var1, boolean var2) {
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var3);
        if (var2) {
            var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        } else {
            BiomeSettings.addForestFlowers(var3);
        }
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        if (var2) {
            var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_FLOWER_FOREST);
            var3.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
            BiomeSettings.addDefaultGrass(var3);
        } else {
            if (var0) {
                if (var1) {
                    BiomeSettings.addTallBirchTrees(var3);
                } else {
                    BiomeSettings.addBirchTrees(var3);
                }
            } else {
                BiomeSettings.addOtherBirchTrees(var3);
            }
            BiomeSettings.addDefaultFlowers(var3);
            BiomeSettings.addForestGrass(var3);
        }
        BiomeSettings.addDefaultMushrooms(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        BiomeSettingsMobs.a var4 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var4);
        BiomeSettings.commonSpawns(var4);
        if (var2) {
            var4.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3));
        } else if (!var0) {
            var4.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 5, 4, 4));
        }
        float var5 = var0 ? 0.6f : 0.7f;
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.FOREST, var5, var0 ? 0.6f : 0.8f, var4, var3, NORMAL_MUSIC);
    }

    public static BiomeBase taiga(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var1);
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        BiomeSettings.commonSpawns(var1);
        float var2 = var0 ? -0.5f : 0.25f;
        BiomeSettingsGeneration.a var3 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeSettings.addFerns(var3);
        BiomeSettings.addDefaultOres(var3);
        BiomeSettings.addDefaultSoftDisks(var3);
        BiomeSettings.addTaigaTrees(var3);
        BiomeSettings.addDefaultFlowers(var3);
        BiomeSettings.addTaigaGrass(var3);
        BiomeSettings.addDefaultExtraVegetation(var3);
        if (var0) {
            BiomeSettings.addRareBerryBushes(var3);
        } else {
            BiomeSettings.addCommonBerryBushes(var3);
        }
        return OverworldBiomes.biome(var0 ? BiomeBase.Precipitation.SNOW : BiomeBase.Precipitation.RAIN, BiomeBase.Geography.TAIGA, var2, var0 ? 0.4f : 0.8f, var0 ? 4020182 : 4159204, 329011, var1, var3, NORMAL_MUSIC);
    }

    public static BiomeBase darkForest() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var0);
        BiomeSettings.commonSpawns(var0);
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var1);
        var1.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, VegetationPlacements.DARK_FOREST_VEGETATION);
        BiomeSettings.addForestFlowers(var1);
        BiomeSettings.addDefaultOres(var1);
        BiomeSettings.addDefaultSoftDisks(var1);
        BiomeSettings.addDefaultFlowers(var1);
        BiomeSettings.addForestGrass(var1);
        BiomeSettings.addDefaultMushrooms(var1);
        BiomeSettings.addDefaultExtraVegetation(var1);
        return new BiomeBase.a().precipitation(BiomeBase.Precipitation.RAIN).biomeCategory(BiomeBase.Geography.FOREST).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeFog.a().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.7f)).grassColorModifier(BiomeFog.GrassColor.DARK_FOREST).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var0.build()).generationSettings(var1.build()).build();
    }

    public static BiomeBase swamp() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var0);
        BiomeSettings.commonSpawns(var0);
        var0.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.SLIME, 1, 1, 1));
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        BiomeSettings.addFossilDecoration(var1);
        OverworldBiomes.globalOverworldGeneration(var1);
        BiomeSettings.addDefaultOres(var1);
        BiomeSettings.addSwampClayDisk(var1);
        BiomeSettings.addSwampVegetation(var1);
        BiomeSettings.addDefaultMushrooms(var1);
        BiomeSettings.addSwampExtraVegetation(var1);
        var1.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        return new BiomeBase.a().precipitation(BiomeBase.Precipitation.RAIN).biomeCategory(BiomeBase.Geography.SWAMP).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeFog.a().waterColor(6388580).waterFogColor(2302743).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(6975545).grassColorModifier(BiomeFog.GrassColor.SWAMP).ambientMoodSound(CaveSoundSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var0.build()).generationSettings(var1.build()).build();
    }

    public static BiomeBase river(boolean var0) {
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a().addSpawn(EnumCreatureType.WATER_CREATURE, new BiomeSettingsMobs.c(EntityTypes.SQUID, 2, 1, 4)).addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.SALMON, 5, 1, 5));
        BiomeSettings.commonSpawns(var1);
        var1.addSpawn(EnumCreatureType.MONSTER, new BiomeSettingsMobs.c(EntityTypes.DROWNED, var0 ? 1 : 100, 1, 1));
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeSettings.addDefaultOres(var2);
        BiomeSettings.addDefaultSoftDisks(var2);
        BiomeSettings.addWaterTrees(var2);
        BiomeSettings.addDefaultFlowers(var2);
        BiomeSettings.addDefaultGrass(var2);
        BiomeSettings.addDefaultMushrooms(var2);
        BiomeSettings.addDefaultExtraVegetation(var2);
        if (!var0) {
            var2.addFeature(WorldGenStage.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        }
        float var3 = var0 ? 0.0f : 0.5f;
        return OverworldBiomes.biome(var0 ? BiomeBase.Precipitation.SNOW : BiomeBase.Precipitation.RAIN, BiomeBase.Geography.RIVER, var3, 0.5f, var0 ? 3750089 : 4159204, 329011, var1, var2, NORMAL_MUSIC);
    }

    public static BiomeBase beach(boolean var0, boolean var1) {
        boolean var3;
        BiomeSettingsMobs.a var2 = new BiomeSettingsMobs.a();
        boolean bl = var3 = !var1 && !var0;
        if (var3) {
            var2.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.TURTLE, 5, 2, 5));
        }
        BiomeSettings.commonSpawns(var2);
        BiomeSettingsGeneration.a var4 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeSettings.addDefaultOres(var4);
        BiomeSettings.addDefaultSoftDisks(var4);
        BiomeSettings.addDefaultFlowers(var4);
        BiomeSettings.addDefaultGrass(var4);
        BiomeSettings.addDefaultMushrooms(var4);
        BiomeSettings.addDefaultExtraVegetation(var4);
        float var5 = var0 ? 0.05f : (var1 ? 0.2f : 0.8f);
        return OverworldBiomes.biome(var0 ? BiomeBase.Precipitation.SNOW : BiomeBase.Precipitation.RAIN, BiomeBase.Geography.BEACH, var5, var3 ? 0.4f : 0.3f, var0 ? 4020182 : 4159204, 329011, var2, var4, NORMAL_MUSIC);
    }

    public static BiomeBase theVoid() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        var0.addFeature(WorldGenStage.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.VOID_START_PLATFORM);
        return OverworldBiomes.biome(BiomeBase.Precipitation.NONE, BiomeBase.Geography.NONE, 0.5f, 0.5f, new BiomeSettingsMobs.a(), var0, NORMAL_MUSIC);
    }

    public static BiomeBase meadow() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.DONKEY, 1, 1, 2)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 2, 2, 6)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.SHEEP, 2, 2, 4));
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addPlainGrass(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addMeadowVegetation(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_MEADOW);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.MOUNTAIN, 0.5f, 0.8f, 937679, 329011, var1, var0, var2);
    }

    public static BiomeBase frozenPeaks() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addFrozenSprings(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_FROZEN_PEAKS);
        return OverworldBiomes.biome(BiomeBase.Precipitation.SNOW, BiomeBase.Geography.MOUNTAIN, -0.7f, 0.9f, var1, var0, var2);
    }

    public static BiomeBase jaggedPeaks() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addFrozenSprings(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_JAGGED_PEAKS);
        return OverworldBiomes.biome(BiomeBase.Precipitation.SNOW, BiomeBase.Geography.MOUNTAIN, -0.7f, 0.9f, var1, var0, var2);
    }

    public static BiomeBase stonyPeaks() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_STONY_PEAKS);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.MOUNTAIN, 1.0f, 0.3f, var1, var0, var2);
    }

    public static BiomeBase snowySlopes() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.GOAT, 5, 1, 3));
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addFrozenSprings(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addDefaultExtraVegetation(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_SNOWY_SLOPES);
        return OverworldBiomes.biome(BiomeBase.Precipitation.SNOW, BiomeBase.Geography.MOUNTAIN, -0.3f, 0.9f, var1, var0, var2);
    }

    public static BiomeBase grove() {
        BiomeSettingsGeneration.a var0 = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a var1 = new BiomeSettingsMobs.a();
        BiomeSettings.farmAnimals(var1);
        var1.addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.WOLF, 8, 4, 4)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.RABBIT, 4, 2, 3)).addSpawn(EnumCreatureType.CREATURE, new BiomeSettingsMobs.c(EntityTypes.FOX, 8, 2, 4));
        BiomeSettings.commonSpawns(var1);
        OverworldBiomes.globalOverworldGeneration(var0);
        BiomeSettings.addFrozenSprings(var0);
        BiomeSettings.addDefaultOres(var0);
        BiomeSettings.addDefaultSoftDisks(var0);
        BiomeSettings.addGroveTrees(var0);
        BiomeSettings.addDefaultExtraVegetation(var0);
        BiomeSettings.addExtraEmeralds(var0);
        BiomeSettings.addInfestedStone(var0);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_GROVE);
        return OverworldBiomes.biome(BiomeBase.Precipitation.SNOW, BiomeBase.Geography.FOREST, -0.2f, 0.8f, var1, var0, var2);
    }

    public static BiomeBase lushCaves() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        var0.addSpawn(EnumCreatureType.AXOLOTLS, new BiomeSettingsMobs.c(EntityTypes.AXOLOTL, 10, 4, 6));
        var0.addSpawn(EnumCreatureType.WATER_AMBIENT, new BiomeSettingsMobs.c(EntityTypes.TROPICAL_FISH, 25, 8, 8));
        BiomeSettings.commonSpawns(var0);
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var1);
        BiomeSettings.addPlainGrass(var1);
        BiomeSettings.addDefaultOres(var1);
        BiomeSettings.addLushCavesSpecialOres(var1);
        BiomeSettings.addDefaultSoftDisks(var1);
        BiomeSettings.addLushCavesVegetationFeatures(var1);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_LUSH_CAVES);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.UNDERGROUND, 0.5f, 0.5f, var0, var1, var2);
    }

    public static BiomeBase dripstoneCaves() {
        BiomeSettingsMobs.a var0 = new BiomeSettingsMobs.a();
        BiomeSettings.dripstoneCavesSpawns(var0);
        BiomeSettingsGeneration.a var1 = new BiomeSettingsGeneration.a();
        OverworldBiomes.globalOverworldGeneration(var1);
        BiomeSettings.addPlainGrass(var1);
        BiomeSettings.addDefaultOres(var1, true);
        BiomeSettings.addDefaultSoftDisks(var1);
        BiomeSettings.addPlainVegetation(var1);
        BiomeSettings.addDefaultMushrooms(var1);
        BiomeSettings.addDefaultExtraVegetation(var1);
        BiomeSettings.addDripstone(var1);
        Music var2 = Musics.createGameMusic(SoundEffects.MUSIC_BIOME_DRIPSTONE_CAVES);
        return OverworldBiomes.biome(BiomeBase.Precipitation.RAIN, BiomeBase.Geography.UNDERGROUND, 0.8f, 0.4f, var0, var1, var2);
    }
}

