/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;

public class SurfaceRuleData {
    private static final SurfaceRules.o AIR = SurfaceRuleData.makeStateRule(Blocks.AIR);
    private static final SurfaceRules.o BEDROCK = SurfaceRuleData.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.o WHITE_TERRACOTTA = SurfaceRuleData.makeStateRule(Blocks.WHITE_TERRACOTTA);
    private static final SurfaceRules.o ORANGE_TERRACOTTA = SurfaceRuleData.makeStateRule(Blocks.ORANGE_TERRACOTTA);
    private static final SurfaceRules.o TERRACOTTA = SurfaceRuleData.makeStateRule(Blocks.TERRACOTTA);
    private static final SurfaceRules.o RED_SAND = SurfaceRuleData.makeStateRule(Blocks.RED_SAND);
    private static final SurfaceRules.o RED_SANDSTONE = SurfaceRuleData.makeStateRule(Blocks.RED_SANDSTONE);
    private static final SurfaceRules.o STONE = SurfaceRuleData.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.o DEEPSLATE = SurfaceRuleData.makeStateRule(Blocks.DEEPSLATE);
    private static final SurfaceRules.o DIRT = SurfaceRuleData.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.o PODZOL = SurfaceRuleData.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.o COARSE_DIRT = SurfaceRuleData.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.o MYCELIUM = SurfaceRuleData.makeStateRule(Blocks.MYCELIUM);
    private static final SurfaceRules.o GRASS_BLOCK = SurfaceRuleData.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.o CALCITE = SurfaceRuleData.makeStateRule(Blocks.CALCITE);
    private static final SurfaceRules.o GRAVEL = SurfaceRuleData.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.o SAND = SurfaceRuleData.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.o SANDSTONE = SurfaceRuleData.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.o PACKED_ICE = SurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.o SNOW_BLOCK = SurfaceRuleData.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.o POWDER_SNOW = SurfaceRuleData.makeStateRule(Blocks.POWDER_SNOW);
    private static final SurfaceRules.o ICE = SurfaceRuleData.makeStateRule(Blocks.ICE);
    private static final SurfaceRules.o WATER = SurfaceRuleData.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.o LAVA = SurfaceRuleData.makeStateRule(Blocks.LAVA);
    private static final SurfaceRules.o NETHERRACK = SurfaceRuleData.makeStateRule(Blocks.NETHERRACK);
    private static final SurfaceRules.o SOUL_SAND = SurfaceRuleData.makeStateRule(Blocks.SOUL_SAND);
    private static final SurfaceRules.o SOUL_SOIL = SurfaceRuleData.makeStateRule(Blocks.SOUL_SOIL);
    private static final SurfaceRules.o BASALT = SurfaceRuleData.makeStateRule(Blocks.BASALT);
    private static final SurfaceRules.o BLACKSTONE = SurfaceRuleData.makeStateRule(Blocks.BLACKSTONE);
    private static final SurfaceRules.o WARPED_WART_BLOCK = SurfaceRuleData.makeStateRule(Blocks.WARPED_WART_BLOCK);
    private static final SurfaceRules.o WARPED_NYLIUM = SurfaceRuleData.makeStateRule(Blocks.WARPED_NYLIUM);
    private static final SurfaceRules.o NETHER_WART_BLOCK = SurfaceRuleData.makeStateRule(Blocks.NETHER_WART_BLOCK);
    private static final SurfaceRules.o CRIMSON_NYLIUM = SurfaceRuleData.makeStateRule(Blocks.CRIMSON_NYLIUM);
    private static final SurfaceRules.o ENDSTONE = SurfaceRuleData.makeStateRule(Blocks.END_STONE);

    private static SurfaceRules.o makeStateRule(Block var0) {
        return SurfaceRules.state(var0.defaultBlockState());
    }

    public static SurfaceRules.o overworld() {
        return SurfaceRuleData.overworldLike(true, false, true);
    }

    public static SurfaceRules.o overworldLike(boolean var0, boolean var1, boolean var2) {
        SurfaceRules.f var3 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(97), 2);
        SurfaceRules.f var4 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(256), 0);
        SurfaceRules.f var5 = SurfaceRules.yStartCheck(VerticalAnchor.absolute(63), -1);
        SurfaceRules.f var6 = SurfaceRules.yStartCheck(VerticalAnchor.absolute(74), 1);
        SurfaceRules.f var7 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(62), 0);
        SurfaceRules.f var8 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(63), 0);
        SurfaceRules.f var9 = SurfaceRules.waterBlockCheck(-1, 0);
        SurfaceRules.f var10 = SurfaceRules.waterBlockCheck(0, 0);
        SurfaceRules.f var11 = SurfaceRules.waterStartCheck(-6, -1);
        SurfaceRules.f var12 = SurfaceRules.hole();
        SurfaceRules.f var13 = SurfaceRules.isBiome(Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN);
        SurfaceRules.f var14 = SurfaceRules.steep();
        SurfaceRules.o var15 = SurfaceRules.sequence(SurfaceRules.ifTrue(var9, GRASS_BLOCK), DIRT);
        SurfaceRules.o var16 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_CEILING, SANDSTONE), SAND);
        SurfaceRules.o var17 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_CEILING, STONE), GRAVEL);
        SurfaceRules.f var18 = SurfaceRules.isBiome(Biomes.WARM_OCEAN, Biomes.DESERT, Biomes.BEACH, Biomes.SNOWY_BEACH);
        SurfaceRules.o var19 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.STONY_PEAKS), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.CALCITE, -0.0125, 0.0125), CALCITE), STONE)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.STONY_SHORE), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.GRAVEL, -0.05, 0.05), var17), STONE)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WINDSWEPT_HILLS), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.0), STONE)), SurfaceRules.ifTrue(var18, var16), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.DRIPSTONE_CAVES), STONE));
        SurfaceRules.o var20 = SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.POWDER_SNOW, 0.45, 0.58), POWDER_SNOW);
        SurfaceRules.o var21 = SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.POWDER_SNOW, 0.35, 0.6), POWDER_SNOW);
        SurfaceRules.o var22 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.FROZEN_PEAKS), SurfaceRules.sequence(SurfaceRules.ifTrue(var14, PACKED_ICE), SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.PACKED_ICE, -0.5, 0.2), PACKED_ICE), SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.ICE, -0.0625, 0.025), ICE), SNOW_BLOCK)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.SNOWY_SLOPES), SurfaceRules.sequence(SurfaceRules.ifTrue(var14, STONE), var20, SNOW_BLOCK)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.JAGGED_PEAKS), STONE), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.GROVE), SurfaceRules.sequence(var20, DIRT)), var19, SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WINDSWEPT_SAVANNA), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.75), STONE)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WINDSWEPT_GRAVELLY_HILLS), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(2.0), var17), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.0), STONE), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(-1.0), DIRT), var17)), DIRT);
        SurfaceRules.o var23 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.FROZEN_PEAKS), SurfaceRules.sequence(SurfaceRules.ifTrue(var14, PACKED_ICE), SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.PACKED_ICE, 0.0, 0.2), PACKED_ICE), SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.ICE, 0.0, 0.025), ICE), SNOW_BLOCK)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.SNOWY_SLOPES), SurfaceRules.sequence(SurfaceRules.ifTrue(var14, STONE), var21, SNOW_BLOCK)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.JAGGED_PEAKS), SurfaceRules.sequence(SurfaceRules.ifTrue(var14, STONE), SNOW_BLOCK)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.GROVE), SurfaceRules.sequence(var21, SNOW_BLOCK)), var19, SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WINDSWEPT_SAVANNA), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.75), STONE), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(-0.5), COARSE_DIRT))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WINDSWEPT_GRAVELLY_HILLS), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(2.0), var17), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.0), STONE), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(-1.0), var15), var17)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(1.75), COARSE_DIRT), SurfaceRules.ifTrue(SurfaceRuleData.surfaceNoiseAbove(-0.95), PODZOL))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.ICE_SPIKES), SNOW_BLOCK), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.MUSHROOM_FIELDS), MYCELIUM), var15);
        SurfaceRules.f var24 = SurfaceRules.noiseCondition(Noises.SURFACE, -0.909, -0.5454);
        SurfaceRules.f var25 = SurfaceRules.noiseCondition(Noises.SURFACE, -0.1818, 0.1818);
        SurfaceRules.f var26 = SurfaceRules.noiseCondition(Noises.SURFACE, 0.5454, 0.909);
        SurfaceRules.o var27 = SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WOODED_BADLANDS), SurfaceRules.ifTrue(var3, SurfaceRules.sequence(SurfaceRules.ifTrue(var24, COARSE_DIRT), SurfaceRules.ifTrue(var25, COARSE_DIRT), SurfaceRules.ifTrue(var26, COARSE_DIRT), var15))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.SWAMP), SurfaceRules.ifTrue(var7, SurfaceRules.ifTrue(SurfaceRules.not(var8), SurfaceRules.ifTrue(SurfaceRules.noiseCondition(Noises.SWAMP, 0.0), WATER)))))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.sequence(SurfaceRules.ifTrue(var4, ORANGE_TERRACOTTA), SurfaceRules.ifTrue(var6, SurfaceRules.sequence(SurfaceRules.ifTrue(var24, TERRACOTTA), SurfaceRules.ifTrue(var25, TERRACOTTA), SurfaceRules.ifTrue(var26, TERRACOTTA), SurfaceRules.bandlands())), SurfaceRules.ifTrue(var9, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_CEILING, RED_SANDSTONE), RED_SAND)), SurfaceRules.ifTrue(SurfaceRules.not(var12), ORANGE_TERRACOTTA), SurfaceRules.ifTrue(var11, WHITE_TERRACOTTA), var17)), SurfaceRules.ifTrue(var5, SurfaceRules.sequence(SurfaceRules.ifTrue(var8, SurfaceRules.ifTrue(SurfaceRules.not(var6), ORANGE_TERRACOTTA)), SurfaceRules.bandlands())), SurfaceRules.ifTrue(SurfaceRules.UNDER_FLOOR, SurfaceRules.ifTrue(var11, WHITE_TERRACOTTA)))), SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.ifTrue(var9, SurfaceRules.sequence(SurfaceRules.ifTrue(var13, SurfaceRules.ifTrue(var12, SurfaceRules.sequence(SurfaceRules.ifTrue(var10, AIR), SurfaceRules.ifTrue(SurfaceRules.temperature(), ICE), WATER))), var23))), SurfaceRules.ifTrue(var11, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.ifTrue(var13, SurfaceRules.ifTrue(var12, WATER))), SurfaceRules.ifTrue(SurfaceRules.UNDER_FLOOR, var22), SurfaceRules.ifTrue(var18, SurfaceRules.ifTrue(SurfaceRules.stoneDepthCheck(0, true, true, CaveSurface.FLOOR), SANDSTONE)))), SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS), STONE), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN), var16), var17)));
        ImmutableList.Builder var28 = ImmutableList.builder();
        if (var1) {
            var28.add((Object)SurfaceRules.ifTrue(SurfaceRules.not(SurfaceRules.verticalGradient("bedrock_roof", VerticalAnchor.belowTop(5), VerticalAnchor.top())), BEDROCK));
        }
        if (var2) {
            var28.add((Object)SurfaceRules.ifTrue(SurfaceRules.verticalGradient("bedrock_floor", VerticalAnchor.bottom(), VerticalAnchor.aboveBottom(5)), BEDROCK));
        }
        SurfaceRules.o var29 = SurfaceRules.ifTrue(SurfaceRules.abovePreliminarySurface(), var27);
        var28.add((Object)(var0 ? var29 : var27));
        var28.add((Object)SurfaceRules.ifTrue(SurfaceRules.verticalGradient("deepslate", VerticalAnchor.absolute(0), VerticalAnchor.absolute(8)), DEEPSLATE));
        return SurfaceRules.sequence((SurfaceRules.o[])var28.build().toArray(SurfaceRules.o[]::new));
    }

    public static SurfaceRules.o nether() {
        SurfaceRules.f var0 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(31), 0);
        SurfaceRules.f var1 = SurfaceRules.yBlockCheck(VerticalAnchor.absolute(32), 0);
        SurfaceRules.f var2 = SurfaceRules.yStartCheck(VerticalAnchor.absolute(30), 0);
        SurfaceRules.f var3 = SurfaceRules.not(SurfaceRules.yStartCheck(VerticalAnchor.absolute(35), 0));
        SurfaceRules.f var4 = SurfaceRules.yBlockCheck(VerticalAnchor.belowTop(5), 0);
        SurfaceRules.f var5 = SurfaceRules.hole();
        SurfaceRules.f var6 = SurfaceRules.noiseCondition(Noises.SOUL_SAND_LAYER, -0.012);
        SurfaceRules.f var7 = SurfaceRules.noiseCondition(Noises.GRAVEL_LAYER, -0.012);
        SurfaceRules.f var8 = SurfaceRules.noiseCondition(Noises.PATCH, -0.012);
        SurfaceRules.f var9 = SurfaceRules.noiseCondition(Noises.NETHERRACK, 0.54);
        SurfaceRules.f var10 = SurfaceRules.noiseCondition(Noises.NETHER_WART, 1.17);
        SurfaceRules.f var11 = SurfaceRules.noiseCondition(Noises.NETHER_STATE_SELECTOR, 0.0);
        SurfaceRules.o var12 = SurfaceRules.ifTrue(var8, SurfaceRules.ifTrue(var2, SurfaceRules.ifTrue(var3, GRAVEL)));
        return SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.verticalGradient("bedrock_floor", VerticalAnchor.bottom(), VerticalAnchor.aboveBottom(5)), BEDROCK), SurfaceRules.ifTrue(SurfaceRules.not(SurfaceRules.verticalGradient("bedrock_roof", VerticalAnchor.belowTop(5), VerticalAnchor.top())), BEDROCK), SurfaceRules.ifTrue(var4, NETHERRACK), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.BASALT_DELTAS), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.UNDER_CEILING, BASALT), SurfaceRules.ifTrue(SurfaceRules.UNDER_FLOOR, SurfaceRules.sequence(var12, SurfaceRules.ifTrue(var11, BASALT), BLACKSTONE)))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.SOUL_SAND_VALLEY), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.UNDER_CEILING, SurfaceRules.sequence(SurfaceRules.ifTrue(var11, SOUL_SAND), SOUL_SOIL)), SurfaceRules.ifTrue(SurfaceRules.UNDER_FLOOR, SurfaceRules.sequence(var12, SurfaceRules.ifTrue(var11, SOUL_SAND), SOUL_SOIL)))), SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.not(var1), SurfaceRules.ifTrue(var5, LAVA)), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.WARPED_FOREST), SurfaceRules.ifTrue(SurfaceRules.not(var9), SurfaceRules.ifTrue(var0, SurfaceRules.sequence(SurfaceRules.ifTrue(var10, WARPED_WART_BLOCK), WARPED_NYLIUM)))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.CRIMSON_FOREST), SurfaceRules.ifTrue(SurfaceRules.not(var9), SurfaceRules.ifTrue(var0, SurfaceRules.sequence(SurfaceRules.ifTrue(var10, NETHER_WART_BLOCK), CRIMSON_NYLIUM)))))), SurfaceRules.ifTrue(SurfaceRules.isBiome(Biomes.NETHER_WASTES), SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.UNDER_FLOOR, SurfaceRules.ifTrue(var6, SurfaceRules.sequence(SurfaceRules.ifTrue(SurfaceRules.not(var5), SurfaceRules.ifTrue(var2, SurfaceRules.ifTrue(var3, SOUL_SAND))), NETHERRACK))), SurfaceRules.ifTrue(SurfaceRules.ON_FLOOR, SurfaceRules.ifTrue(var0, SurfaceRules.ifTrue(var3, SurfaceRules.ifTrue(var7, SurfaceRules.sequence(SurfaceRules.ifTrue(var1, GRAVEL), SurfaceRules.ifTrue(SurfaceRules.not(var5), GRAVEL)))))))), NETHERRACK);
    }

    public static SurfaceRules.o end() {
        return ENDSTONE;
    }

    private static SurfaceRules.f surfaceNoiseAbove(double var0) {
        return SurfaceRules.noiseCondition(Noises.SURFACE, var0 / 8.25, Double.MAX_VALUE);
    }
}

