/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryGeneration {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> LOADERS = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> WRITABLE_REGISTRY = new RegistryMaterials(ResourceKey.createRegistryKey(new MinecraftKey("root")), Lifecycle.experimental());
    public static final IRegistry<? extends IRegistry<?>> REGISTRY = WRITABLE_REGISTRY;
    public static final IRegistry<WorldGenCarverWrapper<?>> CONFIGURED_CARVER = RegistryGeneration.registerSimple(IRegistry.CONFIGURED_CARVER_REGISTRY, () -> WorldGenCarvers.CAVE);
    public static final IRegistry<WorldGenFeatureConfigured<?, ?>> CONFIGURED_FEATURE = RegistryGeneration.registerSimple(IRegistry.CONFIGURED_FEATURE_REGISTRY, FeatureUtils::bootstrap);
    public static final IRegistry<StructureFeature<?, ?>> CONFIGURED_STRUCTURE_FEATURE = RegistryGeneration.registerSimple(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, StructureFeatures::bootstrap);
    public static final IRegistry<PlacedFeature> PLACED_FEATURE = RegistryGeneration.registerSimple(IRegistry.PLACED_FEATURE_REGISTRY, PlacementUtils::bootstrap);
    public static final IRegistry<ProcessorList> PROCESSOR_LIST = RegistryGeneration.registerSimple(IRegistry.PROCESSOR_LIST_REGISTRY, () -> ProcessorLists.ZOMBIE_PLAINS);
    public static final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> TEMPLATE_POOL = RegistryGeneration.registerSimple(IRegistry.TEMPLATE_POOL_REGISTRY, WorldGenFeaturePieces::bootstrap);
    public static final IRegistry<BiomeBase> BIOME = RegistryGeneration.registerSimple(IRegistry.BIOME_REGISTRY, () -> BiomeRegistry.PLAINS);
    public static final IRegistry<GeneratorSettingBase> NOISE_GENERATOR_SETTINGS = RegistryGeneration.registerSimple(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY, GeneratorSettingBase::bootstrap);
    public static final IRegistry<NoiseGeneratorNormal.a> NOISE = RegistryGeneration.registerSimple(IRegistry.NOISE_REGISTRY, NoiseData::bootstrap);

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, Supplier<T> var1) {
        return RegistryGeneration.registerSimple(var0, Lifecycle.stable(), var1);
    }

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, Supplier<T> var2) {
        return RegistryGeneration.internalRegister(var0, new RegistryMaterials(var0, var1), var2, var1);
    }

    private static <T, R extends IRegistryWritable<T>> R internalRegister(ResourceKey<? extends IRegistry<T>> var0, R var1, Supplier<T> var2, Lifecycle var3) {
        MinecraftKey var4 = var0.location();
        LOADERS.put(var4, var2);
        IRegistryWritable<IRegistryWritable<?>> var5 = WRITABLE_REGISTRY;
        return var5.register(var0, var1, var3);
    }

    public static <T> T register(IRegistry<? super T> var0, String var1, T var2) {
        return RegistryGeneration.register(var0, new MinecraftKey(var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, MinecraftKey var1, T var2) {
        return RegistryGeneration.register(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, ResourceKey<V> var1, T var2) {
        return ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
    }

    public static <V, T extends V> T registerMapping(IRegistry<V> var0, ResourceKey<V> var1, T var2) {
        return ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
    }

    public static void bootstrap() {
    }

    static {
        LOADERS.forEach((var0, var1) -> {
            if (var1.get() == null) {
                LOGGER.error("Unable to bootstrap registry '{}'", var0);
            }
        });
        IRegistry.checkRegistry(WRITABLE_REGISTRY);
    }
}

