/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public class RegistryBlocks<T>
extends RegistryMaterials<T> {
    private final MinecraftKey defaultKey;
    private T defaultValue;

    public RegistryBlocks(String var0, ResourceKey<? extends IRegistry<T>> var1, Lifecycle var2) {
        super(var1, var2);
        this.defaultKey = new MinecraftKey(var0);
    }

    @Override
    public <V extends T> V registerMapping(int var0, ResourceKey<T> var1, V var2, Lifecycle var3) {
        if (this.defaultKey.equals(var1.location())) {
            this.defaultValue = var2;
        }
        return super.registerMapping(var0, var1, var2, var3);
    }

    @Override
    public int getId(@Nullable T var0) {
        int var1 = super.getId(var0);
        return var1 == -1 ? super.getId(this.defaultValue) : var1;
    }

    @Override
    @Nonnull
    public MinecraftKey getKey(T var0) {
        MinecraftKey var1 = super.getKey(var0);
        return var1 == null ? this.defaultKey : var1;
    }

    @Override
    @Nonnull
    public T get(@Nullable MinecraftKey var0) {
        Object var1 = super.get(var0);
        return var1 == null ? this.defaultValue : var1;
    }

    @Override
    public Optional<T> getOptional(@Nullable MinecraftKey var0) {
        return Optional.ofNullable(super.get(var0));
    }

    @Override
    @Nonnull
    public T byId(int var0) {
        Object var1 = super.byId(var0);
        return var1 == null ? this.defaultValue : var1;
    }

    @Override
    @Nonnull
    public T getRandom(Random var0) {
        Object var1 = super.getRandom(var0);
        return var1 == null ? this.defaultValue : var1;
    }

    public MinecraftKey getDefaultKey() {
        return this.defaultKey;
    }
}

