/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.SystemUtils;

public final class MinecraftSerializableUUID {
    public static final Codec<UUID> CODEC = Codec.INT_STREAM.comapFlatMap(var0 -> SystemUtils.fixedSize(var0, 4).map(MinecraftSerializableUUID::uuidFromIntArray), var0 -> Arrays.stream(MinecraftSerializableUUID.uuidToIntArray(var0)));

    private MinecraftSerializableUUID() {
    }

    public static UUID uuidFromIntArray(int[] var0) {
        return new UUID((long)var0[0] << 32 | (long)var0[1] & 0xFFFFFFFFL, (long)var0[2] << 32 | (long)var0[3] & 0xFFFFFFFFL);
    }

    public static int[] uuidToIntArray(UUID var0) {
        long var1 = var0.getMostSignificantBits();
        long var3 = var0.getLeastSignificantBits();
        return MinecraftSerializableUUID.leastMostToIntArray(var1, var3);
    }

    private static int[] leastMostToIntArray(long var0, long var2) {
        return new int[]{(int)(var0 >> 32), (int)var0, (int)(var2 >> 32), (int)var2};
    }

    public static UUID readUUID(Dynamic<?> var0) {
        int[] var1 = var0.asIntStream().toArray();
        if (var1.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + var1.length + ".");
        }
        return MinecraftSerializableUUID.uuidFromIntArray(var1);
    }
}

