/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.network.PacketDataSerializer;

public class ArgumentSerializerInteger
implements ArgumentSerializer<IntegerArgumentType> {
    @Override
    public void serializeToNetwork(IntegerArgumentType var0, PacketDataSerializer var1) {
        boolean var2 = var0.getMinimum() != Integer.MIN_VALUE;
        boolean var3 = var0.getMaximum() != Integer.MAX_VALUE;
        var1.writeByte(ArgumentSerializers.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeInt(var0.getMinimum());
        }
        if (var3) {
            var1.writeInt(var0.getMaximum());
        }
    }

    @Override
    public IntegerArgumentType deserializeFromNetwork(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        int var2 = ArgumentSerializers.numberHasMin(var1) ? var0.readInt() : Integer.MIN_VALUE;
        int var3 = ArgumentSerializers.numberHasMax(var1) ? var0.readInt() : Integer.MAX_VALUE;
        return IntegerArgumentType.integer((int)var2, (int)var3);
    }

    @Override
    public void serializeToJson(IntegerArgumentType var0, JsonObject var1) {
        if (var0.getMinimum() != Integer.MIN_VALUE) {
            var1.addProperty("min", (Number)var0.getMinimum());
        }
        if (var0.getMaximum() != Integer.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.getMaximum());
        }
    }

    @Override
    public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
        return this.deserializeFromNetwork(packetDataSerializer);
    }
}

