/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentSerializerVoid;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArgumentRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<?>, a<?>> BY_CLASS = Maps.newHashMap();
    private static final Map<MinecraftKey, a<?>> BY_NAME = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void register(String var0, Class<T> var1, ArgumentSerializer<T> var2) {
        MinecraftKey var3 = new MinecraftKey(var0);
        if (BY_CLASS.containsKey(var1)) {
            throw new IllegalArgumentException("Class " + var1.getName() + " already has a serializer!");
        }
        if (BY_NAME.containsKey(var3)) {
            throw new IllegalArgumentException("'" + var3 + "' is already a registered serializer!");
        }
        a<T> var4 = new a<T>(var1, var2, var3);
        BY_CLASS.put(var1, var4);
        BY_NAME.put(var3, var4);
    }

    public static void bootStrap() {
        ArgumentSerializers.bootstrap();
        ArgumentRegistry.register("entity", ArgumentEntity.class, new ArgumentEntity.a());
        ArgumentRegistry.register("game_profile", ArgumentProfile.class, new ArgumentSerializerVoid<ArgumentProfile>(ArgumentProfile::gameProfile));
        ArgumentRegistry.register("block_pos", ArgumentPosition.class, new ArgumentSerializerVoid<ArgumentPosition>(ArgumentPosition::blockPos));
        ArgumentRegistry.register("column_pos", ArgumentVec2I.class, new ArgumentSerializerVoid<ArgumentVec2I>(ArgumentVec2I::columnPos));
        ArgumentRegistry.register("vec3", ArgumentVec3.class, new ArgumentSerializerVoid<ArgumentVec3>(ArgumentVec3::vec3));
        ArgumentRegistry.register("vec2", ArgumentVec2.class, new ArgumentSerializerVoid<ArgumentVec2>(ArgumentVec2::vec2));
        ArgumentRegistry.register("block_state", ArgumentTile.class, new ArgumentSerializerVoid<ArgumentTile>(ArgumentTile::block));
        ArgumentRegistry.register("block_predicate", ArgumentBlockPredicate.class, new ArgumentSerializerVoid<ArgumentBlockPredicate>(ArgumentBlockPredicate::blockPredicate));
        ArgumentRegistry.register("item_stack", ArgumentItemStack.class, new ArgumentSerializerVoid<ArgumentItemStack>(ArgumentItemStack::item));
        ArgumentRegistry.register("item_predicate", ArgumentItemPredicate.class, new ArgumentSerializerVoid<ArgumentItemPredicate>(ArgumentItemPredicate::itemPredicate));
        ArgumentRegistry.register("color", ArgumentChatFormat.class, new ArgumentSerializerVoid<ArgumentChatFormat>(ArgumentChatFormat::color));
        ArgumentRegistry.register("component", ArgumentChatComponent.class, new ArgumentSerializerVoid<ArgumentChatComponent>(ArgumentChatComponent::textComponent));
        ArgumentRegistry.register("message", ArgumentChat.class, new ArgumentSerializerVoid<ArgumentChat>(ArgumentChat::message));
        ArgumentRegistry.register("nbt_compound_tag", ArgumentNBTTag.class, new ArgumentSerializerVoid<ArgumentNBTTag>(ArgumentNBTTag::compoundTag));
        ArgumentRegistry.register("nbt_tag", ArgumentNBTBase.class, new ArgumentSerializerVoid<ArgumentNBTBase>(ArgumentNBTBase::nbtTag));
        ArgumentRegistry.register("nbt_path", ArgumentNBTKey.class, new ArgumentSerializerVoid<ArgumentNBTKey>(ArgumentNBTKey::nbtPath));
        ArgumentRegistry.register("objective", ArgumentScoreboardObjective.class, new ArgumentSerializerVoid<ArgumentScoreboardObjective>(ArgumentScoreboardObjective::objective));
        ArgumentRegistry.register("objective_criteria", ArgumentScoreboardCriteria.class, new ArgumentSerializerVoid<ArgumentScoreboardCriteria>(ArgumentScoreboardCriteria::criteria));
        ArgumentRegistry.register("operation", ArgumentMathOperation.class, new ArgumentSerializerVoid<ArgumentMathOperation>(ArgumentMathOperation::operation));
        ArgumentRegistry.register("particle", ArgumentParticle.class, new ArgumentSerializerVoid<ArgumentParticle>(ArgumentParticle::particle));
        ArgumentRegistry.register("angle", ArgumentAngle.class, new ArgumentSerializerVoid<ArgumentAngle>(ArgumentAngle::angle));
        ArgumentRegistry.register("rotation", ArgumentRotation.class, new ArgumentSerializerVoid<ArgumentRotation>(ArgumentRotation::rotation));
        ArgumentRegistry.register("scoreboard_slot", ArgumentScoreboardSlot.class, new ArgumentSerializerVoid<ArgumentScoreboardSlot>(ArgumentScoreboardSlot::displaySlot));
        ArgumentRegistry.register("score_holder", ArgumentScoreholder.class, new ArgumentScoreholder.c());
        ArgumentRegistry.register("swizzle", ArgumentRotationAxis.class, new ArgumentSerializerVoid<ArgumentRotationAxis>(ArgumentRotationAxis::swizzle));
        ArgumentRegistry.register("team", ArgumentScoreboardTeam.class, new ArgumentSerializerVoid<ArgumentScoreboardTeam>(ArgumentScoreboardTeam::team));
        ArgumentRegistry.register("item_slot", ArgumentInventorySlot.class, new ArgumentSerializerVoid<ArgumentInventorySlot>(ArgumentInventorySlot::slot));
        ArgumentRegistry.register("resource_location", ArgumentMinecraftKeyRegistered.class, new ArgumentSerializerVoid<ArgumentMinecraftKeyRegistered>(ArgumentMinecraftKeyRegistered::id));
        ArgumentRegistry.register("mob_effect", ArgumentMobEffect.class, new ArgumentSerializerVoid<ArgumentMobEffect>(ArgumentMobEffect::effect));
        ArgumentRegistry.register("function", ArgumentTag.class, new ArgumentSerializerVoid<ArgumentTag>(ArgumentTag::functions));
        ArgumentRegistry.register("entity_anchor", ArgumentAnchor.class, new ArgumentSerializerVoid<ArgumentAnchor>(ArgumentAnchor::anchor));
        ArgumentRegistry.register("int_range", ArgumentCriterionValue.b.class, new ArgumentSerializerVoid<ArgumentCriterionValue.b>(ArgumentCriterionValue::intRange));
        ArgumentRegistry.register("float_range", ArgumentCriterionValue.a.class, new ArgumentSerializerVoid<ArgumentCriterionValue.a>(ArgumentCriterionValue::floatRange));
        ArgumentRegistry.register("item_enchantment", ArgumentEnchantment.class, new ArgumentSerializerVoid<ArgumentEnchantment>(ArgumentEnchantment::enchantment));
        ArgumentRegistry.register("entity_summon", ArgumentEntitySummon.class, new ArgumentSerializerVoid<ArgumentEntitySummon>(ArgumentEntitySummon::id));
        ArgumentRegistry.register("dimension", ArgumentDimension.class, new ArgumentSerializerVoid<ArgumentDimension>(ArgumentDimension::dimension));
        ArgumentRegistry.register("time", ArgumentTime.class, new ArgumentSerializerVoid<ArgumentTime>(ArgumentTime::time));
        ArgumentRegistry.register("uuid", ArgumentUUID.class, new ArgumentSerializerVoid<ArgumentUUID>(ArgumentUUID::uuid));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ArgumentRegistry.register("test_argument", GameTestHarnessTestFunctionArgument.class, new ArgumentSerializerVoid<GameTestHarnessTestFunctionArgument>(GameTestHarnessTestFunctionArgument::testFunctionArgument));
            ArgumentRegistry.register("test_class", GameTestHarnessTestClassArgument.class, new ArgumentSerializerVoid<GameTestHarnessTestClassArgument>(GameTestHarnessTestClassArgument::testClassName));
        }
    }

    @Nullable
    private static a<?> get(MinecraftKey var0) {
        return BY_NAME.get(var0);
    }

    @Nullable
    private static a<?> get(ArgumentType<?> var0) {
        return BY_CLASS.get(var0.getClass());
    }

    public static <T extends ArgumentType<?>> void serialize(PacketDataSerializer var0, T var1) {
        a<?> var2 = ArgumentRegistry.get(var1);
        if (var2 == null) {
            LOGGER.error("Could not serialize {} ({}) - will not be sent to client!", var1, var1.getClass());
            var0.writeResourceLocation(new MinecraftKey(""));
            return;
        }
        var0.writeResourceLocation(var2.name);
        var2.serializer.serializeToNetwork(var1, var0);
    }

    @Nullable
    public static ArgumentType<?> deserialize(PacketDataSerializer var0) {
        MinecraftKey var1 = var0.readResourceLocation();
        a<?> var2 = ArgumentRegistry.get(var1);
        if (var2 == null) {
            LOGGER.error("Could not deserialize {}", (Object)var1);
            return null;
        }
        return var2.serializer.deserializeFromNetwork(var0);
    }

    private static <T extends ArgumentType<?>> void serializeToJson(JsonObject var0, T var1) {
        a<?> var2 = ArgumentRegistry.get(var1);
        if (var2 == null) {
            LOGGER.error("Could not serialize argument {} ({})!", var1, var1.getClass());
            var0.addProperty("type", "unknown");
        } else {
            var0.addProperty("type", "argument");
            var0.addProperty("parser", var2.name.toString());
            JsonObject var3 = new JsonObject();
            var2.serializer.serializeToJson(var1, var3);
            if (var3.size() > 0) {
                var0.add("properties", (JsonElement)var3);
            }
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> var0, CommandNode<S> var1) {
        Collection var4;
        JsonObject var2 = new JsonObject();
        if (var1 instanceof RootCommandNode) {
            var2.addProperty("type", "root");
        } else if (var1 instanceof LiteralCommandNode) {
            var2.addProperty("type", "literal");
        } else if (var1 instanceof ArgumentCommandNode) {
            ArgumentRegistry.serializeToJson(var2, ((ArgumentCommandNode)var1).getType());
        } else {
            LOGGER.error("Could not serialize node {} ({})!", var1, var1.getClass());
            var2.addProperty("type", "unknown");
        }
        JsonObject var3 = new JsonObject();
        for (CommandNode var5 : var1.getChildren()) {
            var3.add(var5.getName(), (JsonElement)ArgumentRegistry.serializeNodeToJson(var0, var5));
        }
        if (var3.size() > 0) {
            var2.add("children", (JsonElement)var3);
        }
        if (var1.getCommand() != null) {
            var2.addProperty("executable", Boolean.valueOf(true));
        }
        if (var1.getRedirect() != null && !(var4 = var0.getPath(var1.getRedirect())).isEmpty()) {
            CommandNode var5;
            var5 = new JsonArray();
            for (String var7 : var4) {
                var5.add(var7);
            }
            var2.add("redirect", (JsonElement)var5);
        }
        return var2;
    }

    public static boolean isTypeRegistered(ArgumentType<?> var0) {
        return ArgumentRegistry.get(var0) != null;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> var0) {
        Set var1 = Sets.newIdentityHashSet();
        HashSet var2 = Sets.newHashSet();
        ArgumentRegistry.findUsedArgumentTypes(var0, var2, var1);
        return var2;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> var0, Set<ArgumentType<?>> var1, Set<CommandNode<T>> var22) {
        if (!var22.add(var0)) {
            return;
        }
        if (var0 instanceof ArgumentCommandNode) {
            var1.add(((ArgumentCommandNode)var0).getType());
        }
        var0.getChildren().forEach(var2 -> ArgumentRegistry.findUsedArgumentTypes(var2, var1, var22));
        CommandNode var3 = var0.getRedirect();
        if (var3 != null) {
            ArgumentRegistry.findUsedArgumentTypes(var3, var1, var22);
        }
    }

    static class a<T extends ArgumentType<?>> {
        public final Class<T> clazz;
        public final ArgumentSerializer<T> serializer;
        public final MinecraftKey name;

        a(Class<T> var0, ArgumentSerializer<T> var1, MinecraftKey var2) {
            this.clazz = var0;
            this.serializer = var1;
            this.name = var2;
        }
    }
}

