/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.coordinates.ArgumentVectorPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.phys.Vec3D;

public class ArgumentVec3
implements ArgumentType<IVectorPosition> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "0.1 -0.5 .9", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.pos3d.incomplete"));
    public static final SimpleCommandExceptionType ERROR_MIXED_TYPE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.pos.mixed"));
    private final boolean centerCorrect;

    public ArgumentVec3(boolean var0) {
        this.centerCorrect = var0;
    }

    public static ArgumentVec3 vec3() {
        return new ArgumentVec3(true);
    }

    public static ArgumentVec3 vec3(boolean var0) {
        return new ArgumentVec3(var0);
    }

    public static Vec3D getVec3(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ((IVectorPosition)var0.getArgument(var1, IVectorPosition.class)).getPosition((CommandListenerWrapper)var0.getSource());
    }

    public static IVectorPosition getCoordinates(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (IVectorPosition)var0.getArgument(var1, IVectorPosition.class);
    }

    public IVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '^') {
            return ArgumentVectorPosition.parse(var0);
        }
        return VectorPosition.parseDouble(var0, this.centerCorrect);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof ICompletionProvider) {
            String var2 = var1.getRemaining();
            Collection<ICompletionProvider.a> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(ICompletionProvider.a.DEFAULT_LOCAL) : ((ICompletionProvider)var0.getSource()).getAbsoluteCoordinates();
            return ICompletionProvider.suggestCoordinates(var2, var3, var1, CommandDispatcher.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

