/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.util.MathHelper;

public class ArgumentAngle
implements ArgumentType<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "~", "~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.angle.incomplete"));
    public static final SimpleCommandExceptionType ERROR_INVALID_ANGLE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.angle.invalid"));

    public static ArgumentAngle angle() {
        return new ArgumentAngle();
    }

    public static float getAngle(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ((a)var0.getArgument(var1, a.class)).getAngle((CommandListenerWrapper)var0.getSource());
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        float var2;
        if (!var0.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        boolean var1 = ArgumentParserPosition.isRelative(var0);
        float f2 = var2 = var0.canRead() && var0.peek() != ' ' ? var0.readFloat() : 0.0f;
        if (Float.isNaN(var2) || Float.isInfinite(var2)) {
            throw ERROR_INVALID_ANGLE.createWithContext((ImmutableStringReader)var0);
        }
        return new a(var2, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static final class a {
        private final float angle;
        private final boolean isRelative;

        a(float var0, boolean var1) {
            this.angle = var0;
            this.isRelative = var1;
        }

        public float getAngle(CommandListenerWrapper var0) {
            return MathHelper.wrapDegrees(this.isRelative ? this.angle + var0.getRotation().y : this.angle);
        }
    }
}

