/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;

public interface ICompletionProvider {
    public Collection<String> getOnlinePlayerNames();

    default public Collection<String> getSelectedEntities() {
        return Collections.emptyList();
    }

    public Collection<String> getAllTeams();

    public Collection<MinecraftKey> getAvailableSoundEvents();

    public Stream<MinecraftKey> getRecipeNames();

    public CompletableFuture<Suggestions> customSuggestion(CommandContext<ICompletionProvider> var1, SuggestionsBuilder var2);

    default public Collection<a> getRelevantCoordinates() {
        return Collections.singleton(a.DEFAULT_GLOBAL);
    }

    default public Collection<a> getAbsoluteCoordinates() {
        return Collections.singleton(a.DEFAULT_GLOBAL);
    }

    public Set<ResourceKey<World>> levels();

    public IRegistryCustom registryAccess();

    public boolean hasPermission(int var1);

    public static <T> void filterResources(Iterable<T> var0, String var1, Function<T, MinecraftKey> var2, Consumer<T> var3) {
        boolean var4 = var1.indexOf(58) > -1;
        for (T var6 : var0) {
            MinecraftKey var7 = var2.apply(var6);
            if (var4) {
                String var8 = var7.toString();
                if (!ICompletionProvider.matchesSubStr(var1, var8)) continue;
                var3.accept(var6);
                continue;
            }
            if (!ICompletionProvider.matchesSubStr(var1, var7.getNamespace()) && (!var7.getNamespace().equals("minecraft") || !ICompletionProvider.matchesSubStr(var1, var7.getPath()))) continue;
            var3.accept(var6);
        }
    }

    public static <T> void filterResources(Iterable<T> var0, String var1, String var2, Function<T, MinecraftKey> var3, Consumer<T> var4) {
        if (var1.isEmpty()) {
            var0.forEach(var4);
        } else {
            String var5 = Strings.commonPrefix((CharSequence)var1, (CharSequence)var2);
            if (!var5.isEmpty()) {
                String var6 = var1.substring(var5.length());
                ICompletionProvider.filterResources(var0, var6, var3, var4);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<MinecraftKey> var02, SuggestionsBuilder var1, String var22) {
        String var3 = var1.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.filterResources(var02, var3, var22, var0 -> var0, var2 -> var1.suggest(var22 + var2));
        return var1.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<MinecraftKey> var02, SuggestionsBuilder var12) {
        String var2 = var12.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.filterResources(var02, var2, var0 -> var0, var1 -> var12.suggest(var1.toString()));
        return var12.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Iterable<T> var0, SuggestionsBuilder var1, Function<T, MinecraftKey> var2, Function<T, Message> var32) {
        String var4 = var1.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.filterResources(var0, var4, var2, var3 -> var1.suggest(((MinecraftKey)var2.apply(var3)).toString(), (Message)var32.apply(var3)));
        return var1.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<MinecraftKey> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggestResource(var0::iterator, var1);
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Stream<T> var0, SuggestionsBuilder var1, Function<T, MinecraftKey> var2, Function<T, Message> var3) {
        return ICompletionProvider.suggestResource(var0::iterator, var1, var2, var3);
    }

    public static CompletableFuture<Suggestions> suggestCoordinates(String var0, Collection<a> var1, SuggestionsBuilder var2, Predicate<String> var3) {
        ArrayList var4;
        block4: {
            String[] var5;
            block5: {
                block3: {
                    var4 = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)var0)) break block3;
                    for (a var6 : var1) {
                        String var7 = var6.x + " " + var6.y + " " + var6.z;
                        if (!var3.test(var7)) continue;
                        var4.add(var6.x);
                        var4.add(var6.x + " " + var6.y);
                        var4.add(var7);
                    }
                    break block4;
                }
                var5 = var0.split(" ");
                if (var5.length != 1) break block5;
                for (a var7 : var1) {
                    String var8 = var5[0] + " " + var7.y + " " + var7.z;
                    if (!var3.test(var8)) continue;
                    var4.add(var5[0] + " " + var7.y);
                    var4.add(var8);
                }
                break block4;
            }
            if (var5.length != 2) break block4;
            for (a var7 : var1) {
                String var8 = var5[0] + " " + var5[1] + " " + var7.z;
                if (!var3.test(var8)) continue;
                var4.add(var8);
            }
        }
        return ICompletionProvider.suggest(var4, var2);
    }

    public static CompletableFuture<Suggestions> suggest2DCoordinates(String var0, Collection<a> var1, SuggestionsBuilder var2, Predicate<String> var3) {
        ArrayList var4;
        block3: {
            block2: {
                var4 = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)var0)) break block2;
                for (a var6 : var1) {
                    String var7 = var6.x + " " + var6.z;
                    if (!var3.test(var7)) continue;
                    var4.add(var6.x);
                    var4.add(var7);
                }
                break block3;
            }
            String[] var5 = var0.split(" ");
            if (var5.length != 1) break block3;
            for (a var7 : var1) {
                String var8 = var5[0] + " " + var7.z;
                if (!var3.test(var8)) continue;
                var4.add(var8);
            }
        }
        return ICompletionProvider.suggest(var4, var2);
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> var0, SuggestionsBuilder var1) {
        String var2 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (String var4 : var0) {
            if (!ICompletionProvider.matchesSubStr(var2, var4.toLowerCase(Locale.ROOT))) continue;
            var1.suggest(var4);
        }
        return var1.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Stream<String> var0, SuggestionsBuilder var12) {
        String var2 = var12.getRemaining().toLowerCase(Locale.ROOT);
        var0.filter(var1 -> ICompletionProvider.matchesSubStr(var2, var1.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)var12).suggest(arg_0));
        return var12.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(String[] var0, SuggestionsBuilder var1) {
        String var2 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (String var6 : var0) {
            if (!ICompletionProvider.matchesSubStr(var2, var6.toLowerCase(Locale.ROOT))) continue;
            var1.suggest(var6);
        }
        return var1.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggest(Iterable<T> var0, SuggestionsBuilder var1, Function<T, String> var2, Function<T, Message> var3) {
        String var4 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (T var6 : var0) {
            String var7 = var2.apply(var6);
            if (!ICompletionProvider.matchesSubStr(var4, var7.toLowerCase(Locale.ROOT))) continue;
            var1.suggest(var7, var3.apply(var6));
        }
        return var1.buildFuture();
    }

    public static boolean matchesSubStr(String var0, String var1) {
        int var2 = 0;
        while (!var1.startsWith(var0, var2)) {
            if ((var2 = var1.indexOf(95, var2)) < 0) {
                return false;
            }
            ++var2;
        }
        return true;
    }

    public static class a {
        public static final a DEFAULT_LOCAL = new a("^", "^", "^");
        public static final a DEFAULT_GLOBAL = new a("~", "~", "~");
        public final String x;
        public final String y;
        public final String z;

        public a(String var0, String var1, String var2) {
            this.x = var0;
            this.y = var1;
            this.z = var2;
        }
    }
}

