/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionPlayer {
    public static final CriterionConditionPlayer ANY = new d().build();
    public static final int LOOKING_AT_RANGE = 100;
    private final CriterionConditionValue.IntegerRange level;
    @Nullable
    private final EnumGamemode gameType;
    private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> stats;
    private final Object2BooleanMap<MinecraftKey> recipes;
    private final Map<MinecraftKey, c> advancements;
    private final CriterionConditionEntity lookingAt;

    private static c advancementPredicateFromJson(JsonElement var0) {
        if (var0.isJsonPrimitive()) {
            boolean var1 = var0.getAsBoolean();
            return new b(var1);
        }
        Object2BooleanOpenHashMap var1 = new Object2BooleanOpenHashMap();
        JsonObject var2 = ChatDeserializer.convertToJsonObject(var0, "criterion data");
        var2.entrySet().forEach(arg_0 -> CriterionConditionPlayer.a((Object2BooleanMap)var1, arg_0));
        return new a((Object2BooleanMap<String>)var1);
    }

    CriterionConditionPlayer(CriterionConditionValue.IntegerRange var0, @Nullable EnumGamemode var1, Map<Statistic<?>, CriterionConditionValue.IntegerRange> var2, Object2BooleanMap<MinecraftKey> var3, Map<MinecraftKey, c> var4, CriterionConditionEntity var5) {
        this.level = var0;
        this.gameType = var1;
        this.stats = var2;
        this.recipes = var3;
        this.advancements = var4;
        this.lookingAt = var5;
    }

    public boolean matches(Entity var02) {
        Object var8;
        if (this == ANY) {
            return true;
        }
        if (!(var02 instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer var1 = (EntityPlayer)var02;
        if (!this.level.matches(var1.experienceLevel)) {
            return false;
        }
        if (this.gameType != null && this.gameType != var1.gameMode.getGameModeForPlayer()) {
            return false;
        }
        ServerStatisticManager var2 = var1.getStats();
        for (Map.Entry<Statistic<?>, CriterionConditionValue.IntegerRange> entry : this.stats.entrySet()) {
            int var5 = var2.getValue(entry.getKey());
            if (entry.getValue().matches(var5)) continue;
            return false;
        }
        RecipeBookServer var3 = var1.getRecipeBook();
        for (Object2BooleanMap.Entry var5 : this.recipes.object2BooleanEntrySet()) {
            if (var3.contains((MinecraftKey)var5.getKey()) == var5.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            AdvancementDataPlayer advancementDataPlayer = var1.getAdvancements();
            AdvancementDataWorld var5 = var1.getServer().getAdvancements();
            for (Map.Entry<MinecraftKey, c> entry : this.advancements.entrySet()) {
                var8 = var5.getAdvancement(entry.getKey());
                if (var8 != null && entry.getValue().test(advancementDataPlayer.getOrStartProgress((Advancement)var8))) continue;
                return false;
            }
        }
        if (this.lookingAt != CriterionConditionEntity.ANY) {
            Vec3D vec3D = var1.getEyePosition();
            Vec3D var5 = var1.getViewVector(1.0f);
            Vec3D var6 = vec3D.add(var5.x * 100.0, var5.y * 100.0, var5.z * 100.0);
            MovingObjectPositionEntity movingObjectPositionEntity = ProjectileHelper.getEntityHitResult(var1.level, var1, vec3D, var6, new AxisAlignedBB(vec3D, var6).inflate(1.0), var0 -> !var0.isSpectator(), 0.0f);
            if (movingObjectPositionEntity == null || movingObjectPositionEntity.getType() != MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                return false;
            }
            var8 = movingObjectPositionEntity.getEntity();
            if (!this.lookingAt.matches(var1, (Entity)var8) || !var1.hasLineOfSight((Entity)var8)) {
                return false;
            }
        }
        return true;
    }

    public static CriterionConditionPlayer fromJson(@Nullable JsonElement var0) {
        Object var14;
        Object var13;
        StatisticWrapper<?> var11;
        Object var102;
        Object var9;
        JsonElement var82;
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "player");
        CriterionConditionValue.IntegerRange var2 = CriterionConditionValue.IntegerRange.fromJson(var1.get("level"));
        String var3 = ChatDeserializer.getAsString(var1, "gamemode", "");
        EnumGamemode var4 = EnumGamemode.byName(var3, null);
        HashMap var5 = Maps.newHashMap();
        JsonArray var6 = ChatDeserializer.getAsJsonArray(var1, "stats", null);
        if (var6 != null) {
            for (JsonElement var82 : var6) {
                var9 = ChatDeserializer.convertToJsonObject(var82, "stats entry");
                var102 = new MinecraftKey(ChatDeserializer.getAsString((JsonObject)var9, "type"));
                var11 = IRegistry.STAT_TYPE.get((MinecraftKey)var102);
                if (var11 == null) {
                    throw new JsonParseException("Invalid stat type: " + (MinecraftKey)var102);
                }
                MinecraftKey var12 = new MinecraftKey(ChatDeserializer.getAsString((JsonObject)var9, "stat"));
                var13 = CriterionConditionPlayer.getStat(var11, var12);
                var14 = CriterionConditionValue.IntegerRange.fromJson(var9.get("value"));
                var5.put(var13, var14);
            }
        }
        Object2BooleanOpenHashMap var7 = new Object2BooleanOpenHashMap();
        var82 = ChatDeserializer.getAsJsonObject(var1, "recipes", new JsonObject());
        for (Object var102 : var82.entrySet()) {
            var11 = new MinecraftKey((String)var102.getKey());
            boolean var12 = ChatDeserializer.convertToBoolean((JsonElement)var102.getValue(), "recipe present");
            var7.put(var11, var12);
        }
        var9 = Maps.newHashMap();
        var102 = ChatDeserializer.getAsJsonObject(var1, "advancements", new JsonObject());
        for (Map.Entry var12 : var102.entrySet()) {
            var13 = new MinecraftKey((String)var12.getKey());
            var14 = CriterionConditionPlayer.advancementPredicateFromJson((JsonElement)var12.getValue());
            var9.put(var13, var14);
        }
        var11 = CriterionConditionEntity.fromJson(var1.get("looking_at"));
        return new CriterionConditionPlayer(var2, var4, var5, (Object2BooleanMap<MinecraftKey>)var7, (Map<MinecraftKey, c>)var9, (CriterionConditionEntity)((Object)var11));
    }

    private static <T> Statistic<T> getStat(StatisticWrapper<T> var0, MinecraftKey var1) {
        IRegistry<T> var2 = var0.getRegistry();
        T var3 = var2.get(var1);
        if (var3 == null) {
            throw new JsonParseException("Unknown object " + var1 + " for stat type " + IRegistry.STAT_TYPE.getKey(var0));
        }
        return var0.get(var3);
    }

    private static <T> MinecraftKey getStatValueId(Statistic<T> var0) {
        return var0.getType().getRegistry().getKey(var0.getValue());
    }

    public JsonElement serializeToJson() {
        JsonArray var12;
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add("level", this.level.serializeToJson());
        if (this.gameType != null) {
            var0.addProperty("gamemode", this.gameType.getName());
        }
        if (!this.stats.isEmpty()) {
            var12 = new JsonArray();
            this.stats.forEach((var1, var2) -> {
                JsonObject var3 = new JsonObject();
                var3.addProperty("type", IRegistry.STAT_TYPE.getKey(var1.getType()).toString());
                var3.addProperty("stat", CriterionConditionPlayer.getStatValueId(var1).toString());
                var3.add("value", var2.serializeToJson());
                var12.add((JsonElement)var3);
            });
            var0.add("stats", (JsonElement)var12);
        }
        if (!this.recipes.isEmpty()) {
            var12 = new JsonObject();
            this.recipes.forEach((arg_0, arg_1) -> CriterionConditionPlayer.a((JsonObject)var12, arg_0, arg_1));
            var0.add("recipes", (JsonElement)var12);
        }
        if (!this.advancements.isEmpty()) {
            var12 = new JsonObject();
            this.advancements.forEach((arg_0, arg_1) -> CriterionConditionPlayer.a((JsonObject)var12, arg_0, arg_1));
            var0.add("advancements", (JsonElement)var12);
        }
        var0.add("looking_at", this.lookingAt.serializeToJson());
        return var0;
    }

    private static /* synthetic */ void a(JsonObject var0, MinecraftKey var1, c var2) {
        var0.add(var1.toString(), var2.toJson());
    }

    private static /* synthetic */ void a(JsonObject var0, MinecraftKey var1, Boolean var2) {
        var0.addProperty(var1.toString(), var2);
    }

    private static /* synthetic */ void a(Object2BooleanMap var0, Map.Entry var1) {
        boolean var2 = ChatDeserializer.convertToBoolean((JsonElement)var1.getValue(), "criterion test");
        var0.put((Object)((String)var1.getKey()), var2);
    }

    static class b
    implements c {
        private final boolean state;

        public b(boolean var0) {
            this.state = var0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(Boolean.valueOf(this.state));
        }

        @Override
        public boolean test(AdvancementProgress var0) {
            return var0.isDone() == this.state;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static class a
    implements c {
        private final Object2BooleanMap<String> criterions;

        public a(Object2BooleanMap<String> var0) {
            this.criterions = var0;
        }

        @Override
        public JsonElement toJson() {
            JsonObject var0 = new JsonObject();
            this.criterions.forEach((arg_0, arg_1) -> ((JsonObject)var0).addProperty(arg_0, arg_1));
            return var0;
        }

        @Override
        public boolean test(AdvancementProgress var0) {
            for (Object2BooleanMap.Entry var2 : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress var3 = var0.getCriterion((String)var2.getKey());
                if (var3 != null && var3.isDone() == var2.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static interface c
    extends Predicate<AdvancementProgress> {
        public JsonElement toJson();
    }

    public static class d {
        private CriterionConditionValue.IntegerRange level = CriterionConditionValue.IntegerRange.ANY;
        @Nullable
        private EnumGamemode gameType;
        private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> stats = Maps.newHashMap();
        private final Object2BooleanMap<MinecraftKey> recipes = new Object2BooleanOpenHashMap();
        private final Map<MinecraftKey, c> advancements = Maps.newHashMap();
        private CriterionConditionEntity lookingAt = CriterionConditionEntity.ANY;

        public static d player() {
            return new d();
        }

        public d setLevel(CriterionConditionValue.IntegerRange var0) {
            this.level = var0;
            return this;
        }

        public d addStat(Statistic<?> var0, CriterionConditionValue.IntegerRange var1) {
            this.stats.put(var0, var1);
            return this;
        }

        public d addRecipe(MinecraftKey var0, boolean var1) {
            this.recipes.put((Object)var0, var1);
            return this;
        }

        public d setGameType(EnumGamemode var0) {
            this.gameType = var0;
            return this;
        }

        public d setLookingAt(CriterionConditionEntity var0) {
            this.lookingAt = var0;
            return this;
        }

        public d checkAdvancementDone(MinecraftKey var0, boolean var1) {
            this.advancements.put(var0, new b(var1));
            return this;
        }

        public d checkAdvancementCriterions(MinecraftKey var0, Map<String, Boolean> var1) {
            this.advancements.put(var0, new a((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(var1)));
            return this;
        }

        public CriterionConditionPlayer build() {
            return new CriterionConditionPlayer(this.level, this.gameType, this.stats, this.recipes, this.advancements, this.lookingAt);
        }
    }
}

