/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.MinecraftKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Advancements {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Map<MinecraftKey, Advancement> advancements = Maps.newHashMap();
    private final Set<Advancement> roots = Sets.newLinkedHashSet();
    private final Set<Advancement> tasks = Sets.newLinkedHashSet();
    @Nullable
    private a listener;

    private void remove(Advancement var0) {
        for (Advancement var2 : var0.getChildren()) {
            this.remove(var2);
        }
        LOGGER.info("Forgot about advancement {}", (Object)var0.getId());
        this.advancements.remove(var0.getId());
        if (var0.getParent() == null) {
            this.roots.remove(var0);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementRoot(var0);
            }
        } else {
            this.tasks.remove(var0);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementTask(var0);
            }
        }
    }

    public void remove(Set<MinecraftKey> var0) {
        for (MinecraftKey var2 : var0) {
            Advancement var3 = this.advancements.get(var2);
            if (var3 == null) {
                LOGGER.warn("Told to remove advancement {} but I don't know what that is", (Object)var2);
                continue;
            }
            this.remove(var3);
        }
    }

    public void add(Map<MinecraftKey, Advancement.SerializedAdvancement> var0) {
        HashMap var1 = Maps.newHashMap(var0);
        while (!var1.isEmpty()) {
            boolean var2 = false;
            Iterator var3 = var1.entrySet().iterator();
            while (var3.hasNext()) {
                Map.Entry var4 = var3.next();
                MinecraftKey var5 = (MinecraftKey)var4.getKey();
                Advancement.SerializedAdvancement var6 = (Advancement.SerializedAdvancement)var4.getValue();
                if (!var6.canBuild(this.advancements::get)) continue;
                Advancement var7 = var6.build(var5);
                this.advancements.put(var5, var7);
                var2 = true;
                var3.remove();
                if (var7.getParent() == null) {
                    this.roots.add(var7);
                    if (this.listener == null) continue;
                    this.listener.onAddAdvancementRoot(var7);
                    continue;
                }
                this.tasks.add(var7);
                if (this.listener == null) continue;
                this.listener.onAddAdvancementTask(var7);
            }
            if (var2) continue;
            for (Map.Entry var4 : var1.entrySet()) {
                LOGGER.error("Couldn't load advancement {}: {}", var4.getKey(), var4.getValue());
            }
        }
        LOGGER.info("Loaded {} advancements", (Object)this.advancements.size());
    }

    public void clear() {
        this.advancements.clear();
        this.roots.clear();
        this.tasks.clear();
        if (this.listener != null) {
            this.listener.onAdvancementsCleared();
        }
    }

    public Iterable<Advancement> getRoots() {
        return this.roots;
    }

    public Collection<Advancement> getAllAdvancements() {
        return this.advancements.values();
    }

    @Nullable
    public Advancement get(MinecraftKey var0) {
        return this.advancements.get(var0);
    }

    public void setListener(@Nullable a var0) {
        this.listener = var0;
        if (var0 != null) {
            for (Advancement var2 : this.roots) {
                var0.onAddAdvancementRoot(var2);
            }
            for (Advancement var2 : this.tasks) {
                var0.onAddAdvancementTask(var2);
            }
        }
    }

    public static interface a {
        public void onAddAdvancementRoot(Advancement var1);

        public void onRemoveAdvancementRoot(Advancement var1);

        public void onAddAdvancementTask(Advancement var1);

        public void onRemoveAdvancementTask(Advancement var1);

        public void onAdvancementsCleared();
    }
}

