/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import net.minecraft.util.MathHelper;

public class Vector4f {
    private float x;
    private float y;
    private float z;
    private float w;

    public Vector4f() {
    }

    public Vector4f(float var0, float var1, float var2, float var3) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
        this.w = var3;
    }

    public Vector4f(Vector3fa var0) {
        this(var0.x(), var0.y(), var0.z(), 1.0f);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Vector4f var1 = (Vector4f)var0;
        if (Float.compare(var1.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(var1.y, this.y) != 0) {
            return false;
        }
        if (Float.compare(var1.z, this.z) != 0) {
            return false;
        }
        return Float.compare(var1.w, this.w) == 0;
    }

    public int hashCode() {
        int var0 = Float.floatToIntBits(this.x);
        var0 = 31 * var0 + Float.floatToIntBits(this.y);
        var0 = 31 * var0 + Float.floatToIntBits(this.z);
        var0 = 31 * var0 + Float.floatToIntBits(this.w);
        return var0;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void mul(float var0) {
        this.x *= var0;
        this.y *= var0;
        this.z *= var0;
        this.w *= var0;
    }

    public void mul(Vector3fa var0) {
        this.x *= var0.x();
        this.y *= var0.y();
        this.z *= var0.z();
    }

    public void set(float var0, float var1, float var2, float var3) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
        this.w = var3;
    }

    public void add(float var0, float var1, float var2, float var3) {
        this.x += var0;
        this.y += var1;
        this.z += var2;
        this.w += var3;
    }

    public float dot(Vector4f var0) {
        return this.x * var0.x + this.y * var0.y + this.z * var0.z + this.w * var0.w;
    }

    public boolean normalize() {
        float var0 = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if ((double)var0 < 1.0E-5) {
            return false;
        }
        float var1 = MathHelper.fastInvSqrt(var0);
        this.x *= var1;
        this.y *= var1;
        this.z *= var1;
        this.w *= var1;
        return true;
    }

    public void transform(Matrix4f var0) {
        float var1 = this.x;
        float var2 = this.y;
        float var3 = this.z;
        float var4 = this.w;
        this.x = var0.m00 * var1 + var0.m01 * var2 + var0.m02 * var3 + var0.m03 * var4;
        this.y = var0.m10 * var1 + var0.m11 * var2 + var0.m12 * var3 + var0.m13 * var4;
        this.z = var0.m20 * var1 + var0.m21 * var2 + var0.m22 * var3 + var0.m23 * var4;
        this.w = var0.m30 * var1 + var0.m31 * var2 + var0.m32 * var3 + var0.m33 * var4;
    }

    public void transform(Quaternion var0) {
        Quaternion var1 = new Quaternion(var0);
        var1.mul(new Quaternion(this.x(), this.y(), this.z(), 0.0f));
        Quaternion var2 = new Quaternion(var0);
        var2.conj();
        var1.mul(var2);
        this.set(var1.i(), var1.j(), var1.k(), this.w());
    }

    public void perspectiveDivide() {
        this.x /= this.w;
        this.y /= this.w;
        this.z /= this.w;
        this.w = 1.0f;
    }

    public void lerp(Vector4f var0, float var1) {
        float var2 = 1.0f - var1;
        this.x = this.x * var2 + var0.x * var1;
        this.y = this.y * var2 + var0.y * var1;
        this.z = this.z * var2 + var0.z * var1;
        this.w = this.w * var2 + var0.w * var1;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

