/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.SystemUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;

public final class Vector3fa {
    public static final Codec<Vector3fa> CODEC = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new Vector3fa(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue())), var0 -> ImmutableList.of((Object)Float.valueOf(var0.x), (Object)Float.valueOf(var0.y), (Object)Float.valueOf(var0.z)));
    public static Vector3fa XN = new Vector3fa(-1.0f, 0.0f, 0.0f);
    public static Vector3fa XP = new Vector3fa(1.0f, 0.0f, 0.0f);
    public static Vector3fa YN = new Vector3fa(0.0f, -1.0f, 0.0f);
    public static Vector3fa YP = new Vector3fa(0.0f, 1.0f, 0.0f);
    public static Vector3fa ZN = new Vector3fa(0.0f, 0.0f, -1.0f);
    public static Vector3fa ZP = new Vector3fa(0.0f, 0.0f, 1.0f);
    public static Vector3fa ZERO = new Vector3fa(0.0f, 0.0f, 0.0f);
    private float x;
    private float y;
    private float z;

    public Vector3fa() {
    }

    public Vector3fa(float var0, float var1, float var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    public Vector3fa(Vector4f var0) {
        this(var0.x(), var0.y(), var0.z());
    }

    public Vector3fa(Vec3D var0) {
        this((float)var0.x, (float)var0.y, (float)var0.z);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Vector3fa var1 = (Vector3fa)var0;
        if (Float.compare(var1.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(var1.y, this.y) != 0) {
            return false;
        }
        return Float.compare(var1.z, this.z) == 0;
    }

    public int hashCode() {
        int var0 = Float.floatToIntBits(this.x);
        var0 = 31 * var0 + Float.floatToIntBits(this.y);
        var0 = 31 * var0 + Float.floatToIntBits(this.z);
        return var0;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void mul(float var0) {
        this.x *= var0;
        this.y *= var0;
        this.z *= var0;
    }

    public void mul(float var0, float var1, float var2) {
        this.x *= var0;
        this.y *= var1;
        this.z *= var2;
    }

    public void clamp(Vector3fa var0, Vector3fa var1) {
        this.x = MathHelper.clamp(this.x, var0.x(), var1.x());
        this.y = MathHelper.clamp(this.y, var0.x(), var1.y());
        this.z = MathHelper.clamp(this.z, var0.z(), var1.z());
    }

    public void clamp(float var0, float var1) {
        this.x = MathHelper.clamp(this.x, var0, var1);
        this.y = MathHelper.clamp(this.y, var0, var1);
        this.z = MathHelper.clamp(this.z, var0, var1);
    }

    public void set(float var0, float var1, float var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    public void load(Vector3fa var0) {
        this.x = var0.x;
        this.y = var0.y;
        this.z = var0.z;
    }

    public void add(float var0, float var1, float var2) {
        this.x += var0;
        this.y += var1;
        this.z += var2;
    }

    public void add(Vector3fa var0) {
        this.x += var0.x;
        this.y += var0.y;
        this.z += var0.z;
    }

    public void sub(Vector3fa var0) {
        this.x -= var0.x;
        this.y -= var0.y;
        this.z -= var0.z;
    }

    public float dot(Vector3fa var0) {
        return this.x * var0.x + this.y * var0.y + this.z * var0.z;
    }

    public boolean normalize() {
        float var0 = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)var0 < 1.0E-5) {
            return false;
        }
        float var1 = MathHelper.fastInvSqrt(var0);
        this.x *= var1;
        this.y *= var1;
        this.z *= var1;
        return true;
    }

    public void cross(Vector3fa var0) {
        float var1 = this.x;
        float var2 = this.y;
        float var3 = this.z;
        float var4 = var0.x();
        float var5 = var0.y();
        float var6 = var0.z();
        this.x = var2 * var6 - var3 * var5;
        this.y = var3 * var4 - var1 * var6;
        this.z = var1 * var5 - var2 * var4;
    }

    public void transform(Matrix3f var0) {
        float var1 = this.x;
        float var2 = this.y;
        float var3 = this.z;
        this.x = var0.m00 * var1 + var0.m01 * var2 + var0.m02 * var3;
        this.y = var0.m10 * var1 + var0.m11 * var2 + var0.m12 * var3;
        this.z = var0.m20 * var1 + var0.m21 * var2 + var0.m22 * var3;
    }

    public void transform(Quaternion var0) {
        Quaternion var1 = new Quaternion(var0);
        var1.mul(new Quaternion(this.x(), this.y(), this.z(), 0.0f));
        Quaternion var2 = new Quaternion(var0);
        var2.conj();
        var1.mul(var2);
        this.set(var1.i(), var1.j(), var1.k());
    }

    public void lerp(Vector3fa var0, float var1) {
        float var2 = 1.0f - var1;
        this.x = this.x * var2 + var0.x * var1;
        this.y = this.y * var2 + var0.y * var1;
        this.z = this.z * var2 + var0.z * var1;
    }

    public Quaternion rotation(float var0) {
        return new Quaternion(this, var0, false);
    }

    public Quaternion rotationDegrees(float var0) {
        return new Quaternion(this, var0, true);
    }

    public Vector3fa copy() {
        return new Vector3fa(this.x, this.y, this.z);
    }

    public void map(Float2FloatFunction var0) {
        this.x = var0.get(this.x);
        this.y = var0.get(this.y);
        this.z = var0.get(this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

