/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.ChunkProviderServer;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.EntityWaterAnimal;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.Explosion;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.Item;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NPC;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.NoteBlockData;
import net.minecraft.server.NoteDataList;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet54PlayNoteBlock;
import net.minecraft.server.Packet60Explosion;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet71Weather;
import net.minecraft.server.PlayerChunkMap;
import net.minecraft.server.PortalTravelAgent;
import net.minecraft.server.ReportedException;
import net.minecraft.server.ScoreboardSaveData;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.SpawnerCreature;
import net.minecraft.server.StructurePieceTreasure;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.World;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldGenBonusChest;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public class WorldServer
extends World {
    private final MinecraftServer server;
    private final EntityTracker tracker;
    private final PlayerChunkMap manager;
    private Set L;
    private TreeSet M;
    public ChunkProviderServer chunkProviderServer;
    public boolean savingDisabled;
    private boolean N;
    private int emptyTime;
    private final PortalTravelAgent P;
    private final SpawnerCreature Q = new SpawnerCreature();
    private NoteDataList[] R = new NoteDataList[]{new NoteDataList(null), new NoteDataList(null)};
    private int S;
    private static final StructurePieceTreasure[] T = new StructurePieceTreasure[]{new StructurePieceTreasure(Item.STICK.id, 0, 1, 3, 10), new StructurePieceTreasure(Block.WOOD.id, 0, 1, 3, 10), new StructurePieceTreasure(Block.LOG.id, 0, 1, 3, 10), new StructurePieceTreasure(Item.STONE_AXE.id, 0, 1, 1, 3), new StructurePieceTreasure(Item.WOOD_AXE.id, 0, 1, 1, 5), new StructurePieceTreasure(Item.STONE_PICKAXE.id, 0, 1, 1, 3), new StructurePieceTreasure(Item.WOOD_PICKAXE.id, 0, 1, 1, 5), new StructurePieceTreasure(Item.APPLE.id, 0, 2, 3, 5), new StructurePieceTreasure(Item.BREAD.id, 0, 2, 3, 3)};
    private List U = new ArrayList();
    private IntHashMap entitiesById;

    public WorldServer(MinecraftServer minecraftServer, IDataManager iDataManager, String string, int n, WorldSettings worldSettings, MethodProfiler methodProfiler, IConsoleLogManager iConsoleLogManager) {
        super(iDataManager, string, worldSettings, WorldProvider.byDimension(n), methodProfiler, iConsoleLogManager);
        this.server = minecraftServer;
        this.tracker = new EntityTracker(this);
        this.manager = new PlayerChunkMap(this, minecraftServer.getPlayerList().o());
        if (this.entitiesById == null) {
            this.entitiesById = new IntHashMap();
        }
        if (this.L == null) {
            this.L = new HashSet();
        }
        if (this.M == null) {
            this.M = new TreeSet();
        }
        this.P = new PortalTravelAgent(this);
        this.scoreboard = new ScoreboardServer(minecraftServer);
        ScoreboardSaveData scoreboardSaveData = (ScoreboardSaveData)this.worldMaps.get(ScoreboardSaveData.class, "scoreboard");
        if (scoreboardSaveData == null) {
            scoreboardSaveData = new ScoreboardSaveData();
            this.worldMaps.a("scoreboard", scoreboardSaveData);
        }
        scoreboardSaveData.a(this.scoreboard);
        ((ScoreboardServer)this.scoreboard).a(scoreboardSaveData);
    }

    @Override
    public void doTick() {
        super.doTick();
        if (this.getWorldData().isHardcore() && this.difficulty < 3) {
            this.difficulty = 3;
        }
        this.worldProvider.e.b();
        if (this.everyoneDeeplySleeping()) {
            if (this.getGameRules().getBoolean("doDaylightCycle")) {
                long l = this.worldData.getDayTime() + 24000L;
                this.worldData.setDayTime(l - l % 24000L);
            }
            this.d();
        }
        this.methodProfiler.a("mobSpawner");
        if (this.getGameRules().getBoolean("doMobSpawning")) {
            this.Q.spawnEntities(this, this.allowMonsters, this.allowAnimals, this.worldData.getTime() % 400L == 0L);
        }
        this.methodProfiler.c("chunkSource");
        this.chunkProvider.unloadChunks();
        int n = this.a(1.0f);
        if (n != this.j) {
            this.j = n;
        }
        this.worldData.setTime(this.worldData.getTime() + 1L);
        if (this.getGameRules().getBoolean("doDaylightCycle")) {
            this.worldData.setDayTime(this.worldData.getDayTime() + 1L);
        }
        this.methodProfiler.c("tickPending");
        this.a(false);
        this.methodProfiler.c("tickTiles");
        this.g();
        this.methodProfiler.c("chunkMap");
        this.manager.flush();
        this.methodProfiler.c("village");
        this.villages.tick();
        this.siegeManager.a();
        this.methodProfiler.c("portalForcer");
        this.P.a(this.getTime());
        this.methodProfiler.b();
        this.aa();
    }

    public BiomeMeta a(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        List list = this.L().getMobsFor(enumCreatureType, n, n2, n3);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (BiomeMeta)WeightedRandom.a(this.random, list);
    }

    @Override
    public void everyoneSleeping() {
        this.N = !this.players.isEmpty();
        for (EntityHuman entityHuman : this.players) {
            if (entityHuman.isSleeping()) continue;
            this.N = false;
            break;
        }
    }

    protected void d() {
        this.N = false;
        for (EntityHuman entityHuman : this.players) {
            if (!entityHuman.isSleeping()) continue;
            entityHuman.a(false, false, true);
        }
        this.Z();
    }

    private void Z() {
        this.worldData.setWeatherDuration(0);
        this.worldData.setStorm(false);
        this.worldData.setThunderDuration(0);
        this.worldData.setThundering(false);
    }

    public boolean everyoneDeeplySleeping() {
        if (this.N && !this.isStatic) {
            for (EntityHuman entityHuman : this.players) {
                if (entityHuman.isDeeplySleeping()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void g() {
        super.g();
        int n = 0;
        int n2 = 0;
        for (ChunkCoordIntPair chunkCoordIntPair : this.chunkTickList) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = chunkCoordIntPair.x * 16;
            int n9 = chunkCoordIntPair.z * 16;
            this.methodProfiler.a("getChunk");
            Chunk chunk = this.getChunkAt(chunkCoordIntPair.x, chunkCoordIntPair.z);
            this.a(n8, n9, chunk);
            this.methodProfiler.c("tickChunk");
            chunk.k();
            this.methodProfiler.c("thunder");
            if (this.random.nextInt(100000) == 0 && this.Q() && this.P()) {
                this.k = this.k * 3 + 1013904223;
                n7 = this.k >> 2;
                n6 = n8 + (n7 & 0xF);
                n5 = n9 + (n7 >> 8 & 0xF);
                n4 = this.h(n6, n5);
                if (this.isRainingAt(n6, n4, n5)) {
                    this.strikeLightning(new EntityLightning(this, n6, n4, n5));
                }
            }
            this.methodProfiler.c("iceandsnow");
            if (this.random.nextInt(16) == 0) {
                BiomeBase biomeBase;
                this.k = this.k * 3 + 1013904223;
                n7 = this.k >> 2;
                n6 = n7 & 0xF;
                n5 = n7 >> 8 & 0xF;
                n4 = this.h(n6 + n8, n5 + n9);
                if (this.y(n6 + n8, n4 - 1, n5 + n9)) {
                    this.setTypeIdUpdate(n6 + n8, n4 - 1, n5 + n9, Block.ICE.id);
                }
                if (this.Q() && this.z(n6 + n8, n4, n5 + n9)) {
                    this.setTypeIdUpdate(n6 + n8, n4, n5 + n9, Block.SNOW.id);
                }
                if (this.Q() && (biomeBase = this.getBiome(n6 + n8, n5 + n9)).d() && (n3 = this.getTypeId(n6 + n8, n4 - 1, n5 + n9)) != 0) {
                    Block.byId[n3].g(this, n6 + n8, n4 - 1, n5 + n9);
                }
            }
            this.methodProfiler.c("tickTiles");
            for (ChunkSection chunkSection : chunk.i()) {
                if (chunkSection == null || !chunkSection.shouldTick()) continue;
                for (int i = 0; i < 3; ++i) {
                    this.k = this.k * 3 + 1013904223;
                    n3 = this.k >> 2;
                    int n10 = n3 & 0xF;
                    int n11 = n3 >> 8 & 0xF;
                    int n12 = n3 >> 16 & 0xF;
                    int n13 = chunkSection.getTypeId(n10, n12, n11);
                    ++n2;
                    Block block = Block.byId[n13];
                    if (block == null || !block.isTicking()) continue;
                    ++n;
                    block.a((World)this, n10 + n8, n12 + chunkSection.getYPosition(), n11 + n9, this.random);
                }
            }
            this.methodProfiler.b();
        }
    }

    @Override
    public boolean a(int n, int n2, int n3, int n4) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        return this.U.contains(nextTickListEntry);
    }

    @Override
    public void a(int n, int n2, int n3, int n4, int n5) {
        this.a(n, n2, n3, n4, n5, 0);
    }

    @Override
    public void a(int n, int n2, int n3, int n4, int n5, int n6) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        int n7 = 0;
        if (this.d && n4 > 0) {
            if (Block.byId[n4].l()) {
                int n8;
                n7 = 8;
                if (this.e(nextTickListEntry.a - n7, nextTickListEntry.b - n7, nextTickListEntry.c - n7, nextTickListEntry.a + n7, nextTickListEntry.b + n7, nextTickListEntry.c + n7) && (n8 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) == nextTickListEntry.d && n8 > 0) {
                    Block.byId[n8].a((World)this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
                }
                return;
            }
            n5 = 1;
        }
        if (this.e(n - n7, n2 - n7, n3 - n7, n + n7, n2 + n7, n3 + n7)) {
            if (n4 > 0) {
                nextTickListEntry.a((long)n5 + this.worldData.getTime());
                nextTickListEntry.a(n6);
            }
            if (!this.L.contains(nextTickListEntry)) {
                this.L.add(nextTickListEntry);
                this.M.add(nextTickListEntry);
            }
        }
    }

    @Override
    public void b(int n, int n2, int n3, int n4, int n5, int n6) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        nextTickListEntry.a(n6);
        if (n4 > 0) {
            nextTickListEntry.a((long)n5 + this.worldData.getTime());
        }
        if (!this.L.contains(nextTickListEntry)) {
            this.L.add(nextTickListEntry);
            this.M.add(nextTickListEntry);
        }
    }

    @Override
    public void tickEntities() {
        if (this.players.isEmpty()) {
            if (this.emptyTime++ >= 1200) {
                return;
            }
        } else {
            this.i();
        }
        super.tickEntities();
    }

    public void i() {
        this.emptyTime = 0;
    }

    @Override
    public boolean a(boolean bl) {
        NextTickListEntry nextTickListEntry;
        int n = this.M.size();
        if (n != this.L.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        this.methodProfiler.a("cleaning");
        for (int i = 0; i < n; ++i) {
            nextTickListEntry = (NextTickListEntry)this.M.first();
            if (!bl && nextTickListEntry.e > this.worldData.getTime()) break;
            this.M.remove(nextTickListEntry);
            this.L.remove(nextTickListEntry);
            this.U.add(nextTickListEntry);
        }
        this.methodProfiler.b();
        this.methodProfiler.a("ticking");
        Iterator iterator = this.U.iterator();
        while (iterator.hasNext()) {
            nextTickListEntry = (NextTickListEntry)iterator.next();
            iterator.remove();
            int n2 = 0;
            if (this.e(nextTickListEntry.a - n2, nextTickListEntry.b - n2, nextTickListEntry.c - n2, nextTickListEntry.a + n2, nextTickListEntry.b + n2, nextTickListEntry.c + n2)) {
                int n3 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c);
                if (n3 <= 0 || !Block.b(n3, nextTickListEntry.d)) continue;
                try {
                    Block.byId[n3].a((World)this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
                    continue;
                }
                catch (Throwable throwable) {
                    int n4;
                    CrashReport crashReport = CrashReport.a(throwable, "Exception while ticking a block");
                    CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Block being ticked");
                    try {
                        n4 = this.getData(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c);
                    }
                    catch (Throwable throwable2) {
                        n4 = -1;
                    }
                    CrashReportSystemDetails.a(crashReportSystemDetails, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, n3, n4);
                    throw new ReportedException(crashReport);
                }
            }
            this.a(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, nextTickListEntry.d, 0);
        }
        this.methodProfiler.b();
        this.U.clear();
        return !this.M.isEmpty();
    }

    @Override
    public List a(Chunk chunk, boolean bl) {
        ArrayList<NextTickListEntry> arrayList = null;
        ChunkCoordIntPair chunkCoordIntPair = chunk.l();
        int n = (chunkCoordIntPair.x << 4) - 2;
        int n2 = n + 16 + 2;
        int n3 = (chunkCoordIntPair.z << 4) - 2;
        int n4 = n3 + 16 + 2;
        for (int i = 0; i < 2; ++i) {
            Iterator iterator;
            if (i == 0) {
                iterator = this.M.iterator();
            } else {
                iterator = this.U.iterator();
                if (!this.U.isEmpty()) {
                    System.out.println(this.U.size());
                }
            }
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                if (nextTickListEntry.a < n || nextTickListEntry.a >= n2 || nextTickListEntry.c < n3 || nextTickListEntry.c >= n4) continue;
                if (bl) {
                    this.L.remove(nextTickListEntry);
                    iterator.remove();
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<NextTickListEntry>();
                }
                arrayList.add(nextTickListEntry);
            }
        }
        return arrayList;
    }

    @Override
    public void entityJoinedWorld(Entity entity, boolean bl) {
        if (!this.server.getSpawnAnimals() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
            entity.die();
        }
        if (!this.server.getSpawnNPCs() && entity instanceof NPC) {
            entity.die();
        }
        super.entityJoinedWorld(entity, bl);
    }

    @Override
    protected IChunkProvider j() {
        IChunkLoader iChunkLoader = this.dataManager.createChunkLoader(this.worldProvider);
        this.chunkProviderServer = new ChunkProviderServer(this, iChunkLoader, this.worldProvider.getChunkProvider());
        return this.chunkProviderServer;
    }

    public List getTileEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        ArrayList<TileEntity> arrayList = new ArrayList<TileEntity>();
        for (int i = 0; i < this.tileEntityList.size(); ++i) {
            TileEntity tileEntity = (TileEntity)this.tileEntityList.get(i);
            if (tileEntity.x < n || tileEntity.y < n2 || tileEntity.z < n3 || tileEntity.x >= n4 || tileEntity.y >= n5 || tileEntity.z >= n6) continue;
            arrayList.add(tileEntity);
        }
        return arrayList;
    }

    @Override
    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        return !this.server.a(this, n, n2, n3, entityHuman);
    }

    @Override
    protected void a(WorldSettings worldSettings) {
        if (this.entitiesById == null) {
            this.entitiesById = new IntHashMap();
        }
        if (this.L == null) {
            this.L = new HashSet();
        }
        if (this.M == null) {
            this.M = new TreeSet();
        }
        this.b(worldSettings);
        super.a(worldSettings);
    }

    protected void b(WorldSettings worldSettings) {
        if (!this.worldProvider.e()) {
            this.worldData.setSpawn(0, this.worldProvider.getSeaLevel(), 0);
            return;
        }
        this.isLoading = true;
        WorldChunkManager worldChunkManager = this.worldProvider.e;
        List list = worldChunkManager.a();
        Random random = new Random(this.getSeed());
        ChunkPosition chunkPosition = worldChunkManager.a(0, 0, 256, list, random);
        int n = 0;
        int n2 = this.worldProvider.getSeaLevel();
        int n3 = 0;
        if (chunkPosition != null) {
            n = chunkPosition.x;
            n3 = chunkPosition.z;
        } else {
            this.getLogger().warning("Unable to find spawn biome");
        }
        int n4 = 0;
        while (!this.worldProvider.canSpawn(n, n3)) {
            n += random.nextInt(64) - random.nextInt(64);
            n3 += random.nextInt(64) - random.nextInt(64);
            if (++n4 != 1000) continue;
        }
        this.worldData.setSpawn(n, n2, n3);
        this.isLoading = false;
        if (worldSettings.c()) {
            this.k();
        }
    }

    protected void k() {
        int n;
        int n2;
        int n3;
        WorldGenBonusChest worldGenBonusChest = new WorldGenBonusChest(T, 10);
        for (int i = 0; i < 10 && !worldGenBonusChest.a(this, this.random, n3 = this.worldData.c() + this.random.nextInt(6) - this.random.nextInt(6), n2 = this.i(n3, n = this.worldData.e() + this.random.nextInt(6) - this.random.nextInt(6)) + 1, n); ++i) {
        }
    }

    public ChunkCoordinates getDimensionSpawn() {
        return this.worldProvider.h();
    }

    public void save(boolean bl, IProgressUpdate iProgressUpdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.a("Saving level");
        }
        this.a();
        if (iProgressUpdate != null) {
            iProgressUpdate.c("Saving chunks");
        }
        this.chunkProvider.saveChunks(bl, iProgressUpdate);
    }

    public void flushSave() {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        this.chunkProvider.b();
    }

    protected void a() {
        this.G();
        this.dataManager.saveWorldData(this.worldData, this.server.getPlayerList().q());
        this.worldMaps.a();
    }

    @Override
    protected void a(Entity entity) {
        super.a(entity);
        this.entitiesById.a(entity.id, entity);
        Entity[] entityArray = entity.ao();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.entitiesById.a(entityArray[i].id, entityArray[i]);
            }
        }
    }

    @Override
    protected void b(Entity entity) {
        super.b(entity);
        this.entitiesById.d(entity.id);
        Entity[] entityArray = entity.ao();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.entitiesById.d(entityArray[i].id);
            }
        }
    }

    @Override
    public Entity getEntity(int n) {
        return (Entity)this.entitiesById.get(n);
    }

    @Override
    public boolean strikeLightning(Entity entity) {
        if (super.strikeLightning(entity)) {
            this.server.getPlayerList().sendPacketNearby(entity.locX, entity.locY, entity.locZ, 512.0, this.worldProvider.dimension, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    @Override
    public void broadcastEntityEffect(Entity entity, byte by) {
        Packet38EntityStatus packet38EntityStatus = new Packet38EntityStatus(entity.id, by);
        this.getTracker().sendPacketToEntity(entity, packet38EntityStatus);
    }

    @Override
    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl, boolean bl2) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.b = bl2;
        explosion.a();
        explosion.a(false);
        if (!bl2) {
            explosion.blocks.clear();
        }
        for (EntityHuman entityHuman : this.players) {
            if (!(entityHuman.e(d, d2, d3) < 4096.0)) continue;
            ((EntityPlayer)entityHuman).playerConnection.sendPacket(new Packet60Explosion(d, d2, d3, f, explosion.blocks, (Vec3D)explosion.b().get(entityHuman)));
        }
        return explosion;
    }

    @Override
    public void playNote(int n, int n2, int n3, int n4, int n5, int n6) {
        NoteBlockData noteBlockData = new NoteBlockData(n, n2, n3, n4, n5, n6);
        for (NoteBlockData noteBlockData2 : this.R[this.S]) {
            if (!noteBlockData2.equals(noteBlockData)) continue;
            return;
        }
        this.R[this.S].add(noteBlockData);
    }

    private void aa() {
        while (!this.R[this.S].isEmpty()) {
            int n = this.S;
            this.S ^= 1;
            for (NoteBlockData noteBlockData : this.R[n]) {
                if (!this.a(noteBlockData)) continue;
                this.server.getPlayerList().sendPacketNearby(noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), 64.0, this.worldProvider.dimension, new Packet54PlayNoteBlock(noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), noteBlockData.f(), noteBlockData.d(), noteBlockData.e()));
            }
            this.R[n].clear();
        }
    }

    private boolean a(NoteBlockData noteBlockData) {
        int n = this.getTypeId(noteBlockData.a(), noteBlockData.b(), noteBlockData.c());
        if (n == noteBlockData.f()) {
            return Block.byId[n].b(this, noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), noteBlockData.d(), noteBlockData.e());
        }
        return false;
    }

    public void saveLevel() {
        this.dataManager.a();
    }

    @Override
    protected void o() {
        boolean bl = this.Q();
        super.o();
        if (bl != this.Q()) {
            if (bl) {
                this.server.getPlayerList().sendAll(new Packet70Bed(2, 0));
            } else {
                this.server.getPlayerList().sendAll(new Packet70Bed(1, 0));
            }
        }
    }

    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    public EntityTracker getTracker() {
        return this.tracker;
    }

    public PlayerChunkMap getPlayerChunkMap() {
        return this.manager;
    }

    public PortalTravelAgent t() {
        return this.P;
    }
}

