/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapDecoration;
import net.minecraft.server.WorldMapHumanTracker;

public class WorldMap
extends WorldMapBase {
    public int centerX;
    public int centerZ;
    public byte map;
    public byte scale;
    public byte[] colors = new byte[16384];
    public List f = new ArrayList();
    private Map i = new HashMap();
    public Map g = new LinkedHashMap();

    public WorldMap(String string) {
        super(string);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.map = nBTTagCompound.getByte("dimension");
        this.centerX = nBTTagCompound.getInt("xCenter");
        this.centerZ = nBTTagCompound.getInt("zCenter");
        this.scale = nBTTagCompound.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int n = nBTTagCompound.getShort("width");
        int n2 = nBTTagCompound.getShort("height");
        if (n == 128 && n2 == 128) {
            this.colors = nBTTagCompound.getByteArray("colors");
        } else {
            byte[] byArray = nBTTagCompound.getByteArray("colors");
            this.colors = new byte[16384];
            int n3 = (128 - n) / 2;
            int n4 = (128 - n2) / 2;
            for (int i = 0; i < n2; ++i) {
                int n5 = i + n4;
                if (n5 < 0 && n5 >= 128) continue;
                for (int j = 0; j < n; ++j) {
                    int n6 = j + n3;
                    if (n6 < 0 && n6 >= 128) continue;
                    this.colors[n6 + n5 * 128] = byArray[j + i * n];
                }
            }
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("dimension", this.map);
        nBTTagCompound.setInt("xCenter", this.centerX);
        nBTTagCompound.setInt("zCenter", this.centerZ);
        nBTTagCompound.setByte("scale", this.scale);
        nBTTagCompound.setShort("width", (short)128);
        nBTTagCompound.setShort("height", (short)128);
        nBTTagCompound.setByteArray("colors", this.colors);
    }

    public void a(EntityHuman entityHuman, ItemStack itemStack) {
        if (!this.i.containsKey(entityHuman)) {
            WorldMapHumanTracker worldMapHumanTracker = new WorldMapHumanTracker(this, entityHuman);
            this.i.put(entityHuman, worldMapHumanTracker);
            this.f.add(worldMapHumanTracker);
        }
        if (!entityHuman.inventory.c(itemStack)) {
            this.g.remove(entityHuman.getName());
        }
        for (int i = 0; i < this.f.size(); ++i) {
            WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.f.get(i);
            if (worldMapHumanTracker.trackee.dead || !worldMapHumanTracker.trackee.inventory.c(itemStack) && !itemStack.A()) {
                this.i.remove(worldMapHumanTracker.trackee);
                this.f.remove(worldMapHumanTracker);
                continue;
            }
            if (itemStack.A() || worldMapHumanTracker.trackee.dimension != this.map) continue;
            this.a(0, worldMapHumanTracker.trackee.world, worldMapHumanTracker.trackee.getName(), worldMapHumanTracker.trackee.locX, worldMapHumanTracker.trackee.locZ, worldMapHumanTracker.trackee.yaw);
        }
        if (itemStack.A()) {
            this.a(1, entityHuman.world, "frame-" + itemStack.B().id, itemStack.B().x, itemStack.B().z, itemStack.B().direction * 90);
        }
    }

    private void a(int n, World world, String string, double d, double d2, double d3) {
        byte by;
        int n2 = 1 << this.scale;
        float f = (float)(d - (double)this.centerX) / (float)n2;
        float f2 = (float)(d2 - (double)this.centerZ) / (float)n2;
        byte by2 = (byte)((double)(f * 2.0f) + 0.5);
        byte by3 = (byte)((double)(f2 * 2.0f) + 0.5);
        int n3 = 63;
        if (f >= (float)(-n3) && f2 >= (float)(-n3) && f <= (float)n3 && f2 <= (float)n3) {
            by = (byte)((d3 += d3 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.map < 0) {
                int n4 = (int)(world.getWorldData().getDayTime() / 10L);
                by = (byte)(n4 * n4 * 34187121 + n4 * 121 >> 15 & 0xF);
            }
        } else if (Math.abs(f) < 320.0f && Math.abs(f2) < 320.0f) {
            n = 6;
            by = 0;
            if (f <= (float)(-n3)) {
                by2 = (byte)((double)(n3 * 2) + 2.5);
            }
            if (f2 <= (float)(-n3)) {
                by3 = (byte)((double)(n3 * 2) + 2.5);
            }
            if (f >= (float)n3) {
                by2 = (byte)(n3 * 2 + 1);
            }
            if (f2 >= (float)n3) {
                by3 = (byte)(n3 * 2 + 1);
            }
        } else {
            this.g.remove(string);
            return;
        }
        this.g.put(string, new WorldMapDecoration(this, (byte)n, by2, by3, by));
    }

    public byte[] getUpdatePacket(ItemStack itemStack, World world, EntityHuman entityHuman) {
        WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.i.get(entityHuman);
        if (worldMapHumanTracker == null) {
            return null;
        }
        return worldMapHumanTracker.a(itemStack);
    }

    public void flagDirty(int n, int n2, int n3) {
        super.c();
        for (int i = 0; i < this.f.size(); ++i) {
            WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.f.get(i);
            if (worldMapHumanTracker.b[n] < 0 || worldMapHumanTracker.b[n] > n2) {
                worldMapHumanTracker.b[n] = n2;
            }
            if (worldMapHumanTracker.c[n] >= 0 && worldMapHumanTracker.c[n] >= n3) continue;
            worldMapHumanTracker.c[n] = n3;
        }
    }

    public WorldMapHumanTracker a(EntityHuman entityHuman) {
        WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.i.get(entityHuman);
        if (worldMapHumanTracker == null) {
            worldMapHumanTracker = new WorldMapHumanTracker(this, entityHuman);
            this.i.put(entityHuman, worldMapHumanTracker);
            this.f.add(worldMapHumanTracker);
        }
        return worldMapHumanTracker;
    }
}

