/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.BlockHopper;
import net.minecraft.server.BlockSnow;
import net.minecraft.server.BlockStairs;
import net.minecraft.server.BlockStepAbstract;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCache;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportChunkStats;
import net.minecraft.server.CrashReportPlayers;
import net.minecraft.server.CrashReportSourceBlockType;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.Direction;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityMinecartAbstract;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.Explosion;
import net.minecraft.server.Facing;
import net.minecraft.server.GameRules;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IEntitySelector;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.IWorldAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.PathEntity;
import net.minecraft.server.Pathfinder;
import net.minecraft.server.ReportedException;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.Vec3DPool;
import net.minecraft.server.VillageCollection;
import net.minecraft.server.VillageSiege;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapCollection;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public abstract class World
implements IBlockAccess {
    public boolean d;
    public List entityList = new ArrayList();
    protected List f = new ArrayList();
    public List tileEntityList = new ArrayList();
    private List a = new ArrayList();
    private List b = new ArrayList();
    public List players = new ArrayList();
    public List i = new ArrayList();
    private long c = 0xFFFFFFL;
    public int j;
    protected int k = new Random().nextInt();
    protected final int l = 1013904223;
    protected float m;
    protected float n;
    protected float o;
    protected float p;
    public int q;
    public int difficulty;
    public Random random = new Random();
    public final WorldProvider worldProvider;
    protected List u = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final IDataManager dataManager;
    protected WorldData worldData;
    public boolean isLoading;
    public WorldMapCollection worldMaps;
    public final VillageCollection villages;
    protected final VillageSiege siegeManager = new VillageSiege(this);
    public final MethodProfiler methodProfiler;
    private final Vec3DPool J = new Vec3DPool(300, 2000);
    private final Calendar K = Calendar.getInstance();
    protected Scoreboard scoreboard = new Scoreboard();
    private final IConsoleLogManager logAgent;
    private ArrayList M = new ArrayList();
    private boolean N;
    protected boolean allowMonsters = true;
    protected boolean allowAnimals = true;
    protected Set chunkTickList = new HashSet();
    private int O = this.random.nextInt(12000);
    int[] H = new int[32768];
    public boolean isStatic;

    public BiomeBase getBiome(int n, int n2) {
        Chunk chunk;
        if (this.isLoaded(n, 0, n2) && (chunk = this.getChunkAtWorldCoords(n, n2)) != null) {
            return chunk.a(n & 0xF, n2 & 0xF, this.worldProvider.e);
        }
        return this.worldProvider.e.getBiome(n, n2);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.e;
    }

    public World(IDataManager iDataManager, String string, WorldSettings worldSettings, WorldProvider worldProvider, MethodProfiler methodProfiler, IConsoleLogManager iConsoleLogManager) {
        VillageCollection villageCollection;
        this.dataManager = iDataManager;
        this.methodProfiler = methodProfiler;
        this.worldMaps = new WorldMapCollection(iDataManager);
        this.logAgent = iConsoleLogManager;
        this.worldData = iDataManager.getWorldData();
        this.worldProvider = worldProvider != null ? worldProvider : (this.worldData != null && this.worldData.j() != 0 ? WorldProvider.byDimension(this.worldData.j()) : WorldProvider.byDimension(0));
        if (this.worldData == null) {
            this.worldData = new WorldData(worldSettings, string);
        } else {
            this.worldData.setName(string);
        }
        this.worldProvider.a(this);
        this.chunkProvider = this.j();
        if (!this.worldData.isInitialized()) {
            try {
                this.a(worldSettings);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    this.a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            this.worldData.d(true);
        }
        if ((villageCollection = (VillageCollection)this.worldMaps.get(VillageCollection.class, "villages")) == null) {
            this.villages = new VillageCollection(this);
            this.worldMaps.a("villages", this.villages);
        } else {
            this.villages = villageCollection;
            this.villages.a(this);
        }
        this.A();
        this.a();
    }

    protected abstract IChunkProvider j();

    protected void a(WorldSettings worldSettings) {
        this.worldData.d(true);
    }

    public int b(int n, int n2) {
        int n3 = 63;
        while (!this.isEmpty(n, n3 + 1, n2)) {
            ++n3;
        }
        return this.getTypeId(n, n3, n2);
    }

    @Override
    public int getTypeId(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        Chunk chunk = null;
        try {
            chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.getTypeId(n & 0xF, n2, n3 & 0xF);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Exception getting block type in world");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Requested block coordinates");
            crashReportSystemDetails.a("Found chunk", chunk == null);
            crashReportSystemDetails.a("Location", CrashReportSystemDetails.a(n, n2, n3));
            throw new ReportedException(crashReport);
        }
    }

    public boolean isEmpty(int n, int n2, int n3) {
        return this.getTypeId(n, n2, n3) == 0;
    }

    public boolean isTileEntity(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        return Block.byId[n4] != null && Block.byId[n4].t();
    }

    public int e(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (Block.byId[n4] != null) {
            return Block.byId[n4].d();
        }
        return -1;
    }

    public boolean isLoaded(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= 256) {
            return false;
        }
        return this.isChunkLoaded(n >> 4, n3 >> 4);
    }

    public boolean areChunksLoaded(int n, int n2, int n3, int n4) {
        return this.e(n - n4, n2 - n4, n3 - n4, n + n4, n2 + n4, n3 + n4);
    }

    public boolean e(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= 256) {
            return false;
        }
        n3 >>= 4;
        n4 >>= 4;
        n6 >>= 4;
        for (int i = n >>= 4; i <= n4; ++i) {
            for (int j = n3; j <= n6; ++j) {
                if (this.isChunkLoaded(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isChunkLoaded(int n, int n2) {
        return this.chunkProvider.isChunkLoaded(n, n2);
    }

    public Chunk getChunkAtWorldCoords(int n, int n2) {
        return this.getChunkAt(n >> 4, n2 >> 4);
    }

    public Chunk getChunkAt(int n, int n2) {
        return this.chunkProvider.getOrCreateChunk(n, n2);
    }

    public boolean setTypeIdAndData(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        int n7 = 0;
        if ((n6 & 1) != 0) {
            n7 = chunk.getTypeId(n & 0xF, n2, n3 & 0xF);
        }
        boolean bl = chunk.a(n & 0xF, n2, n3 & 0xF, n4, n5);
        this.methodProfiler.a("checkLight");
        this.A(n, n2, n3);
        this.methodProfiler.b();
        if (bl) {
            if (!((n6 & 2) == 0 || this.isStatic && (n6 & 4) != 0)) {
                this.notify(n, n2, n3);
            }
            if (!this.isStatic && (n6 & 1) != 0) {
                this.update(n, n2, n3, n7);
                Block block = Block.byId[n4];
                if (block != null && block.q_()) {
                    this.m(n, n2, n3, n4);
                }
            }
        }
        return bl;
    }

    @Override
    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 == 0) {
            return Material.AIR;
        }
        return Block.byId[n4].material;
    }

    @Override
    public int getData(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.getData(n &= 0xF, n2, n3 &= 0xF);
    }

    public boolean setData(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl = chunk.b(n7 = n & 0xF, n2, n6 = n3 & 0xF, n4);
        if (bl) {
            int n8 = chunk.getTypeId(n7, n2, n6);
            if (!((n5 & 2) == 0 || this.isStatic && (n5 & 4) != 0)) {
                this.notify(n, n2, n3);
            }
            if (!this.isStatic && (n5 & 1) != 0) {
                this.update(n, n2, n3, n8);
                Block block = Block.byId[n8];
                if (block != null && block.q_()) {
                    this.m(n, n2, n3, n8);
                }
            }
        }
        return bl;
    }

    public boolean setAir(int n, int n2, int n3) {
        return this.setTypeIdAndData(n, n2, n3, 0, 0, 3);
    }

    public boolean setAir(int n, int n2, int n3, boolean bl) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 > 0) {
            int n5 = this.getData(n, n2, n3);
            this.triggerEffect(2001, n, n2, n3, n4 + (n5 << 12));
            if (bl) {
                Block.byId[n4].c(this, n, n2, n3, n5, 0);
            }
            return this.setTypeIdAndData(n, n2, n3, 0, 0, 3);
        }
        return false;
    }

    public boolean setTypeIdUpdate(int n, int n2, int n3, int n4) {
        return this.setTypeIdAndData(n, n2, n3, n4, 0, 3);
    }

    public void notify(int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3);
        }
    }

    public void update(int n, int n2, int n3, int n4) {
        this.applyPhysics(n, n2, n3, n4);
    }

    public void e(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        if (!this.worldProvider.g) {
            for (n5 = n3; n5 <= n4; ++n5) {
                this.c(EnumSkyBlock.SKY, n, n5, n2);
            }
        }
        this.g(n, n3, n2, n, n4, n2);
    }

    public void g(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3, n4, n5, n6);
        }
    }

    public void applyPhysics(int n, int n2, int n3, int n4) {
        this.g(n - 1, n2, n3, n4);
        this.g(n + 1, n2, n3, n4);
        this.g(n, n2 - 1, n3, n4);
        this.g(n, n2 + 1, n3, n4);
        this.g(n, n2, n3 - 1, n4);
        this.g(n, n2, n3 + 1, n4);
    }

    public void c(int n, int n2, int n3, int n4, int n5) {
        if (n5 != 4) {
            this.g(n - 1, n2, n3, n4);
        }
        if (n5 != 5) {
            this.g(n + 1, n2, n3, n4);
        }
        if (n5 != 0) {
            this.g(n, n2 - 1, n3, n4);
        }
        if (n5 != 1) {
            this.g(n, n2 + 1, n3, n4);
        }
        if (n5 != 2) {
            this.g(n, n2, n3 - 1, n4);
        }
        if (n5 != 3) {
            this.g(n, n2, n3 + 1, n4);
        }
    }

    public void g(int n, int n2, int n3, int n4) {
        if (this.isStatic) {
            return;
        }
        int n5 = this.getTypeId(n, n2, n3);
        Block block = Block.byId[n5];
        if (block != null) {
            try {
                block.doPhysics(this, n, n2, n3, n4);
            }
            catch (Throwable throwable) {
                int n6;
                CrashReport crashReport = CrashReport.a(throwable, "Exception while updating neighbours");
                CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Block being updated");
                try {
                    n6 = this.getData(n, n2, n3);
                }
                catch (Throwable throwable2) {
                    n6 = -1;
                }
                crashReportSystemDetails.a("Source block type", new CrashReportSourceBlockType(this, n4));
                CrashReportSystemDetails.a(crashReportSystemDetails, n, n2, n3, n5, n6);
                throw new ReportedException(crashReport);
            }
        }
    }

    public boolean a(int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean l(int n, int n2, int n3) {
        return this.getChunkAt(n >> 4, n3 >> 4).d(n & 0xF, n2, n3 & 0xF);
    }

    public int m(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF, 0);
    }

    public int getLightLevel(int n, int n2, int n3) {
        return this.b(n, n2, n3, true);
    }

    public int b(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 15;
        }
        if (bl && Block.x[n4 = this.getTypeId(n, n2, n3)]) {
            int n5 = this.b(n, n2 + 1, n3, false);
            int n6 = this.b(n + 1, n2, n3, false);
            int n7 = this.b(n - 1, n2, n3, false);
            int n8 = this.b(n, n2, n3 + 1, false);
            int n9 = this.b(n, n2, n3 - 1, false);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            return n5;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.c(n &= 0xF, n2, n3 &= 0xF, this.j);
    }

    public int getHighestBlockYAt(int n, int n2) {
        if (n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000) {
            return 0;
        }
        if (!this.isChunkLoaded(n >> 4, n2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n2 >> 4);
        return chunk.b(n & 0xF, n2 & 0xF);
    }

    public int g(int n, int n2) {
        if (n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000) {
            return 0;
        }
        if (!this.isChunkLoaded(n >> 4, n2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n2 >> 4);
        return chunk.p;
    }

    public int b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return enumSkyBlock.c;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        if (!this.isChunkLoaded(n4, n5)) {
            return enumSkyBlock.c;
        }
        Chunk chunk = this.getChunkAt(n4, n5);
        return chunk.getBrightness(enumSkyBlock, n & 0xF, n2, n3 & 0xF);
    }

    public void b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n2 >= 256) {
            return;
        }
        if (!this.isChunkLoaded(n >> 4, n3 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF, n4);
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).b(n, n2, n3);
        }
    }

    public void p(int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).b(n, n2, n3);
        }
    }

    public float q(int n, int n2, int n3) {
        return this.worldProvider.h[this.getLightLevel(n, n2, n3)];
    }

    public boolean v() {
        return this.j < 4;
    }

    public MovingObjectPosition a(Vec3D vec3D, Vec3D vec3D2) {
        return this.rayTrace(vec3D, vec3D2, false, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl) {
        return this.rayTrace(vec3D, vec3D2, bl, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl, boolean bl2) {
        MovingObjectPosition movingObjectPosition;
        if (Double.isNaN(vec3D.c) || Double.isNaN(vec3D.d) || Double.isNaN(vec3D.e)) {
            return null;
        }
        if (Double.isNaN(vec3D2.c) || Double.isNaN(vec3D2.d) || Double.isNaN(vec3D2.e)) {
            return null;
        }
        int n = MathHelper.floor(vec3D2.c);
        int n2 = MathHelper.floor(vec3D2.d);
        int n3 = MathHelper.floor(vec3D2.e);
        int n4 = MathHelper.floor(vec3D.c);
        int n5 = MathHelper.floor(vec3D.d);
        int n6 = MathHelper.floor(vec3D.e);
        int n7 = this.getTypeId(n4, n5, n6);
        int n8 = this.getData(n4, n5, n6);
        Block block = Block.byId[n7];
        if ((!bl2 || block == null || block.b(this, n4, n5, n6) != null) && n7 > 0 && block.a(n8, bl) && (movingObjectPosition = block.a(this, n4, n5, n6, vec3D, vec3D2)) != null) {
            return movingObjectPosition;
        }
        n7 = 200;
        while (n7-- >= 0) {
            MovingObjectPosition movingObjectPosition2;
            if (Double.isNaN(vec3D.c) || Double.isNaN(vec3D.d) || Double.isNaN(vec3D.e)) {
                return null;
            }
            if (n4 == n && n5 == n2 && n6 == n3) {
                return null;
            }
            n8 = 1;
            boolean bl3 = true;
            boolean bl4 = true;
            double d = 999.0;
            double d2 = 999.0;
            double d3 = 999.0;
            if (n > n4) {
                d = (double)n4 + 1.0;
            } else if (n < n4) {
                d = (double)n4 + 0.0;
            } else {
                n8 = 0;
            }
            if (n2 > n5) {
                d2 = (double)n5 + 1.0;
            } else if (n2 < n5) {
                d2 = (double)n5 + 0.0;
            } else {
                bl3 = false;
            }
            if (n3 > n6) {
                d3 = (double)n6 + 1.0;
            } else if (n3 < n6) {
                d3 = (double)n6 + 0.0;
            } else {
                bl4 = false;
            }
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = 999.0;
            double d7 = vec3D2.c - vec3D.c;
            double d8 = vec3D2.d - vec3D.d;
            double d9 = vec3D2.e - vec3D.e;
            if (n8 != 0) {
                d4 = (d - vec3D.c) / d7;
            }
            if (bl3) {
                d5 = (d2 - vec3D.d) / d8;
            }
            if (bl4) {
                d6 = (d3 - vec3D.e) / d9;
            }
            int n9 = 0;
            if (d4 < d5 && d4 < d6) {
                n9 = n > n4 ? 4 : 5;
                vec3D.c = d;
                vec3D.d += d8 * d4;
                vec3D.e += d9 * d4;
            } else if (d5 < d6) {
                n9 = n2 > n5 ? 0 : 1;
                vec3D.c += d7 * d5;
                vec3D.d = d2;
                vec3D.e += d9 * d5;
            } else {
                n9 = n3 > n6 ? 2 : 3;
                vec3D.c += d7 * d6;
                vec3D.d += d8 * d6;
                vec3D.e = d3;
            }
            Vec3D vec3D3 = this.getVec3DPool().create(vec3D.c, vec3D.d, vec3D.e);
            vec3D3.c = MathHelper.floor(vec3D.c);
            n4 = (int)vec3D3.c;
            if (n9 == 5) {
                --n4;
                vec3D3.c += 1.0;
            }
            vec3D3.d = MathHelper.floor(vec3D.d);
            n5 = (int)vec3D3.d;
            if (n9 == 1) {
                --n5;
                vec3D3.d += 1.0;
            }
            vec3D3.e = MathHelper.floor(vec3D.e);
            n6 = (int)vec3D3.e;
            if (n9 == 3) {
                --n6;
                vec3D3.e += 1.0;
            }
            int n10 = this.getTypeId(n4, n5, n6);
            int n11 = this.getData(n4, n5, n6);
            Block block2 = Block.byId[n10];
            if (bl2 && block2 != null && block2.b(this, n4, n5, n6) == null || n10 <= 0 || !block2.a(n11, bl) || (movingObjectPosition2 = block2.a(this, n4, n5, n6, vec3D, vec3D2)) == null) continue;
            return movingObjectPosition2;
        }
        return null;
    }

    public void makeSound(Entity entity, String string, float f, float f2) {
        if (entity == null || string == null) {
            return;
        }
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, entity.locX, entity.locY - (double)entity.height, entity.locZ, f, f2);
        }
    }

    public void a(EntityHuman entityHuman, String string, float f, float f2) {
        if (entityHuman == null || string == null) {
            return;
        }
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(entityHuman, string, entityHuman.locX, entityHuman.locY - (double)entityHuman.height, entityHuman.locZ, f, f2);
        }
    }

    public void makeSound(double d, double d2, double d3, String string, float f, float f2) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, d, d2, d3, f, f2);
        }
    }

    public void a(double d, double d2, double d3, String string, float f, float f2, boolean bl) {
    }

    public void a(String string, int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, n, n2, n3);
        }
    }

    public void addParticle(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean strikeLightning(Entity entity) {
        this.i.add(entity);
        return true;
    }

    public boolean addEntity(Entity entity) {
        int n = MathHelper.floor(entity.locX / 16.0);
        int n2 = MathHelper.floor(entity.locZ / 16.0);
        boolean bl = entity.p;
        if (entity instanceof EntityHuman) {
            bl = true;
        }
        if (bl || this.isChunkLoaded(n, n2)) {
            if (entity instanceof EntityHuman) {
                EntityHuman entityHuman = (EntityHuman)entity;
                this.players.add(entityHuman);
                this.everyoneSleeping();
            }
            this.getChunkAt(n, n2).a(entity);
            this.entityList.add(entity);
            this.a(entity);
            return true;
        }
        return false;
    }

    protected void a(Entity entity) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(entity);
        }
    }

    protected void b(Entity entity) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).b(entity);
        }
    }

    public void kill(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.mount(null);
        }
        if (entity.vehicle != null) {
            entity.mount(null);
        }
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove(entity);
            this.everyoneSleeping();
        }
    }

    public void removeEntity(Entity entity) {
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove(entity);
            this.everyoneSleeping();
        }
        int n = entity.aj;
        int n2 = entity.al;
        if (entity.ai && this.isChunkLoaded(n, n2)) {
            this.getChunkAt(n, n2).b(entity);
        }
        this.entityList.remove(entity);
        this.b(entity);
    }

    public void addIWorldAccess(IWorldAccess iWorldAccess) {
        this.u.add(iWorldAccess);
    }

    public List getCubes(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.M.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.M, entity);
                }
            }
        }
        double d = 0.25;
        List list = this.getEntities(entity, axisAlignedBB.grow(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB2 = ((Entity)list.get(i)).E();
            if (axisAlignedBB2 != null && axisAlignedBB2.b(axisAlignedBB)) {
                this.M.add(axisAlignedBB2);
            }
            if ((axisAlignedBB2 = entity.g((Entity)list.get(i))) == null || !axisAlignedBB2.b(axisAlignedBB)) continue;
            this.M.add(axisAlignedBB2);
        }
        return this.M;
    }

    public List a(AxisAlignedBB axisAlignedBB) {
        this.M.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.M, null);
                }
            }
        }
        return this.M;
    }

    public int a(float f) {
        float f2 = this.c(f);
        float f3 = 1.0f - (MathHelper.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.0f - f3;
        f3 = (float)((double)f3 * (1.0 - (double)(this.i(f) * 5.0f) / 16.0));
        f3 = (float)((double)f3 * (1.0 - (double)(this.h(f) * 5.0f) / 16.0));
        f3 = 1.0f - f3;
        return (int)(f3 * 11.0f);
    }

    public float c(float f) {
        return this.worldProvider.a(this.worldData.getDayTime(), f);
    }

    public float x() {
        return WorldProvider.a[this.worldProvider.a(this.worldData.getDayTime())];
    }

    public float d(float f) {
        float f2 = this.c(f);
        return f2 * (float)Math.PI * 2.0f;
    }

    public int h(int n, int n2) {
        return this.getChunkAtWorldCoords(n, n2).d(n & 0xF, n2 & 0xF);
    }

    public int i(int n, int n2) {
        Chunk chunk = this.getChunkAtWorldCoords(n, n2);
        n &= 0xF;
        n2 &= 0xF;
        for (int i = chunk.h() + 15; i > 0; --i) {
            int n3 = chunk.getTypeId(n, i, n2);
            if (n3 == 0 || !Block.byId[n3].material.isSolid() || Block.byId[n3].material == Material.LEAVES) {
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    public void a(int n, int n2, int n3, int n4, int n5) {
    }

    public void a(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void b(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void tickEntities() {
        int n;
        int n2;
        Object object;
        int n3;
        this.methodProfiler.a("entities");
        this.methodProfiler.a("global");
        for (n3 = 0; n3 < this.i.size(); ++n3) {
            object = (Entity)this.i.get(n3);
            try {
                ++((Entity)object).ticksLived;
                ((Entity)object).l_();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.a(throwable, "Ticking entity");
                CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Entity being ticked");
                if (object == null) {
                    crashReportSystemDetails.a("Entity", "~~NULL~~");
                } else {
                    ((Entity)object).a(crashReportSystemDetails);
                }
                throw new ReportedException(crashReport);
            }
            if (!((Entity)object).dead) continue;
            this.i.remove(n3--);
        }
        this.methodProfiler.c("remove");
        this.entityList.removeAll(this.f);
        for (n3 = 0; n3 < this.f.size(); ++n3) {
            object = (Entity)this.f.get(n3);
            n2 = ((Entity)object).aj;
            n = ((Entity)object).al;
            if (!((Entity)object).ai || !this.isChunkLoaded(n2, n)) continue;
            this.getChunkAt(n2, n).b((Entity)object);
        }
        for (n3 = 0; n3 < this.f.size(); ++n3) {
            this.b((Entity)this.f.get(n3));
        }
        this.f.clear();
        this.methodProfiler.c("regular");
        for (n3 = 0; n3 < this.entityList.size(); ++n3) {
            object = (Entity)this.entityList.get(n3);
            if (((Entity)object).vehicle != null) {
                if (!((Entity)object).vehicle.dead && ((Entity)object).vehicle.passenger == object) continue;
                ((Entity)object).vehicle.passenger = null;
                ((Entity)object).vehicle = null;
            }
            this.methodProfiler.a("tick");
            if (!((Entity)object).dead) {
                try {
                    this.playerJoinedWorld((Entity)object);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.a(throwable, "Ticking entity");
                    CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Entity being ticked");
                    ((Entity)object).a(crashReportSystemDetails);
                    throw new ReportedException(crashReport);
                }
            }
            this.methodProfiler.b();
            this.methodProfiler.a("remove");
            if (((Entity)object).dead) {
                n2 = ((Entity)object).aj;
                n = ((Entity)object).al;
                if (((Entity)object).ai && this.isChunkLoaded(n2, n)) {
                    this.getChunkAt(n2, n).b((Entity)object);
                }
                this.entityList.remove(n3--);
                this.b((Entity)object);
            }
            this.methodProfiler.b();
        }
        this.methodProfiler.c("tileEntities");
        this.N = true;
        Iterator iterator = this.tileEntityList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            object = (TileEntity)iterator.next();
            if (!((TileEntity)object).r() && ((TileEntity)object).o() && this.isLoaded(((TileEntity)object).x, ((TileEntity)object).y, ((TileEntity)object).z)) {
                try {
                    ((TileEntity)object).h();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.a(throwable, "Ticking tile entity");
                    CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Tile entity being ticked");
                    ((TileEntity)object).a(crashReportSystemDetails);
                    throw new ReportedException(crashReport);
                }
            }
            if (!((TileEntity)object).r()) continue;
            iterator.remove();
            if (!this.isChunkLoaded(((TileEntity)object).x >> 4, ((TileEntity)object).z >> 4) || (chunk = this.getChunkAt(((TileEntity)object).x >> 4, ((TileEntity)object).z >> 4)) == null) continue;
            chunk.f(((TileEntity)object).x & 0xF, ((TileEntity)object).y, ((TileEntity)object).z & 0xF);
        }
        this.N = false;
        if (!this.b.isEmpty()) {
            this.tileEntityList.removeAll(this.b);
            this.b.clear();
        }
        this.methodProfiler.c("pendingTileEntities");
        if (!this.a.isEmpty()) {
            for (int i = 0; i < this.a.size(); ++i) {
                Chunk chunk;
                TileEntity tileEntity = (TileEntity)this.a.get(i);
                if (tileEntity.r()) continue;
                if (!this.tileEntityList.contains(tileEntity)) {
                    this.tileEntityList.add(tileEntity);
                }
                if (this.isChunkLoaded(tileEntity.x >> 4, tileEntity.z >> 4) && (chunk = this.getChunkAt(tileEntity.x >> 4, tileEntity.z >> 4)) != null) {
                    chunk.a(tileEntity.x & 0xF, tileEntity.y, tileEntity.z & 0xF, tileEntity);
                }
                this.notify(tileEntity.x, tileEntity.y, tileEntity.z);
            }
            this.a.clear();
        }
        this.methodProfiler.b();
        this.methodProfiler.b();
    }

    public void a(Collection collection) {
        if (this.N) {
            this.a.addAll(collection);
        } else {
            this.tileEntityList.addAll(collection);
        }
    }

    public void playerJoinedWorld(Entity entity) {
        this.entityJoinedWorld(entity, true);
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locZ);
        int n3 = 32;
        if (bl && !this.e(n - n3, 0, n2 - n3, n + n3, 0, n2 + n3)) {
            return;
        }
        entity.U = entity.locX;
        entity.V = entity.locY;
        entity.W = entity.locZ;
        entity.lastYaw = entity.yaw;
        entity.lastPitch = entity.pitch;
        if (bl && entity.ai) {
            ++entity.ticksLived;
            if (entity.vehicle != null) {
                entity.V();
            } else {
                entity.l_();
            }
        }
        this.methodProfiler.a("chunkCheck");
        if (Double.isNaN(entity.locX) || Double.isInfinite(entity.locX)) {
            entity.locX = entity.U;
        }
        if (Double.isNaN(entity.locY) || Double.isInfinite(entity.locY)) {
            entity.locY = entity.V;
        }
        if (Double.isNaN(entity.locZ) || Double.isInfinite(entity.locZ)) {
            entity.locZ = entity.W;
        }
        if (Double.isNaN(entity.pitch) || Double.isInfinite(entity.pitch)) {
            entity.pitch = entity.lastPitch;
        }
        if (Double.isNaN(entity.yaw) || Double.isInfinite(entity.yaw)) {
            entity.yaw = entity.lastYaw;
        }
        int n4 = MathHelper.floor(entity.locX / 16.0);
        int n5 = MathHelper.floor(entity.locY / 16.0);
        int n6 = MathHelper.floor(entity.locZ / 16.0);
        if (!entity.ai || entity.aj != n4 || entity.ak != n5 || entity.al != n6) {
            if (entity.ai && this.isChunkLoaded(entity.aj, entity.al)) {
                this.getChunkAt(entity.aj, entity.al).a(entity, entity.ak);
            }
            if (this.isChunkLoaded(n4, n6)) {
                entity.ai = true;
                this.getChunkAt(n4, n6).a(entity);
            } else {
                entity.ai = false;
            }
        }
        this.methodProfiler.b();
        if (bl && entity.ai && entity.passenger != null) {
            if (entity.passenger.dead || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.playerJoinedWorld(entity.passenger);
            }
        }
    }

    public boolean b(AxisAlignedBB axisAlignedBB) {
        return this.a(axisAlignedBB, (Entity)null);
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Entity entity) {
        List list = this.getEntities(null, axisAlignedBB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity2 = (Entity)list.get(i);
            if (entity2.dead || !entity2.m || entity2 == entity) continue;
            return false;
        }
        return true;
    }

    public boolean c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || !block.material.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean e(AxisAlignedBB axisAlignedBB) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (this.e(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.getTypeId(i, j, k);
                        if (n7 != Block.FIRE.id && n7 != Block.LAVA.id && n7 != Block.STATIONARY_LAVA.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material, Entity entity) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (!this.e(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3D vec3D = this.getVec3DPool().create(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material || !((double)n5 >= (d = (double)((float)(j + 1) - BlockFluids.d(this.getData(i, j, k)))))) continue;
                    bl = true;
                    block.a(this, i, j, k, entity, vec3D);
                }
            }
        }
        if (vec3D.b() > 0.0 && entity.ax()) {
            vec3D = vec3D.a();
            double d = 0.014;
            entity.motX += vec3D.c * d;
            entity.motY += vec3D.d * d;
            entity.motZ += vec3D.e * d;
        }
        return bl;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    int n7 = this.getData(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= axisAlignedBB.b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion explode(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        return this.createExplosion(entity, d, d2, d3, f, false, bl);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl, boolean bl2) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.b = bl2;
        explosion.a();
        explosion.a(true);
        return explosion;
    }

    public float a(Vec3D vec3D, AxisAlignedBB axisAlignedBB) {
        double d = 1.0 / ((axisAlignedBB.d - axisAlignedBB.a) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisAlignedBB.e - axisAlignedBB.b) * 2.0 + 1.0);
        double d3 = 1.0 / ((axisAlignedBB.f - axisAlignedBB.c) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = axisAlignedBB.a + (axisAlignedBB.d - axisAlignedBB.a) * (double)f;
                    double d5 = axisAlignedBB.b + (axisAlignedBB.e - axisAlignedBB.b) * (double)f2;
                    double d6 = axisAlignedBB.c + (axisAlignedBB.f - axisAlignedBB.c) * (double)f3;
                    if (this.a(this.getVec3DPool().create(d4, d5, d6), vec3D) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public boolean douseFire(EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (this.getTypeId(n, n2, n3) == Block.FIRE.id) {
            this.a(entityHuman, 1004, n, n2, n3, 0);
            this.setAir(n, n2, n3);
            return true;
        }
        return false;
    }

    @Override
    public TileEntity getTileEntity(int n, int n2, int n3) {
        Chunk chunk;
        TileEntity tileEntity;
        int n4;
        if (n2 < 0 || n2 >= 256) {
            return null;
        }
        TileEntity tileEntity2 = null;
        if (this.N) {
            for (n4 = 0; n4 < this.a.size(); ++n4) {
                tileEntity = (TileEntity)this.a.get(n4);
                if (tileEntity.r() || tileEntity.x != n || tileEntity.y != n2 || tileEntity.z != n3) continue;
                tileEntity2 = tileEntity;
                break;
            }
        }
        if (tileEntity2 == null && (chunk = this.getChunkAt(n >> 4, n3 >> 4)) != null) {
            tileEntity2 = chunk.e(n & 0xF, n2, n3 & 0xF);
        }
        if (tileEntity2 == null) {
            for (n4 = 0; n4 < this.a.size(); ++n4) {
                tileEntity = (TileEntity)this.a.get(n4);
                if (tileEntity.r() || tileEntity.x != n || tileEntity.y != n2 || tileEntity.z != n3) continue;
                tileEntity2 = tileEntity;
                break;
            }
        }
        return tileEntity2;
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        if (tileEntity != null && !tileEntity.r()) {
            if (this.N) {
                tileEntity.x = n;
                tileEntity.y = n2;
                tileEntity.z = n3;
                Iterator iterator = this.a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileEntity2 = (TileEntity)iterator.next();
                    if (tileEntity2.x != n || tileEntity2.y != n2 || tileEntity2.z != n3) continue;
                    tileEntity2.w_();
                    iterator.remove();
                }
                this.a.add(tileEntity);
            } else {
                this.tileEntityList.add(tileEntity);
                Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
                if (chunk != null) {
                    chunk.a(n & 0xF, n2, n3 & 0xF, tileEntity);
                }
            }
        }
    }

    public void s(int n, int n2, int n3) {
        TileEntity tileEntity = this.getTileEntity(n, n2, n3);
        if (tileEntity != null && this.N) {
            tileEntity.w_();
            this.a.remove(tileEntity);
        } else {
            Chunk chunk;
            if (tileEntity != null) {
                this.a.remove(tileEntity);
                this.tileEntityList.remove(tileEntity);
            }
            if ((chunk = this.getChunkAt(n >> 4, n3 >> 4)) != null) {
                chunk.f(n & 0xF, n2, n3 & 0xF);
            }
        }
    }

    public void a(TileEntity tileEntity) {
        this.b.add(tileEntity);
    }

    public boolean t(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.c();
    }

    @Override
    public boolean u(int n, int n2, int n3) {
        return Block.l(this.getTypeId(n, n2, n3));
    }

    public boolean v(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 == 0 || Block.byId[n4] == null) {
            return false;
        }
        AxisAlignedBB axisAlignedBB = Block.byId[n4].b(this, n, n2, n3);
        return axisAlignedBB != null && axisAlignedBB.b() >= 1.0;
    }

    public boolean w(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        return this.a(block, this.getData(n, n2, n3));
    }

    public boolean a(Block block, int n) {
        if (block == null) {
            return false;
        }
        if (block.material.k() && block.b()) {
            return true;
        }
        if (block instanceof BlockStairs) {
            return (n & 4) == 4;
        }
        if (block instanceof BlockStepAbstract) {
            return (n & 8) == 8;
        }
        if (block instanceof BlockHopper) {
            return true;
        }
        if (block instanceof BlockSnow) {
            return (n & 7) == 7;
        }
        return false;
    }

    public boolean c(int n, int n2, int n3, boolean bl) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return bl;
        }
        Chunk chunk = this.chunkProvider.getOrCreateChunk(n >> 4, n3 >> 4);
        if (chunk == null || chunk.isEmpty()) {
            return bl;
        }
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.material.k() && block.b();
    }

    public void A() {
        int n = this.a(1.0f);
        if (n != this.j) {
            this.j = n;
        }
    }

    public void setSpawnFlags(boolean bl, boolean bl2) {
        this.allowMonsters = bl;
        this.allowAnimals = bl2;
    }

    public void doTick() {
        this.o();
    }

    private void a() {
        if (this.worldData.hasStorm()) {
            this.n = 1.0f;
            if (this.worldData.isThundering()) {
                this.p = 1.0f;
            }
        }
    }

    protected void o() {
        if (this.worldProvider.g) {
            return;
        }
        int n = this.worldData.getThunderDuration();
        if (n <= 0) {
            if (this.worldData.isThundering()) {
                this.worldData.setThunderDuration(this.random.nextInt(12000) + 3600);
            } else {
                this.worldData.setThunderDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setThunderDuration(--n);
            if (n <= 0) {
                this.worldData.setThundering(!this.worldData.isThundering());
            }
        }
        int n2 = this.worldData.getWeatherDuration();
        if (n2 <= 0) {
            if (this.worldData.hasStorm()) {
                this.worldData.setWeatherDuration(this.random.nextInt(12000) + 12000);
            } else {
                this.worldData.setWeatherDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setWeatherDuration(--n2);
            if (n2 <= 0) {
                this.worldData.setStorm(!this.worldData.hasStorm());
            }
        }
        this.m = this.n;
        this.n = this.worldData.hasStorm() ? (float)((double)this.n + 0.01) : (float)((double)this.n - 0.01);
        if (this.n < 0.0f) {
            this.n = 0.0f;
        }
        if (this.n > 1.0f) {
            this.n = 1.0f;
        }
        this.o = this.p;
        this.p = this.worldData.isThundering() ? (float)((double)this.p + 0.01) : (float)((double)this.p - 0.01);
        if (this.p < 0.0f) {
            this.p = 0.0f;
        }
        if (this.p > 1.0f) {
            this.p = 1.0f;
        }
    }

    public void B() {
        this.worldData.setWeatherDuration(1);
    }

    protected void C() {
        int n;
        int n2;
        int n3;
        EntityHuman entityHuman;
        int n4;
        this.chunkTickList.clear();
        this.methodProfiler.a("buildList");
        for (n4 = 0; n4 < this.players.size(); ++n4) {
            entityHuman = (EntityHuman)this.players.get(n4);
            n3 = MathHelper.floor(entityHuman.locX / 16.0);
            n2 = MathHelper.floor(entityHuman.locZ / 16.0);
            n = 7;
            for (int i = -n; i <= n; ++i) {
                for (int j = -n; j <= n; ++j) {
                    this.chunkTickList.add(new ChunkCoordIntPair(i + n3, j + n2));
                }
            }
        }
        this.methodProfiler.b();
        if (this.O > 0) {
            --this.O;
        }
        this.methodProfiler.a("playerCheckLight");
        if (!this.players.isEmpty()) {
            n4 = this.random.nextInt(this.players.size());
            entityHuman = (EntityHuman)this.players.get(n4);
            n3 = MathHelper.floor(entityHuman.locX) + this.random.nextInt(11) - 5;
            n2 = MathHelper.floor(entityHuman.locY) + this.random.nextInt(11) - 5;
            n = MathHelper.floor(entityHuman.locZ) + this.random.nextInt(11) - 5;
            this.A(n3, n2, n);
        }
        this.methodProfiler.b();
    }

    protected void a(int n, int n2, Chunk chunk) {
        this.methodProfiler.c("moodSound");
        if (this.O == 0 && !this.isStatic) {
            EntityHuman entityHuman;
            this.k = this.k * 3 + 1013904223;
            int n3 = this.k >> 2;
            int n4 = n3 & 0xF;
            int n5 = n3 >> 8 & 0xF;
            int n6 = n3 >> 16 & 0x7F;
            int n7 = chunk.getTypeId(n4, n6, n5);
            if (n7 == 0 && this.m(n4 += n, n6, n5 += n2) <= this.random.nextInt(8) && this.b(EnumSkyBlock.SKY, n4, n6, n5) <= 0 && (entityHuman = this.findNearbyPlayer((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5, 8.0)) != null && entityHuman.e((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5) > 4.0) {
                this.makeSound((double)n4 + 0.5, (double)n6 + 0.5, (double)n5 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.random.nextFloat() * 0.2f);
                this.O = this.random.nextInt(12000) + 6000;
            }
        }
        this.methodProfiler.c("checkLight");
        chunk.o();
    }

    protected void g() {
        this.C();
    }

    public boolean x(int n, int n2, int n3) {
        return this.d(n, n2, n3, false);
    }

    public boolean y(int n, int n2, int n3) {
        return this.d(n, n2, n3, true);
    }

    public boolean d(int n, int n2, int n3, boolean bl) {
        int n4;
        BiomeBase biomeBase = this.getBiome(n, n3);
        float f = biomeBase.j();
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < 256 && this.b(EnumSkyBlock.BLOCK, n, n2, n3) < 10 && ((n4 = this.getTypeId(n, n2, n3)) == Block.STATIONARY_WATER.id || n4 == Block.WATER.id) && this.getData(n, n2, n3) == 0) {
            if (!bl) {
                return true;
            }
            boolean bl2 = true;
            if (bl2 && this.getMaterial(n - 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n + 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 - 1) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 + 1) != Material.WATER) {
                bl2 = false;
            }
            if (!bl2) {
                return true;
            }
        }
        return false;
    }

    public boolean z(int n, int n2, int n3) {
        BiomeBase biomeBase = this.getBiome(n, n3);
        float f = biomeBase.j();
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < 256 && this.b(EnumSkyBlock.BLOCK, n, n2, n3) < 10) {
            int n4 = this.getTypeId(n, n2 - 1, n3);
            int n5 = this.getTypeId(n, n2, n3);
            if (n5 == 0 && Block.SNOW.canPlace(this, n, n2, n3) && n4 != 0 && n4 != Block.ICE.id && Block.byId[n4].material.isSolid()) {
                return true;
            }
        }
        return false;
    }

    public void A(int n, int n2, int n3) {
        if (!this.worldProvider.g) {
            this.c(EnumSkyBlock.SKY, n, n2, n3);
        }
        this.c(EnumSkyBlock.BLOCK, n, n2, n3);
    }

    private int a(int n, int n2, int n3, EnumSkyBlock enumSkyBlock) {
        if (enumSkyBlock == EnumSkyBlock.SKY && this.l(n, n2, n3)) {
            return 15;
        }
        int n4 = this.getTypeId(n, n2, n3);
        int n5 = enumSkyBlock == EnumSkyBlock.SKY ? 0 : Block.lightEmission[n4];
        int n6 = Block.lightBlock[n4];
        if (n6 >= 15 && Block.lightEmission[n4] > 0) {
            n6 = 1;
        }
        if (n6 < 1) {
            n6 = 1;
        }
        if (n6 >= 15) {
            return 0;
        }
        if (n5 >= 14) {
            return n5;
        }
        for (int i = 0; i < 6; ++i) {
            int n7 = n + Facing.b[i];
            int n8 = n2 + Facing.c[i];
            int n9 = n3 + Facing.d[i];
            int n10 = this.b(enumSkyBlock, n7, n8, n9) - n6;
            if (n10 > n5) {
                n5 = n10;
            }
            if (n5 < 14) continue;
            return n5;
        }
        return n5;
    }

    public void c(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (!this.areChunksLoaded(n, n2, n3, 17)) {
            return;
        }
        int n14 = 0;
        int n15 = 0;
        this.methodProfiler.a("getBrightness");
        int n16 = this.b(enumSkyBlock, n, n2, n3);
        int n17 = this.a(n, n2, n3, enumSkyBlock);
        if (n17 > n16) {
            this.H[n15++] = 133152;
        } else if (n17 < n16) {
            this.H[n15++] = 0x20820 | n16 << 18;
            while (n14 < n15) {
                n13 = this.H[n14++];
                n12 = (n13 & 0x3F) - 32 + n;
                n11 = (n13 >> 6 & 0x3F) - 32 + n2;
                n10 = (n13 >> 12 & 0x3F) - 32 + n3;
                n9 = n13 >> 18 & 0xF;
                n8 = this.b(enumSkyBlock, n12, n11, n10);
                if (n8 != n9) continue;
                this.b(enumSkyBlock, n12, n11, n10, 0);
                if (n9 <= 0 || (n7 = MathHelper.a(n12 - n)) + (n6 = MathHelper.a(n11 - n2)) + (n5 = MathHelper.a(n10 - n3)) >= 17) continue;
                for (n4 = 0; n4 < 6; ++n4) {
                    int n18 = n12 + Facing.b[n4];
                    int n19 = n11 + Facing.c[n4];
                    int n20 = n10 + Facing.d[n4];
                    int n21 = Math.max(1, Block.lightBlock[this.getTypeId(n18, n19, n20)]);
                    n8 = this.b(enumSkyBlock, n18, n19, n20);
                    if (n8 != n9 - n21 || n15 >= this.H.length) continue;
                    this.H[n15++] = n18 - n + 32 | n19 - n2 + 32 << 6 | n20 - n3 + 32 << 12 | n9 - n21 << 18;
                }
            }
            n14 = 0;
        }
        this.methodProfiler.b();
        this.methodProfiler.a("checkedPosition < toCheckCount");
        while (n14 < n15) {
            n13 = this.H[n14++];
            n12 = (n13 & 0x3F) - 32 + n;
            n11 = (n13 >> 6 & 0x3F) - 32 + n2;
            n10 = (n13 >> 12 & 0x3F) - 32 + n3;
            n9 = this.b(enumSkyBlock, n12, n11, n10);
            n8 = this.a(n12, n11, n10, enumSkyBlock);
            if (n8 == n9) continue;
            this.b(enumSkyBlock, n12, n11, n10, n8);
            if (n8 <= n9) continue;
            n7 = Math.abs(n12 - n);
            n6 = Math.abs(n11 - n2);
            n5 = Math.abs(n10 - n3);
            int n22 = n4 = n15 < this.H.length - 6 ? 1 : 0;
            if (n7 + n6 + n5 >= 17 || n4 == 0) continue;
            if (this.b(enumSkyBlock, n12 - 1, n11, n10) < n8) {
                this.H[n15++] = n12 - 1 - n + 32 + (n11 - n2 + 32 << 6) + (n10 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n12 + 1, n11, n10) < n8) {
                this.H[n15++] = n12 + 1 - n + 32 + (n11 - n2 + 32 << 6) + (n10 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n12, n11 - 1, n10) < n8) {
                this.H[n15++] = n12 - n + 32 + (n11 - 1 - n2 + 32 << 6) + (n10 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n12, n11 + 1, n10) < n8) {
                this.H[n15++] = n12 - n + 32 + (n11 + 1 - n2 + 32 << 6) + (n10 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n12, n11, n10 - 1) < n8) {
                this.H[n15++] = n12 - n + 32 + (n11 - n2 + 32 << 6) + (n10 - 1 - n3 + 32 << 12);
            }
            if (this.b(enumSkyBlock, n12, n11, n10 + 1) >= n8) continue;
            this.H[n15++] = n12 - n + 32 + (n11 - n2 + 32 << 6) + (n10 + 1 - n3 + 32 << 12);
        }
        this.methodProfiler.b();
    }

    public boolean a(boolean bl) {
        return false;
    }

    public List a(Chunk chunk, boolean bl) {
        return null;
    }

    public List getEntities(Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.getEntities(entity, axisAlignedBB, null);
    }

    public List getEntities(Entity entity, AxisAlignedBB axisAlignedBB, IEntitySelector iEntitySelector) {
        ArrayList arrayList = new ArrayList();
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(entity, axisAlignedBB, arrayList, iEntitySelector);
            }
        }
        return arrayList;
    }

    public List a(Class clazz, AxisAlignedBB axisAlignedBB) {
        return this.a(clazz, axisAlignedBB, (IEntitySelector)null);
    }

    public List a(Class clazz, AxisAlignedBB axisAlignedBB, IEntitySelector iEntitySelector) {
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(clazz, axisAlignedBB, arrayList, iEntitySelector);
            }
        }
        return arrayList;
    }

    public Entity a(Class clazz, AxisAlignedBB axisAlignedBB, Entity entity) {
        List list = this.a(clazz, axisAlignedBB);
        Entity entity2 = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            Entity entity3 = (Entity)list.get(i);
            if (entity3 == entity || (d2 = entity.e(entity3)) > d) continue;
            entity2 = entity3;
            d = d2;
        }
        return entity2;
    }

    public abstract Entity getEntity(int var1);

    public void b(int n, int n2, int n3, TileEntity tileEntity) {
        if (this.isLoaded(n, n2, n3)) {
            this.getChunkAtWorldCoords(n, n3).e();
        }
    }

    public int a(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.entityList.size(); ++i) {
            Entity entity = (Entity)this.entityList.get(i);
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).isPersistent() || !clazz.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void a(List list) {
        this.entityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.a((Entity)list.get(i));
        }
    }

    public void b(List list) {
        this.f.addAll(list);
    }

    public boolean mayPlace(int n, int n2, int n3, int n4, boolean bl, int n5, Entity entity, ItemStack itemStack) {
        int n6 = this.getTypeId(n2, n3, n4);
        Block block = Block.byId[n6];
        Block block2 = Block.byId[n];
        AxisAlignedBB axisAlignedBB = block2.b(this, n2, n3, n4);
        if (bl) {
            axisAlignedBB = null;
        }
        if (axisAlignedBB != null && !this.a(axisAlignedBB, entity)) {
            return false;
        }
        if (block != null && (block == Block.WATER || block == Block.STATIONARY_WATER || block == Block.LAVA || block == Block.STATIONARY_LAVA || block == Block.FIRE || block.material.isReplaceable())) {
            block = null;
        }
        if (block != null && block.material == Material.ORIENTABLE && block2 == Block.ANVIL) {
            return true;
        }
        return n > 0 && block == null && block2.canPlace(this, n2, n3, n4, n5, itemStack);
    }

    public PathEntity findPath(Entity entity, Entity entity2, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.methodProfiler.a("pathfind");
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locY + 1.0);
        int n3 = MathHelper.floor(entity.locZ);
        int n4 = (int)(f + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10, 0);
        PathEntity pathEntity = new Pathfinder(chunkCache, bl, bl2, bl3, bl4).a(entity, entity2, f);
        this.methodProfiler.b();
        return pathEntity;
    }

    public PathEntity a(Entity entity, int n, int n2, int n3, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.methodProfiler.a("pathfind");
        int n4 = MathHelper.floor(entity.locX);
        int n5 = MathHelper.floor(entity.locY);
        int n6 = MathHelper.floor(entity.locZ);
        int n7 = (int)(f + 8.0f);
        int n8 = n4 - n7;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        int n11 = n4 + n7;
        int n12 = n5 + n7;
        int n13 = n6 + n7;
        ChunkCache chunkCache = new ChunkCache(this, n8, n9, n10, n11, n12, n13, 0);
        PathEntity pathEntity = new Pathfinder(chunkCache, bl, bl2, bl3, bl4).a(entity, n, n2, n3, f);
        this.methodProfiler.b();
        return pathEntity;
    }

    @Override
    public int getBlockPower(int n, int n2, int n3, int n4) {
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return 0;
        }
        return Block.byId[n5].c(this, n, n2, n3, n4);
    }

    public int getBlockPower(int n, int n2, int n3) {
        int n4 = 0;
        if ((n4 = Math.max(n4, this.getBlockPower(n, n2 - 1, n3, 0))) >= 15) {
            return n4;
        }
        if ((n4 = Math.max(n4, this.getBlockPower(n, n2 + 1, n3, 1))) >= 15) {
            return n4;
        }
        if ((n4 = Math.max(n4, this.getBlockPower(n, n2, n3 - 1, 2))) >= 15) {
            return n4;
        }
        if ((n4 = Math.max(n4, this.getBlockPower(n, n2, n3 + 1, 3))) >= 15) {
            return n4;
        }
        if ((n4 = Math.max(n4, this.getBlockPower(n - 1, n2, n3, 4))) >= 15) {
            return n4;
        }
        if ((n4 = Math.max(n4, this.getBlockPower(n + 1, n2, n3, 5))) >= 15) {
            return n4;
        }
        return n4;
    }

    public boolean isBlockFacePowered(int n, int n2, int n3, int n4) {
        return this.getBlockFacePower(n, n2, n3, n4) > 0;
    }

    public int getBlockFacePower(int n, int n2, int n3, int n4) {
        if (this.u(n, n2, n3)) {
            return this.getBlockPower(n, n2, n3);
        }
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return 0;
        }
        return Block.byId[n5].b((IBlockAccess)this, n, n2, n3, n4);
    }

    public boolean isBlockIndirectlyPowered(int n, int n2, int n3) {
        if (this.getBlockFacePower(n, n2 - 1, n3, 0) > 0) {
            return true;
        }
        if (this.getBlockFacePower(n, n2 + 1, n3, 1) > 0) {
            return true;
        }
        if (this.getBlockFacePower(n, n2, n3 - 1, 2) > 0) {
            return true;
        }
        if (this.getBlockFacePower(n, n2, n3 + 1, 3) > 0) {
            return true;
        }
        if (this.getBlockFacePower(n - 1, n2, n3, 4) > 0) {
            return true;
        }
        return this.getBlockFacePower(n + 1, n2, n3, 5) > 0;
    }

    public int getHighestNeighborSignal(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < 6; ++i) {
            int n5 = this.getBlockFacePower(n + Facing.b[i], n2 + Facing.c[i], n3 + Facing.d[i], i);
            if (n5 >= 15) {
                return 15;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public EntityHuman findNearbyPlayer(Entity entity, double d) {
        return this.findNearbyPlayer(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman findNearbyPlayer(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            double d6 = entityHuman2.e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman findNearbyVulnerablePlayer(Entity entity, double d) {
        return this.findNearbyVulnerablePlayer(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman findNearbyVulnerablePlayer(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            if (entityHuman2.abilities.isInvulnerable || !entityHuman2.isAlive()) continue;
            double d6 = entityHuman2.e(d, d2, d3);
            double d7 = d4;
            if (entityHuman2.isSneaking()) {
                d7 *= (double)0.8f;
            }
            if (entityHuman2.isInvisible()) {
                float f = entityHuman2.bx();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d7 *= (double)(0.7f * f);
            }
            if (!(d4 < 0.0) && !(d6 < d7 * d7) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman a(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!string.equals(((EntityHuman)this.players.get(i)).getName())) continue;
            return (EntityHuman)this.players.get(i);
        }
        return null;
    }

    public void G() {
        this.dataManager.checkSession();
    }

    public long getSeed() {
        return this.worldData.getSeed();
    }

    public long getTime() {
        return this.worldData.getTime();
    }

    public long getDayTime() {
        return this.worldData.getDayTime();
    }

    public void setDayTime(long l) {
        this.worldData.setDayTime(l);
    }

    public ChunkCoordinates getSpawn() {
        return new ChunkCoordinates(this.worldData.c(), this.worldData.d(), this.worldData.e());
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        return true;
    }

    public void broadcastEntityEffect(Entity entity, byte by) {
    }

    public IChunkProvider L() {
        return this.chunkProvider;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 > 0) {
            Block.byId[n4].b(this, n, n2, n3, n5, n6);
        }
    }

    public IDataManager getDataManager() {
        return this.dataManager;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    public GameRules getGameRules() {
        return this.worldData.getGameRules();
    }

    public void everyoneSleeping() {
    }

    public float h(float f) {
        return (this.o + (this.p - this.o) * f) * this.i(f);
    }

    public float i(float f) {
        return this.m + (this.n - this.m) * f;
    }

    public boolean P() {
        return (double)this.h(1.0f) > 0.9;
    }

    public boolean Q() {
        return (double)this.i(1.0f) > 0.2;
    }

    public boolean isRainingAt(int n, int n2, int n3) {
        if (!this.Q()) {
            return false;
        }
        if (!this.l(n, n2, n3)) {
            return false;
        }
        if (this.h(n, n3) > n2) {
            return false;
        }
        BiomeBase biomeBase = this.getBiome(n, n3);
        if (biomeBase.c()) {
            return false;
        }
        return biomeBase.d();
    }

    public boolean G(int n, int n2, int n3) {
        BiomeBase biomeBase = this.getBiome(n, n3);
        return biomeBase.e();
    }

    public void a(String string, WorldMapBase worldMapBase) {
        this.worldMaps.a(string, worldMapBase);
    }

    public WorldMapBase a(Class clazz, String string) {
        return this.worldMaps.get(clazz, string);
    }

    public int b(String string) {
        return this.worldMaps.a(string);
    }

    public void d(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3, n4, n5);
        }
    }

    public void triggerEffect(int n, int n2, int n3, int n4, int n5) {
        this.a(null, n, n2, n3, n4, n5);
    }

    public void a(EntityHuman entityHuman, int n, int n2, int n3, int n4, int n5) {
        try {
            for (int i = 0; i < this.u.size(); ++i) {
                ((IWorldAccess)this.u.get(i)).a(entityHuman, n, n2, n3, n4, n5);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Playing level event");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Level event being played");
            crashReportSystemDetails.a("Block coordinates", CrashReportSystemDetails.a(n2, n3, n4));
            crashReportSystemDetails.a("Event source", entityHuman);
            crashReportSystemDetails.a("Event type", n);
            crashReportSystemDetails.a("Event data", n5);
            throw new ReportedException(crashReport);
        }
    }

    public int getHeight() {
        return 256;
    }

    public int S() {
        return this.worldProvider.g ? 128 : 256;
    }

    public IUpdatePlayerListBox a(EntityMinecartAbstract entityMinecartAbstract) {
        return null;
    }

    public Random H(int n, int n2, int n3) {
        long l = (long)n * 341873128712L + (long)n2 * 132897987541L + this.getWorldData().getSeed() + (long)n3;
        this.random.setSeed(l);
        return this.random;
    }

    public ChunkPosition b(String string, int n, int n2, int n3) {
        return this.L().findNearestMapFeature(this, string, n, n2, n3);
    }

    public CrashReportSystemDetails a(CrashReport crashReport) {
        CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Affected level", 1);
        crashReportSystemDetails.a("Level name", this.worldData == null ? "????" : this.worldData.getName());
        crashReportSystemDetails.a("All players", new CrashReportPlayers(this));
        crashReportSystemDetails.a("Chunk stats", new CrashReportChunkStats(this));
        try {
            this.worldData.a(crashReportSystemDetails);
        }
        catch (Throwable throwable) {
            crashReportSystemDetails.a("Level Data Unobtainable", throwable);
        }
        return crashReportSystemDetails;
    }

    public void f(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.u.size(); ++i) {
            IWorldAccess iWorldAccess = (IWorldAccess)this.u.get(i);
            iWorldAccess.b(n, n2, n3, n4, n5);
        }
    }

    @Override
    public Vec3DPool getVec3DPool() {
        return this.J;
    }

    public Calendar W() {
        if (this.getTime() % 600L == 0L) {
            this.K.setTimeInMillis(MinecraftServer.aq());
        }
        return this.K;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void m(int n, int n2, int n3, int n4) {
        for (int i = 0; i < 4; ++i) {
            int n5 = n + Direction.a[i];
            int n6 = n3 + Direction.b[i];
            int n7 = this.getTypeId(n5, n2, n6);
            if (n7 == 0) continue;
            Block block = Block.byId[n7];
            if (Block.REDSTONE_COMPARATOR_OFF.g(n7)) {
                block.doPhysics(this, n5, n2, n6, n4);
                continue;
            }
            if (!Block.l(n7)) continue;
            n7 = this.getTypeId(n5 += Direction.a[i], n2, n6 += Direction.b[i]);
            block = Block.byId[n7];
            if (!Block.REDSTONE_COMPARATOR_OFF.g(n7)) continue;
            block.doPhysics(this, n5, n2, n6, n4);
        }
    }

    public IConsoleLogManager getLogger() {
        return this.logAgent;
    }

    public float b(double d, double d2, double d3) {
        return this.I(MathHelper.floor(d), MathHelper.floor(d2), MathHelper.floor(d3));
    }

    public float I(int n, int n2, int n3) {
        boolean bl;
        float f = 0.0f;
        boolean bl2 = bl = this.difficulty == 3;
        if (this.isLoaded(n, n2, n3)) {
            float f2 = this.x();
            f += MathHelper.a((float)this.getChunkAtWorldCoords((int)n, (int)n3).q / 3600000.0f, 0.0f, 1.0f) * (bl ? 1.0f : 0.75f);
            f += f2 * 0.25f;
        }
        if (this.difficulty < 2) {
            f *= (float)this.difficulty / 2.0f;
        }
        return MathHelper.a(f, 0.0f, bl ? 1.5f : 1.0f);
    }
}

