/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.BlockDoor;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Village;
import net.minecraft.server.VillageDoor;
import net.minecraft.server.World;
import net.minecraft.server.WorldMapBase;

public class VillageCollection
extends WorldMapBase {
    private World world;
    private final List b = new ArrayList();
    private final List c = new ArrayList();
    private final List villages = new ArrayList();
    private int time;

    public VillageCollection(String string) {
        super(string);
    }

    public VillageCollection(World world) {
        super("villages");
        this.world = world;
        this.c();
    }

    public void a(World world) {
        this.world = world;
        for (Village village : this.villages) {
            village.a(world);
        }
    }

    public void a(int n, int n2, int n3) {
        if (this.b.size() > 64) {
            return;
        }
        if (!this.d(n, n2, n3)) {
            this.b.add(new ChunkCoordinates(n, n2, n3));
        }
    }

    public void tick() {
        ++this.time;
        for (Village village : this.villages) {
            village.tick(this.time);
        }
        this.e();
        this.f();
        this.g();
        if (this.time % 400 == 0) {
            this.c();
        }
    }

    private void e() {
        Iterator iterator = this.villages.iterator();
        while (iterator.hasNext()) {
            Village village = (Village)iterator.next();
            if (!village.isAbandoned()) continue;
            iterator.remove();
            this.c();
        }
    }

    public List getVillages() {
        return this.villages;
    }

    public Village getClosestVillage(int n, int n2, int n3, int n4) {
        Village village = null;
        float f = Float.MAX_VALUE;
        for (Village village2 : this.villages) {
            float f2;
            float f3 = village2.getCenter().e(n, n2, n3);
            if (f3 >= f || f3 > (f2 = (float)(n4 + village2.getSize())) * f2) continue;
            village = village2;
            f = f3;
        }
        return village;
    }

    private void f() {
        if (this.b.isEmpty()) {
            return;
        }
        this.a((ChunkCoordinates)this.b.remove(0));
    }

    private void g() {
        for (int i = 0; i < this.c.size(); ++i) {
            VillageDoor villageDoor = (VillageDoor)this.c.get(i);
            boolean bl = false;
            for (Village village : this.villages) {
                int n;
                int n2 = (int)village.getCenter().e(villageDoor.locX, villageDoor.locY, villageDoor.locZ);
                if (n2 > (n = 32 + village.getSize()) * n) continue;
                village.addDoor(villageDoor);
                bl = true;
                break;
            }
            if (bl) continue;
            Village village = new Village(this.world);
            village.addDoor(villageDoor);
            this.villages.add(village);
            this.c();
        }
        this.c.clear();
    }

    private void a(ChunkCoordinates chunkCoordinates) {
        int n = 16;
        int n2 = 4;
        int n3 = 16;
        for (int i = chunkCoordinates.x - n; i < chunkCoordinates.x + n; ++i) {
            for (int j = chunkCoordinates.y - n2; j < chunkCoordinates.y + n2; ++j) {
                for (int k = chunkCoordinates.z - n3; k < chunkCoordinates.z + n3; ++k) {
                    if (!this.e(i, j, k)) continue;
                    VillageDoor villageDoor = this.b(i, j, k);
                    if (villageDoor == null) {
                        this.c(i, j, k);
                        continue;
                    }
                    villageDoor.addedTime = this.time;
                }
            }
        }
    }

    private VillageDoor b(int n, int n2, int n3) {
        for (Object object : this.c) {
            if (((VillageDoor)object).locX != n || ((VillageDoor)object).locZ != n3 || Math.abs(((VillageDoor)object).locY - n2) > 1) continue;
            return object;
        }
        for (Object object : this.villages) {
            VillageDoor villageDoor = ((Village)object).e(n, n2, n3);
            if (villageDoor == null) continue;
            return villageDoor;
        }
        return null;
    }

    private void c(int n, int n2, int n3) {
        int n4 = ((BlockDoor)Block.WOODEN_DOOR).d(this.world, n, n2, n3);
        if (n4 == 0 || n4 == 2) {
            int n5;
            int n6 = 0;
            for (n5 = -5; n5 < 0; ++n5) {
                if (!this.world.l(n + n5, n2, n3)) continue;
                --n6;
            }
            for (n5 = 1; n5 <= 5; ++n5) {
                if (!this.world.l(n + n5, n2, n3)) continue;
                ++n6;
            }
            if (n6 != 0) {
                this.c.add(new VillageDoor(n, n2, n3, n6 > 0 ? -2 : 2, 0, this.time));
            }
        } else {
            int n7;
            int n8 = 0;
            for (n7 = -5; n7 < 0; ++n7) {
                if (!this.world.l(n, n2, n3 + n7)) continue;
                --n8;
            }
            for (n7 = 1; n7 <= 5; ++n7) {
                if (!this.world.l(n, n2, n3 + n7)) continue;
                ++n8;
            }
            if (n8 != 0) {
                this.c.add(new VillageDoor(n, n2, n3, 0, n8 > 0 ? -2 : 2, this.time));
            }
        }
    }

    private boolean d(int n, int n2, int n3) {
        for (ChunkCoordinates chunkCoordinates : this.b) {
            if (chunkCoordinates.x != n || chunkCoordinates.y != n2 || chunkCoordinates.z != n3) continue;
            return true;
        }
        return false;
    }

    private boolean e(int n, int n2, int n3) {
        int n4 = this.world.getTypeId(n, n2, n3);
        return n4 == Block.WOODEN_DOOR.id;
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.time = nBTTagCompound.getInt("Tick");
        NBTTagList nBTTagList = nBTTagCompound.getList("Villages");
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            Village village = new Village();
            village.a(nBTTagCompound2);
            this.villages.add(village);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setInt("Tick", this.time);
        NBTTagList nBTTagList = new NBTTagList("Villages");
        for (Village village : this.villages) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound("Village");
            village.b(nBTTagCompound2);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Villages", nBTTagList);
    }
}

