/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityIronGolem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityVillager;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Vec3D;
import net.minecraft.server.VillageAggressor;
import net.minecraft.server.VillageDoor;
import net.minecraft.server.World;

public class Village {
    private World world;
    private final List doors = new ArrayList();
    private final ChunkCoordinates c = new ChunkCoordinates(0, 0, 0);
    private final ChunkCoordinates center = new ChunkCoordinates(0, 0, 0);
    private int size;
    private int f;
    private int time;
    private int population;
    private int noBreedTicks;
    private TreeMap playerStandings = new TreeMap();
    private List aggressors = new ArrayList();
    private int ironGolemCount;

    public Village() {
    }

    public Village(World world) {
        this.world = world;
    }

    public void a(World world) {
        this.world = world;
    }

    public void tick(int n) {
        Vec3D vec3D;
        int n2;
        this.time = n;
        this.m();
        this.l();
        if (n % 20 == 0) {
            this.k();
        }
        if (n % 30 == 0) {
            this.countPopulation();
        }
        if (this.ironGolemCount < (n2 = this.population / 10) && this.doors.size() > 20 && this.world.random.nextInt(7000) == 0 && (vec3D = this.a(MathHelper.d(this.center.x), MathHelper.d(this.center.y), MathHelper.d(this.center.z), 2, 4, 2)) != null) {
            EntityIronGolem entityIronGolem = new EntityIronGolem(this.world);
            entityIronGolem.setPosition(vec3D.c, vec3D.d, vec3D.e);
            this.world.addEntity(entityIronGolem);
            ++this.ironGolemCount;
        }
    }

    private Vec3D a(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < 10; ++i) {
            int n7;
            int n8;
            int n9 = n + this.world.random.nextInt(16) - 8;
            if (!this.a(n9, n8 = n2 + this.world.random.nextInt(6) - 3, n7 = n3 + this.world.random.nextInt(16) - 8) || !this.b(n9, n8, n7, n4, n5, n6)) continue;
            return this.world.getVec3DPool().create(n9, n8, n7);
        }
        return null;
    }

    private boolean b(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.world.w(n, n2 - 1, n3)) {
            return false;
        }
        int n7 = n - n4 / 2;
        int n8 = n3 - n6 / 2;
        for (int i = n7; i < n7 + n4; ++i) {
            for (int j = n2; j < n2 + n5; ++j) {
                for (int k = n8; k < n8 + n6; ++k) {
                    if (!this.world.u(i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void countPopulation() {
        List list = this.world.a(EntityIronGolem.class, AxisAlignedBB.a().a(this.center.x - this.size, this.center.y - 4, this.center.z - this.size, this.center.x + this.size, this.center.y + 4, this.center.z + this.size));
        this.ironGolemCount = list.size();
    }

    private void k() {
        List list = this.world.a(EntityVillager.class, AxisAlignedBB.a().a(this.center.x - this.size, this.center.y - 4, this.center.z - this.size, this.center.x + this.size, this.center.y + 4, this.center.z + this.size));
        this.population = list.size();
        if (this.population == 0) {
            this.playerStandings.clear();
        }
    }

    public ChunkCoordinates getCenter() {
        return this.center;
    }

    public int getSize() {
        return this.size;
    }

    public int getDoorCount() {
        return this.doors.size();
    }

    public int d() {
        return this.time - this.f;
    }

    public int getPopulationCount() {
        return this.population;
    }

    public boolean a(int n, int n2, int n3) {
        return this.center.e(n, n2, n3) < (float)(this.size * this.size);
    }

    public List getDoors() {
        return this.doors;
    }

    public VillageDoor b(int n, int n2, int n3) {
        VillageDoor villageDoor = null;
        int n4 = Integer.MAX_VALUE;
        for (VillageDoor villageDoor2 : this.doors) {
            int n5 = villageDoor2.b(n, n2, n3);
            if (n5 >= n4) continue;
            villageDoor = villageDoor2;
            n4 = n5;
        }
        return villageDoor;
    }

    public VillageDoor c(int n, int n2, int n3) {
        VillageDoor villageDoor = null;
        int n4 = Integer.MAX_VALUE;
        for (VillageDoor villageDoor2 : this.doors) {
            int n5 = villageDoor2.b(n, n2, n3);
            n5 = n5 > 256 ? (n5 *= 1000) : villageDoor2.f();
            if (n5 >= n4) continue;
            villageDoor = villageDoor2;
            n4 = n5;
        }
        return villageDoor;
    }

    public VillageDoor e(int n, int n2, int n3) {
        if (this.center.e(n, n2, n3) > (float)(this.size * this.size)) {
            return null;
        }
        for (VillageDoor villageDoor : this.doors) {
            if (villageDoor.locX != n || villageDoor.locZ != n3 || Math.abs(villageDoor.locY - n2) > 1) continue;
            return villageDoor;
        }
        return null;
    }

    public void addDoor(VillageDoor villageDoor) {
        this.doors.add(villageDoor);
        this.c.x += villageDoor.locX;
        this.c.y += villageDoor.locY;
        this.c.z += villageDoor.locZ;
        this.n();
        this.f = villageDoor.addedTime;
    }

    public boolean isAbandoned() {
        return this.doors.isEmpty();
    }

    public void a(EntityLiving entityLiving) {
        for (VillageAggressor villageAggressor : this.aggressors) {
            if (villageAggressor.a != entityLiving) continue;
            villageAggressor.b = this.time;
            return;
        }
        this.aggressors.add(new VillageAggressor(this, entityLiving, this.time));
    }

    public EntityLiving b(EntityLiving entityLiving) {
        double d = Double.MAX_VALUE;
        VillageAggressor villageAggressor = null;
        for (int i = 0; i < this.aggressors.size(); ++i) {
            VillageAggressor villageAggressor2 = (VillageAggressor)this.aggressors.get(i);
            double d2 = villageAggressor2.a.e(entityLiving);
            if (d2 > d) continue;
            villageAggressor = villageAggressor2;
            d = d2;
        }
        return villageAggressor != null ? villageAggressor.a : null;
    }

    public EntityHuman c(EntityLiving entityLiving) {
        double d = Double.MAX_VALUE;
        EntityHuman entityHuman = null;
        for (String string : this.playerStandings.keySet()) {
            double d2;
            EntityHuman entityHuman2;
            if (!this.d(string) || (entityHuman2 = this.world.a(string)) == null || (d2 = entityHuman2.e(entityLiving)) > d) continue;
            entityHuman = entityHuman2;
            d = d2;
        }
        return entityHuman;
    }

    private void l() {
        Iterator iterator = this.aggressors.iterator();
        while (iterator.hasNext()) {
            VillageAggressor villageAggressor = (VillageAggressor)iterator.next();
            if (villageAggressor.a.isAlive() && Math.abs(this.time - villageAggressor.b) <= 300) continue;
            iterator.remove();
        }
    }

    private void m() {
        boolean bl = false;
        boolean bl2 = this.world.random.nextInt(50) == 0;
        Iterator iterator = this.doors.iterator();
        while (iterator.hasNext()) {
            VillageDoor villageDoor = (VillageDoor)iterator.next();
            if (bl2) {
                villageDoor.d();
            }
            if (this.isDoor(villageDoor.locX, villageDoor.locY, villageDoor.locZ) && Math.abs(this.time - villageDoor.addedTime) <= 1200) continue;
            this.c.x -= villageDoor.locX;
            this.c.y -= villageDoor.locY;
            this.c.z -= villageDoor.locZ;
            bl = true;
            villageDoor.removed = true;
            iterator.remove();
        }
        if (bl) {
            this.n();
        }
    }

    private boolean isDoor(int n, int n2, int n3) {
        int n4 = this.world.getTypeId(n, n2, n3);
        if (n4 <= 0) {
            return false;
        }
        return n4 == Block.WOODEN_DOOR.id;
    }

    private void n() {
        int n = this.doors.size();
        if (n == 0) {
            this.center.b(0, 0, 0);
            this.size = 0;
            return;
        }
        this.center.b(this.c.x / n, this.c.y / n, this.c.z / n);
        int n2 = 0;
        for (VillageDoor villageDoor : this.doors) {
            n2 = Math.max(villageDoor.b(this.center.x, this.center.y, this.center.z), n2);
        }
        this.size = Math.max(32, (int)Math.sqrt(n2) + 1);
    }

    public int a(String string) {
        Integer n = (Integer)this.playerStandings.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public int a(String string, int n) {
        int n2 = this.a(string);
        int n3 = MathHelper.a(n2 + n, -30, 10);
        this.playerStandings.put(string, n3);
        return n3;
    }

    public boolean d(String string) {
        return this.a(string) <= -15;
    }

    public void a(NBTTagCompound nBTTagCompound) {
        Object object;
        this.population = nBTTagCompound.getInt("PopSize");
        this.size = nBTTagCompound.getInt("Radius");
        this.ironGolemCount = nBTTagCompound.getInt("Golems");
        this.f = nBTTagCompound.getInt("Stable");
        this.time = nBTTagCompound.getInt("Tick");
        this.noBreedTicks = nBTTagCompound.getInt("MTick");
        this.center.x = nBTTagCompound.getInt("CX");
        this.center.y = nBTTagCompound.getInt("CY");
        this.center.z = nBTTagCompound.getInt("CZ");
        this.c.x = nBTTagCompound.getInt("ACX");
        this.c.y = nBTTagCompound.getInt("ACY");
        this.c.z = nBTTagCompound.getInt("ACZ");
        NBTTagList nBTTagList = nBTTagCompound.getList("Doors");
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            object = new VillageDoor(nBTTagCompound2.getInt("X"), nBTTagCompound2.getInt("Y"), nBTTagCompound2.getInt("Z"), nBTTagCompound2.getInt("IDX"), nBTTagCompound2.getInt("IDZ"), nBTTagCompound2.getInt("TS"));
            this.doors.add(object);
        }
        NBTTagList nBTTagList2 = nBTTagCompound.getList("Players");
        for (int i = 0; i < nBTTagList2.size(); ++i) {
            object = (NBTTagCompound)nBTTagList2.get(i);
            this.playerStandings.put(((NBTTagCompound)object).getString("Name"), ((NBTTagCompound)object).getInt("S"));
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setInt("PopSize", this.population);
        nBTTagCompound.setInt("Radius", this.size);
        nBTTagCompound.setInt("Golems", this.ironGolemCount);
        nBTTagCompound.setInt("Stable", this.f);
        nBTTagCompound.setInt("Tick", this.time);
        nBTTagCompound.setInt("MTick", this.noBreedTicks);
        nBTTagCompound.setInt("CX", this.center.x);
        nBTTagCompound.setInt("CY", this.center.y);
        nBTTagCompound.setInt("CZ", this.center.z);
        nBTTagCompound.setInt("ACX", this.c.x);
        nBTTagCompound.setInt("ACY", this.c.y);
        nBTTagCompound.setInt("ACZ", this.c.z);
        NBTTagList nBTTagList = new NBTTagList("Doors");
        for (Object object : this.doors) {
            Object object2 = new NBTTagCompound("Door");
            ((NBTTagCompound)object2).setInt("X", ((VillageDoor)object).locX);
            ((NBTTagCompound)object2).setInt("Y", ((VillageDoor)object).locY);
            ((NBTTagCompound)object2).setInt("Z", ((VillageDoor)object).locZ);
            ((NBTTagCompound)object2).setInt("IDX", ((VillageDoor)object).d);
            ((NBTTagCompound)object2).setInt("IDZ", ((VillageDoor)object).e);
            ((NBTTagCompound)object2).setInt("TS", ((VillageDoor)object).addedTime);
            nBTTagList.add((NBTBase)object2);
        }
        nBTTagCompound.set("Doors", nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList("Players");
        for (Object object2 : this.playerStandings.keySet()) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound((String)object2);
            nBTTagCompound2.setString("Name", (String)object2);
            nBTTagCompound2.setInt("S", (Integer)this.playerStandings.get(object2));
            nBTTagList2.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Players", nBTTagList2);
    }

    public void h() {
        this.noBreedTicks = this.time;
    }

    public boolean i() {
        return this.noBreedTicks == 0 || this.time - this.noBreedTicks >= 3600;
    }

    public void b(int n) {
        for (String string : this.playerStandings.keySet()) {
            this.a(string, n);
        }
    }
}

