/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockChest;
import net.minecraft.server.BlockHopper;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Facing;
import net.minecraft.server.IEntitySelector;
import net.minecraft.server.IHopper;
import net.minecraft.server.IInventory;
import net.minecraft.server.IWorldInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityChest;
import net.minecraft.server.World;

public class TileEntityHopper
extends TileEntity
implements IHopper {
    private ItemStack[] a = new ItemStack[5];
    private String b;
    private int c = -1;

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Items");
        this.a = new ItemStack[this.getSize()];
        if (nBTTagCompound.hasKey("CustomName")) {
            this.b = nBTTagCompound.getString("CustomName");
        }
        this.c = nBTTagCompound.getInt("TransferCooldown");
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            byte by = nBTTagCompound2.getByte("Slot");
            if (by < 0 || by >= this.a.length) continue;
            this.a[by] = ItemStack.createStack(nBTTagCompound2);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.setByte("Slot", (byte)i);
            this.a[i].save(nBTTagCompound2);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Items", nBTTagList);
        nBTTagCompound.setInt("TransferCooldown", this.c);
        if (this.c()) {
            nBTTagCompound.setString("CustomName", this.b);
        }
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public int getSize() {
        return this.a.length;
    }

    @Override
    public ItemStack getItem(int n) {
        return this.a[n];
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        if (this.a[n] != null) {
            if (this.a[n].count <= n2) {
                ItemStack itemStack = this.a[n];
                this.a[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.a[n].a(n2);
            if (this.a[n].count == 0) {
                this.a[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack splitWithoutUpdate(int n) {
        if (this.a[n] != null) {
            ItemStack itemStack = this.a[n];
            this.a[n] = null;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        this.a[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    @Override
    public String getName() {
        return this.c() ? this.b : "container.hopper";
    }

    @Override
    public boolean c() {
        return this.b != null && this.b.length() > 0;
    }

    public void a(String string) {
        this.b = string;
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.world.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return !(entityHuman.e((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }

    @Override
    public void startOpen() {
    }

    @Override
    public void g() {
    }

    @Override
    public boolean b(int n, ItemStack itemStack) {
        return true;
    }

    @Override
    public void h() {
        if (this.world == null || this.world.isStatic) {
            return;
        }
        --this.c;
        if (!this.l()) {
            this.c(0);
            this.j();
        }
    }

    public boolean j() {
        if (this.world == null || this.world.isStatic) {
            return false;
        }
        if (!this.l() && BlockHopper.d(this.p())) {
            boolean bl = this.u();
            boolean bl2 = bl = TileEntityHopper.suckInItems(this) || bl;
            if (bl) {
                this.c(8);
                this.update();
                return true;
            }
        }
        return false;
    }

    private boolean u() {
        IInventory iInventory = this.v();
        if (iInventory == null) {
            return false;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getItem(i) == null) continue;
            ItemStack itemStack = this.getItem(i).cloneItemStack();
            ItemStack itemStack2 = TileEntityHopper.addItem(iInventory, this.splitStack(i, 1), Facing.OPPOSITE_FACING[BlockHopper.c(this.p())]);
            if (itemStack2 == null || itemStack2.count == 0) {
                iInventory.update();
                return true;
            }
            this.setItem(i, itemStack);
        }
        return false;
    }

    public static boolean suckInItems(IHopper iHopper) {
        IInventory iInventory = TileEntityHopper.getSourceInventory(iHopper);
        if (iInventory != null) {
            int n = 0;
            if (iInventory instanceof IWorldInventory && n > -1) {
                IWorldInventory iWorldInventory = (IWorldInventory)iInventory;
                int[] nArray = iWorldInventory.getSlotsForFace(n);
                for (int i = 0; i < nArray.length; ++i) {
                    if (!TileEntityHopper.tryTakeInItemFromSlot(iHopper, iInventory, nArray[i], n)) continue;
                    return true;
                }
            } else {
                int n2 = iInventory.getSize();
                for (int i = 0; i < n2; ++i) {
                    if (!TileEntityHopper.tryTakeInItemFromSlot(iHopper, iInventory, i, n)) continue;
                    return true;
                }
            }
        } else {
            EntityItem entityItem = TileEntityHopper.getEntityItemAt(iHopper.getWorld(), iHopper.aA(), iHopper.aB() + 1.0, iHopper.aC());
            if (entityItem != null) {
                return TileEntityHopper.addEntityItem(iHopper, entityItem);
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHopper iHopper, IInventory iInventory, int n, int n2) {
        ItemStack itemStack = iInventory.getItem(n);
        if (itemStack != null && TileEntityHopper.canTakeItemFromInventory(iInventory, itemStack, n, n2)) {
            ItemStack itemStack2 = itemStack.cloneItemStack();
            ItemStack itemStack3 = TileEntityHopper.addItem(iHopper, iInventory.splitStack(n, 1), -1);
            if (itemStack3 == null || itemStack3.count == 0) {
                iInventory.update();
                return true;
            }
            iInventory.setItem(n, itemStack2);
        }
        return false;
    }

    public static boolean addEntityItem(IInventory iInventory, EntityItem entityItem) {
        boolean bl = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemStack = entityItem.getItemStack().cloneItemStack();
        ItemStack itemStack2 = TileEntityHopper.addItem(iInventory, itemStack, -1);
        if (itemStack2 == null || itemStack2.count == 0) {
            bl = true;
            entityItem.die();
        } else {
            entityItem.setItemStack(itemStack2);
        }
        return bl;
    }

    public static ItemStack addItem(IInventory iInventory, ItemStack itemStack, int n) {
        if (iInventory instanceof IWorldInventory && n > -1) {
            IWorldInventory iWorldInventory = (IWorldInventory)iInventory;
            int[] nArray = iWorldInventory.getSlotsForFace(n);
            for (int i = 0; i < nArray.length && itemStack != null && itemStack.count > 0; ++i) {
                itemStack = TileEntityHopper.tryMoveInItem(iInventory, itemStack, nArray[i], n);
            }
        } else {
            int n2 = iInventory.getSize();
            for (int i = 0; i < n2 && itemStack != null && itemStack.count > 0; ++i) {
                itemStack = TileEntityHopper.tryMoveInItem(iInventory, itemStack, i, n);
            }
        }
        if (itemStack != null && itemStack.count == 0) {
            itemStack = null;
        }
        return itemStack;
    }

    private static boolean canPlaceItemInInventory(IInventory iInventory, ItemStack itemStack, int n, int n2) {
        if (!iInventory.b(n, itemStack)) {
            return false;
        }
        return !(iInventory instanceof IWorldInventory) || ((IWorldInventory)iInventory).canPlaceItemThroughFace(n, itemStack, n2);
    }

    private static boolean canTakeItemFromInventory(IInventory iInventory, ItemStack itemStack, int n, int n2) {
        return !(iInventory instanceof IWorldInventory) || ((IWorldInventory)iInventory).canTakeItemThroughFace(n, itemStack, n2);
    }

    private static ItemStack tryMoveInItem(IInventory iInventory, ItemStack itemStack, int n, int n2) {
        ItemStack itemStack2 = iInventory.getItem(n);
        if (TileEntityHopper.canPlaceItemInInventory(iInventory, itemStack, n, n2)) {
            boolean bl = false;
            if (itemStack2 == null) {
                iInventory.setItem(n, itemStack);
                itemStack = null;
                bl = true;
            } else if (TileEntityHopper.canMergeItems(itemStack2, itemStack)) {
                int n3 = itemStack.getMaxStackSize() - itemStack2.count;
                int n4 = Math.min(itemStack.count, n3);
                itemStack.count -= n4;
                itemStack2.count += n4;
                boolean bl2 = bl = n4 > 0;
            }
            if (bl) {
                if (iInventory instanceof TileEntityHopper) {
                    ((TileEntityHopper)iInventory).c(8);
                    iInventory.update();
                }
                iInventory.update();
            }
        }
        return itemStack;
    }

    private IInventory v() {
        int n = BlockHopper.c(this.p());
        return TileEntityHopper.getInventoryAt(this.getWorld(), this.x + Facing.b[n], this.y + Facing.c[n], this.z + Facing.d[n]);
    }

    public static IInventory getSourceInventory(IHopper iHopper) {
        return TileEntityHopper.getInventoryAt(iHopper.getWorld(), iHopper.aA(), iHopper.aB() + 1.0, iHopper.aC());
    }

    public static EntityItem getEntityItemAt(World world, double d, double d2, double d3) {
        List list = world.a(EntityItem.class, AxisAlignedBB.a().a(d, d2, d3, d + 1.0, d2 + 1.0, d3 + 1.0), IEntitySelector.a);
        if (list.size() > 0) {
            return (EntityItem)list.get(0);
        }
        return null;
    }

    public static IInventory getInventoryAt(World world, double d, double d2, double d3) {
        List list;
        int n;
        Block block;
        int n2;
        int n3;
        IInventory iInventory = null;
        int n4 = MathHelper.floor(d);
        TileEntity tileEntity = world.getTileEntity(n4, n3 = MathHelper.floor(d2), n2 = MathHelper.floor(d3));
        if (tileEntity != null && tileEntity instanceof IInventory && (iInventory = (IInventory)((Object)tileEntity)) instanceof TileEntityChest && (block = Block.byId[n = world.getTypeId(n4, n3, n2)]) instanceof BlockChest) {
            iInventory = ((BlockChest)block).g_(world, n4, n3, n2);
        }
        if (iInventory == null && (list = world.getEntities(null, AxisAlignedBB.a().a(d, d2, d3, d + 1.0, d2 + 1.0, d3 + 1.0), IEntitySelector.b)) != null && list.size() > 0) {
            iInventory = (IInventory)list.get(world.random.nextInt(list.size()));
        }
        return iInventory;
    }

    private static boolean canMergeItems(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.id != itemStack2.id) {
            return false;
        }
        if (itemStack.getData() != itemStack2.getData()) {
            return false;
        }
        if (itemStack.count > itemStack.getMaxStackSize()) {
            return false;
        }
        return ItemStack.equals(itemStack, itemStack2);
    }

    @Override
    public double aA() {
        return this.x;
    }

    @Override
    public double aB() {
        return this.y;
    }

    @Override
    public double aC() {
        return this.z;
    }

    public void c(int n) {
        this.c = n;
    }

    public boolean l() {
        return this.c > 0;
    }
}

