/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockChest;
import net.minecraft.server.ContainerChest;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.InventoryLargeChest;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public class TileEntityChest
extends TileEntity
implements IInventory {
    private ItemStack[] items = new ItemStack[36];
    public boolean a;
    public TileEntityChest b;
    public TileEntityChest c;
    public TileEntityChest d;
    public TileEntityChest e;
    public float f;
    public float g;
    public int h;
    private int ticks;
    private int r = -1;
    private String s;

    @Override
    public int getSize() {
        return 27;
    }

    @Override
    public ItemStack getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                this.update();
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            this.update();
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack splitWithoutUpdate(int n) {
        if (this.items[n] != null) {
            ItemStack itemStack = this.items[n];
            this.items[n] = null;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
        this.update();
    }

    @Override
    public String getName() {
        return this.c() ? this.s : "container.chest";
    }

    @Override
    public boolean c() {
        return this.s != null && this.s.length() > 0;
    }

    public void a(String string) {
        this.s = string;
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Items");
        this.items = new ItemStack[this.getSize()];
        if (nBTTagCompound.hasKey("CustomName")) {
            this.s = nBTTagCompound.getString("CustomName");
        }
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            int n = nBTTagCompound2.getByte("Slot") & 0xFF;
            if (n < 0 || n >= this.items.length) continue;
            this.items[n] = ItemStack.createStack(nBTTagCompound2);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.setByte("Slot", (byte)i);
            this.items[i].save(nBTTagCompound2);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Items", nBTTagList);
        if (this.c()) {
            nBTTagCompound.setString("CustomName", this.s);
        }
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.world.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return !(entityHuman.e((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }

    @Override
    public void i() {
        super.i();
        this.a = false;
    }

    private void a(TileEntityChest tileEntityChest, int n) {
        if (tileEntityChest.r()) {
            this.a = false;
        } else if (this.a) {
            switch (n) {
                case 2: {
                    if (this.b == tileEntityChest) break;
                    this.a = false;
                    break;
                }
                case 0: {
                    if (this.e == tileEntityChest) break;
                    this.a = false;
                    break;
                }
                case 3: {
                    if (this.c == tileEntityChest) break;
                    this.a = false;
                    break;
                }
                case 1: {
                    if (this.d == tileEntityChest) break;
                    this.a = false;
                }
            }
        }
    }

    public void j() {
        if (this.a) {
            return;
        }
        this.a = true;
        this.b = null;
        this.c = null;
        this.d = null;
        this.e = null;
        if (this.a(this.x - 1, this.y, this.z)) {
            this.d = (TileEntityChest)this.world.getTileEntity(this.x - 1, this.y, this.z);
        }
        if (this.a(this.x + 1, this.y, this.z)) {
            this.c = (TileEntityChest)this.world.getTileEntity(this.x + 1, this.y, this.z);
        }
        if (this.a(this.x, this.y, this.z - 1)) {
            this.b = (TileEntityChest)this.world.getTileEntity(this.x, this.y, this.z - 1);
        }
        if (this.a(this.x, this.y, this.z + 1)) {
            this.e = (TileEntityChest)this.world.getTileEntity(this.x, this.y, this.z + 1);
        }
        if (this.b != null) {
            this.b.a(this, 0);
        }
        if (this.e != null) {
            this.e.a(this, 2);
        }
        if (this.c != null) {
            this.c.a(this, 1);
        }
        if (this.d != null) {
            this.d.a(this, 3);
        }
    }

    private boolean a(int n, int n2, int n3) {
        Block block = Block.byId[this.world.getTypeId(n, n2, n3)];
        if (block == null || !(block instanceof BlockChest)) {
            return false;
        }
        return ((BlockChest)block).a == this.l();
    }

    @Override
    public void h() {
        double d;
        float f;
        super.h();
        this.j();
        ++this.ticks;
        if (!this.world.isStatic && this.h != 0 && (this.ticks + this.x + this.y + this.z) % 200 == 0) {
            this.h = 0;
            f = 5.0f;
            List list = this.world.a(EntityHuman.class, AxisAlignedBB.a().a((float)this.x - f, (float)this.y - f, (float)this.z - f, (float)(this.x + 1) + f, (float)(this.y + 1) + f, (float)(this.z + 1) + f));
            for (EntityHuman entityHuman : list) {
                IInventory iInventory;
                if (!(entityHuman.activeContainer instanceof ContainerChest) || (iInventory = ((ContainerChest)entityHuman.activeContainer).e()) != this && (!(iInventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iInventory).a(this))) continue;
                ++this.h;
            }
        }
        this.g = this.f;
        f = 0.1f;
        if (this.h > 0 && this.f == 0.0f && this.b == null && this.d == null) {
            double d2 = (double)this.x + 0.5;
            d = (double)this.z + 0.5;
            if (this.e != null) {
                d += 0.5;
            }
            if (this.c != null) {
                d2 += 0.5;
            }
            this.world.makeSound(d2, (double)this.y + 0.5, d, "random.chestopen", 0.5f, this.world.random.nextFloat() * 0.1f + 0.9f);
        }
        if (this.h == 0 && this.f > 0.0f || this.h > 0 && this.f < 1.0f) {
            float f2;
            float f3 = this.f;
            this.f = this.h > 0 ? (this.f += f) : (this.f -= f);
            if (this.f > 1.0f) {
                this.f = 1.0f;
            }
            if (this.f < (f2 = 0.5f) && f3 >= f2 && this.b == null && this.d == null) {
                d = (double)this.x + 0.5;
                double d3 = (double)this.z + 0.5;
                if (this.e != null) {
                    d3 += 0.5;
                }
                if (this.c != null) {
                    d += 0.5;
                }
                this.world.makeSound(d, (double)this.y + 0.5, d3, "random.chestclosed", 0.5f, this.world.random.nextFloat() * 0.1f + 0.9f);
            }
            if (this.f < 0.0f) {
                this.f = 0.0f;
            }
        }
    }

    @Override
    public boolean b(int n, int n2) {
        if (n == 1) {
            this.h = n2;
            return true;
        }
        return super.b(n, n2);
    }

    @Override
    public void startOpen() {
        if (this.h < 0) {
            this.h = 0;
        }
        ++this.h;
        this.world.playNote(this.x, this.y, this.z, this.q().id, 1, this.h);
        this.world.applyPhysics(this.x, this.y, this.z, this.q().id);
        this.world.applyPhysics(this.x, this.y - 1, this.z, this.q().id);
    }

    @Override
    public void g() {
        if (this.q() == null || !(this.q() instanceof BlockChest)) {
            return;
        }
        --this.h;
        this.world.playNote(this.x, this.y, this.z, this.q().id, 1, this.h);
        this.world.applyPhysics(this.x, this.y, this.z, this.q().id);
        this.world.applyPhysics(this.x, this.y - 1, this.z, this.q().id);
    }

    @Override
    public boolean b(int n, ItemStack itemStack) {
        return true;
    }

    @Override
    public void w_() {
        super.w_();
        this.i();
        this.j();
    }

    public int l() {
        if (this.r == -1) {
            if (this.world != null && this.q() instanceof BlockChest) {
                this.r = ((BlockChest)this.q()).a;
            } else {
                return 0;
            }
        }
        return this.r;
    }
}

