/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportChunkPosHash;
import net.minecraft.server.CrashReportIsFeatureChunk;
import net.minecraft.server.CrashReportStructureType;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.ReportedException;
import net.minecraft.server.StructureBoundingBox;
import net.minecraft.server.StructurePiece;
import net.minecraft.server.StructureStart;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenBase;
import net.minecraft.server.WorldGenFactory;
import net.minecraft.server.WorldGenFeature;

public abstract class StructureGenerator
extends WorldGenBase {
    private WorldGenFeature e;
    protected Map d = new HashMap();

    public abstract String a();

    @Override
    protected final void a(World world, int n, int n2, int n3, int n4, byte[] byArray) {
        this.a(world);
        if (this.d.containsKey(ChunkCoordIntPair.a(n, n2))) {
            return;
        }
        this.b.nextInt();
        try {
            if (this.a(n, n2)) {
                StructureStart structureStart = this.b(n, n2);
                this.d.put(ChunkCoordIntPair.a(n, n2), structureStart);
                this.a(n, n2, structureStart);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Exception preparing structure feature");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Feature being prepared");
            crashReportSystemDetails.a("Is feature chunk", new CrashReportIsFeatureChunk(this, n, n2));
            crashReportSystemDetails.a("Chunk location", String.format("%d,%d", n, n2));
            crashReportSystemDetails.a("Chunk pos hash", new CrashReportChunkPosHash(this, n, n2));
            crashReportSystemDetails.a("Structure type", new CrashReportStructureType(this));
            throw new ReportedException(crashReport);
        }
    }

    public boolean a(World world, Random random, int n, int n2) {
        this.a(world);
        int n3 = (n << 4) + 8;
        int n4 = (n2 << 4) + 8;
        boolean bl = false;
        for (StructureStart structureStart : this.d.values()) {
            if (!structureStart.d() || !structureStart.a().a(n3, n4, n3 + 15, n4 + 15)) continue;
            structureStart.a(world, random, new StructureBoundingBox(n3, n4, n3 + 15, n4 + 15));
            bl = true;
            this.a(structureStart.e(), structureStart.f(), structureStart);
        }
        return bl;
    }

    public boolean b(int n, int n2, int n3) {
        this.a(this.c);
        return this.c(n, n2, n3) != null;
    }

    protected StructureStart c(int n, int n2, int n3) {
        for (StructureStart structureStart : this.d.values()) {
            if (!structureStart.d() || !structureStart.a().a(n, n3, n, n3)) continue;
            for (StructurePiece structurePiece : structureStart.b()) {
                if (!structurePiece.c().b(n, n2, n3)) continue;
                return structureStart;
            }
        }
        return null;
    }

    public boolean d(int n, int n2, int n3) {
        this.a(this.c);
        for (StructureStart structureStart : this.d.values()) {
            if (!structureStart.d()) continue;
            return structureStart.a().a(n, n3, n, n3);
        }
        return false;
    }

    public ChunkPosition getNearestGeneratedFeature(World world, int n, int n2, int n3) {
        double d;
        int n4;
        int n5;
        int n6;
        ChunkPosition chunkPosition;
        Object object;
        this.c = world;
        this.a(world);
        this.b.setSeed(world.getSeed());
        long l = this.b.nextLong();
        long l2 = this.b.nextLong();
        long l3 = (long)(n >> 4) * l;
        long l4 = (long)(n3 >> 4) * l2;
        this.b.setSeed(l3 ^ l4 ^ world.getSeed());
        this.a(world, n >> 4, n3 >> 4, 0, 0, null);
        double d2 = Double.MAX_VALUE;
        ChunkPosition chunkPosition2 = null;
        for (Object object2 : this.d.values()) {
            if (!((StructureStart)object2).d()) continue;
            object = (StructurePiece)((StructureStart)object2).b().get(0);
            chunkPosition = ((StructurePiece)object).a();
            n6 = chunkPosition.x - n;
            n5 = chunkPosition.y - n2;
            n4 = chunkPosition.z - n3;
            d = n6 * n6 + n5 * n5 + n4 * n4;
            if (!(d < d2)) continue;
            d2 = d;
            chunkPosition2 = chunkPosition;
        }
        if (chunkPosition2 != null) {
            return chunkPosition2;
        }
        List list = this.p_();
        if (list != null) {
            Object object2;
            object2 = null;
            object = list.iterator();
            while (object.hasNext()) {
                chunkPosition = (ChunkPosition)object.next();
                n6 = chunkPosition.x - n;
                n5 = chunkPosition.y - n2;
                n4 = chunkPosition.z - n3;
                d = n6 * n6 + n5 * n5 + n4 * n4;
                if (!(d < d2)) continue;
                d2 = d;
                object2 = chunkPosition;
            }
            return object2;
        }
        return null;
    }

    protected List p_() {
        return null;
    }

    private void a(World world) {
        if (this.e == null) {
            this.e = (WorldGenFeature)world.a(WorldGenFeature.class, this.a());
            if (this.e == null) {
                this.e = new WorldGenFeature(this.a());
                world.a(this.a(), this.e);
            } else {
                NBTTagCompound nBTTagCompound = this.e.a();
                for (NBTBase nBTBase : nBTTagCompound.c()) {
                    NBTTagCompound nBTTagCompound2;
                    if (nBTBase.getTypeId() != 10 || !(nBTTagCompound2 = (NBTTagCompound)nBTBase).hasKey("ChunkX") || !nBTTagCompound2.hasKey("ChunkZ")) continue;
                    int n = nBTTagCompound2.getInt("ChunkX");
                    int n2 = nBTTagCompound2.getInt("ChunkZ");
                    StructureStart structureStart = WorldGenFactory.a(nBTTagCompound2, world);
                    this.d.put(ChunkCoordIntPair.a(n, n2), structureStart);
                }
            }
        }
    }

    private void a(int n, int n2, StructureStart structureStart) {
        this.e.a(structureStart.a(n, n2), n, n2);
        this.e.c();
    }

    protected abstract boolean a(int var1, int var2);

    protected abstract StructureStart b(int var1, int var2);
}

