/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public final class SpawnerCreature {
    private HashMap a = new HashMap();

    protected static ChunkPosition getRandomPosition(World world, int n, int n2) {
        Chunk chunk = world.getChunkAt(n, n2);
        int n3 = n * 16 + world.random.nextInt(16);
        int n4 = n2 * 16 + world.random.nextInt(16);
        int n5 = world.random.nextInt(chunk == null ? world.S() : chunk.h() + 16 - 1);
        return new ChunkPosition(n3, n5, n4);
    }

    public int spawnEntities(WorldServer worldServer, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        int n;
        if (!bl && !bl2) {
            return 0;
        }
        this.a.clear();
        for (n = 0; n < worldServer.players.size(); ++n) {
            object2 = (EntityHuman)worldServer.players.get(n);
            int n2 = MathHelper.floor(((EntityHuman)object2).locX / 16.0);
            int n3 = MathHelper.floor(((EntityHuman)object2).locZ / 16.0);
            int n4 = 8;
            for (int i = -n4; i <= n4; ++i) {
                for (int j = -n4; j <= n4; ++j) {
                    boolean bl4 = i == -n4 || i == n4 || j == -n4 || j == n4;
                    object = new ChunkCoordIntPair(i + n2, j + n3);
                    if (!bl4) {
                        this.a.put(object, false);
                        continue;
                    }
                    if (this.a.containsKey(object)) continue;
                    this.a.put(object, true);
                }
            }
        }
        n = 0;
        object2 = worldServer.getSpawn();
        for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
            if (enumCreatureType.d() && !bl2 || !enumCreatureType.d() && !bl || enumCreatureType.e() && !bl3 || worldServer.a(enumCreatureType.a()) > enumCreatureType.b() * this.a.size() / 256) continue;
            block6: for (ChunkCoordIntPair chunkCoordIntPair : this.a.keySet()) {
                if (((Boolean)this.a.get(chunkCoordIntPair)).booleanValue()) continue;
                object = SpawnerCreature.getRandomPosition(worldServer, chunkCoordIntPair.x, chunkCoordIntPair.z);
                int n5 = ((ChunkPosition)object).x;
                int n6 = ((ChunkPosition)object).y;
                int n7 = ((ChunkPosition)object).z;
                if (worldServer.u(n5, n6, n7) || worldServer.getMaterial(n5, n6, n7) != enumCreatureType.c()) continue;
                int n8 = 0;
                block7: for (int i = 0; i < 3; ++i) {
                    int n9 = n5;
                    int n10 = n6;
                    int n11 = n7;
                    int n12 = 6;
                    BiomeMeta biomeMeta = null;
                    GroupDataEntity groupDataEntity = null;
                    for (int j = 0; j < 4; ++j) {
                        EntityInsentient entityInsentient;
                        float f;
                        float f2;
                        float f3;
                        float f4;
                        float f5;
                        float f6;
                        float f7;
                        if (!SpawnerCreature.a(enumCreatureType, worldServer, n9 += worldServer.random.nextInt(n12) - worldServer.random.nextInt(n12), n10 += worldServer.random.nextInt(1) - worldServer.random.nextInt(1), n11 += worldServer.random.nextInt(n12) - worldServer.random.nextInt(n12)) || worldServer.findNearbyPlayer(f7 = (float)n9 + 0.5f, f6 = (float)n10, f5 = (float)n11 + 0.5f, 24.0) != null || (f4 = (f3 = f7 - (float)((ChunkCoordinates)object2).x) * f3 + (f2 = f6 - (float)((ChunkCoordinates)object2).y) * f2 + (f = f5 - (float)((ChunkCoordinates)object2).z) * f) < 576.0f) continue;
                        if (biomeMeta == null && (biomeMeta = worldServer.a(enumCreatureType, n9, n10, n11)) == null) continue block7;
                        try {
                            entityInsentient = (EntityInsentient)biomeMeta.b.getConstructor(World.class).newInstance(worldServer);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return n;
                        }
                        entityInsentient.setPositionRotation(f7, f6, f5, worldServer.random.nextFloat() * 360.0f, 0.0f);
                        if (entityInsentient.canSpawn()) {
                            worldServer.addEntity(entityInsentient);
                            groupDataEntity = entityInsentient.a(groupDataEntity);
                            if (++n8 >= entityInsentient.bv()) continue block6;
                        }
                        n += n8;
                    }
                }
            }
        }
        return n;
    }

    public static boolean a(EnumCreatureType enumCreatureType, World world, int n, int n2, int n3) {
        if (enumCreatureType.c() == Material.WATER) {
            return world.getMaterial(n, n2, n3).isLiquid() && world.getMaterial(n, n2 - 1, n3).isLiquid() && !world.u(n, n2 + 1, n3);
        }
        if (!world.w(n, n2 - 1, n3)) {
            return false;
        }
        int n4 = world.getTypeId(n, n2 - 1, n3);
        return n4 != Block.BEDROCK.id && !world.u(n, n2, n3) && !world.getMaterial(n, n2, n3).isLiquid() && !world.u(n, n2 + 1, n3);
    }

    public static void a(World world, BiomeBase biomeBase, int n, int n2, int n3, int n4, Random random) {
        List list = biomeBase.getMobs(EnumCreatureType.CREATURE);
        if (list.isEmpty()) {
            return;
        }
        while (random.nextFloat() < biomeBase.f()) {
            BiomeMeta biomeMeta = (BiomeMeta)WeightedRandom.a(world.random, list);
            GroupDataEntity groupDataEntity = null;
            int n5 = biomeMeta.c + random.nextInt(1 + biomeMeta.d - biomeMeta.c);
            int n6 = n + random.nextInt(n3);
            int n7 = n2 + random.nextInt(n4);
            int n8 = n6;
            int n9 = n7;
            for (int i = 0; i < n5; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    int n10 = world.i(n6, n7);
                    if (SpawnerCreature.a(EnumCreatureType.CREATURE, world, n6, n10, n7)) {
                        EntityInsentient entityInsentient;
                        float f = (float)n6 + 0.5f;
                        float f2 = n10;
                        float f3 = (float)n7 + 0.5f;
                        try {
                            entityInsentient = (EntityInsentient)biomeMeta.b.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        entityInsentient.setPositionRotation(f, f2, f3, random.nextFloat() * 360.0f, 0.0f);
                        world.addEntity(entityInsentient);
                        groupDataEntity = entityInsentient.a(groupDataEntity);
                        bl = true;
                    }
                    n6 += random.nextInt(5) - random.nextInt(5);
                    n7 += random.nextInt(5) - random.nextInt(5);
                    while (n6 < n || n6 >= n + n3 || n7 < n2 || n7 >= n2 + n3) {
                        n6 = n8 + random.nextInt(5) - random.nextInt(5);
                        n7 = n9 + random.nextInt(5) - random.nextInt(5);
                    }
                }
            }
        }
    }
}

