/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet206SetScoreboardObjective;
import net.minecraft.server.Packet207SetScoreboardScore;
import net.minecraft.server.Packet208SetScoreboardDisplayObjective;
import net.minecraft.server.Packet209SetScoreboardTeam;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardSaveData;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardTeam;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer a;
    private final Set b = new HashSet();
    private ScoreboardSaveData c;

    public ScoreboardServer(MinecraftServer minecraftServer) {
        this.a = minecraftServer;
    }

    @Override
    public void handleScoreChanged(ScoreboardScore scoreboardScore) {
        super.handleScoreChanged(scoreboardScore);
        if (this.b.contains(scoreboardScore.getObjective())) {
            this.a.getPlayerList().sendAll(new Packet207SetScoreboardScore(scoreboardScore, 0));
        }
        this.b();
    }

    @Override
    public void handlePlayerRemoved(String string) {
        super.handlePlayerRemoved(string);
        this.a.getPlayerList().sendAll(new Packet207SetScoreboardScore(string));
        this.b();
    }

    @Override
    public void setDisplaySlot(int n, ScoreboardObjective scoreboardObjective) {
        ScoreboardObjective scoreboardObjective2 = this.getObjectiveForSlot(n);
        super.setDisplaySlot(n, scoreboardObjective);
        if (scoreboardObjective2 != scoreboardObjective && scoreboardObjective2 != null) {
            if (this.h(scoreboardObjective2) > 0) {
                this.a.getPlayerList().sendAll(new Packet208SetScoreboardDisplayObjective(n, scoreboardObjective));
            } else {
                this.g(scoreboardObjective2);
            }
        }
        if (scoreboardObjective != null) {
            if (this.b.contains(scoreboardObjective)) {
                this.a.getPlayerList().sendAll(new Packet208SetScoreboardDisplayObjective(n, scoreboardObjective));
            } else {
                this.e(scoreboardObjective);
            }
        }
        this.b();
    }

    @Override
    public void addPlayerToTeam(String string, ScoreboardTeam scoreboardTeam) {
        super.addPlayerToTeam(string, scoreboardTeam);
        this.a.getPlayerList().sendAll(new Packet209SetScoreboardTeam(scoreboardTeam, Arrays.asList(string), 3));
        this.b();
    }

    @Override
    public void removePlayerFromTeam(String string, ScoreboardTeam scoreboardTeam) {
        super.removePlayerFromTeam(string, scoreboardTeam);
        this.a.getPlayerList().sendAll(new Packet209SetScoreboardTeam(scoreboardTeam, Arrays.asList(string), 4));
        this.b();
    }

    @Override
    public void handleObjectiveAdded(ScoreboardObjective scoreboardObjective) {
        super.handleObjectiveAdded(scoreboardObjective);
        this.b();
    }

    @Override
    public void handleObjectiveChanged(ScoreboardObjective scoreboardObjective) {
        super.handleObjectiveChanged(scoreboardObjective);
        if (this.b.contains(scoreboardObjective)) {
            this.a.getPlayerList().sendAll(new Packet206SetScoreboardObjective(scoreboardObjective, 2));
        }
        this.b();
    }

    @Override
    public void handleObjectiveRemoved(ScoreboardObjective scoreboardObjective) {
        super.handleObjectiveRemoved(scoreboardObjective);
        if (this.b.contains(scoreboardObjective)) {
            this.g(scoreboardObjective);
        }
        this.b();
    }

    @Override
    public void handleTeamAdded(ScoreboardTeam scoreboardTeam) {
        super.handleTeamAdded(scoreboardTeam);
        this.a.getPlayerList().sendAll(new Packet209SetScoreboardTeam(scoreboardTeam, 0));
        this.b();
    }

    @Override
    public void handleTeamChanged(ScoreboardTeam scoreboardTeam) {
        super.handleTeamChanged(scoreboardTeam);
        this.a.getPlayerList().sendAll(new Packet209SetScoreboardTeam(scoreboardTeam, 2));
        this.b();
    }

    @Override
    public void handleTeamRemoved(ScoreboardTeam scoreboardTeam) {
        super.handleTeamRemoved(scoreboardTeam);
        this.a.getPlayerList().sendAll(new Packet209SetScoreboardTeam(scoreboardTeam, 1));
        this.b();
    }

    public void a(ScoreboardSaveData scoreboardSaveData) {
        this.c = scoreboardSaveData;
    }

    protected void b() {
        if (this.c != null) {
            this.c.c();
        }
    }

    public List getScoreboardScorePacketsForObjective(ScoreboardObjective scoreboardObjective) {
        ArrayList<Packet> arrayList = new ArrayList<Packet>();
        arrayList.add(new Packet206SetScoreboardObjective(scoreboardObjective, 0));
        for (int i = 0; i < 3; ++i) {
            if (this.getObjectiveForSlot(i) != scoreboardObjective) continue;
            arrayList.add(new Packet208SetScoreboardDisplayObjective(i, scoreboardObjective));
        }
        for (ScoreboardScore scoreboardScore : this.getScoresForObjective(scoreboardObjective)) {
            arrayList.add(new Packet207SetScoreboardScore(scoreboardScore, 0));
        }
        return arrayList;
    }

    public void e(ScoreboardObjective scoreboardObjective) {
        List list = this.getScoreboardScorePacketsForObjective(scoreboardObjective);
        for (EntityPlayer entityPlayer : this.a.getPlayerList().players) {
            for (Packet packet : list) {
                entityPlayer.playerConnection.sendPacket(packet);
            }
        }
        this.b.add(scoreboardObjective);
    }

    public List f(ScoreboardObjective scoreboardObjective) {
        ArrayList<Packet> arrayList = new ArrayList<Packet>();
        arrayList.add(new Packet206SetScoreboardObjective(scoreboardObjective, 1));
        for (int i = 0; i < 3; ++i) {
            if (this.getObjectiveForSlot(i) != scoreboardObjective) continue;
            arrayList.add(new Packet208SetScoreboardDisplayObjective(i, scoreboardObjective));
        }
        return arrayList;
    }

    public void g(ScoreboardObjective scoreboardObjective) {
        List list = this.f(scoreboardObjective);
        for (EntityPlayer entityPlayer : this.a.getPlayerList().players) {
            for (Packet packet : list) {
                entityPlayer.playerConnection.sendPacket(packet);
            }
        }
        this.b.remove(scoreboardObjective);
    }

    public int h(ScoreboardObjective scoreboardObjective) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.getObjectiveForSlot(i) != scoreboardObjective) continue;
            ++n;
        }
        return n;
    }
}

