/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import net.minecraft.server.IScoreboardCriteria;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagString;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardTeam;
import net.minecraft.server.WorldMapBase;

public class ScoreboardSaveData
extends WorldMapBase {
    private Scoreboard a;
    private NBTTagCompound b;

    public ScoreboardSaveData() {
        this("scoreboard");
    }

    public ScoreboardSaveData(String string) {
        super(string);
    }

    public void a(Scoreboard scoreboard) {
        this.a = scoreboard;
        if (this.b != null) {
            this.a(this.b);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        if (this.a == null) {
            this.b = nBTTagCompound;
            return;
        }
        this.b(nBTTagCompound.getList("Objectives"));
        this.c(nBTTagCompound.getList("PlayerScores"));
        if (nBTTagCompound.hasKey("DisplaySlots")) {
            this.c(nBTTagCompound.getCompound("DisplaySlots"));
        }
        if (nBTTagCompound.hasKey("Teams")) {
            this.a(nBTTagCompound.getList("Teams"));
        }
    }

    protected void a(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            ScoreboardTeam scoreboardTeam = this.a.createTeam(nBTTagCompound.getString("Name"));
            scoreboardTeam.setDisplayName(nBTTagCompound.getString("DisplayName"));
            scoreboardTeam.setPrefix(nBTTagCompound.getString("Prefix"));
            scoreboardTeam.setSuffix(nBTTagCompound.getString("Suffix"));
            if (nBTTagCompound.hasKey("AllowFriendlyFire")) {
                scoreboardTeam.setAllowFriendlyFire(nBTTagCompound.getBoolean("AllowFriendlyFire"));
            }
            if (nBTTagCompound.hasKey("SeeFriendlyInvisibles")) {
                scoreboardTeam.setCanSeeFriendlyInvisibles(nBTTagCompound.getBoolean("SeeFriendlyInvisibles"));
            }
            this.a(scoreboardTeam, nBTTagCompound.getList("Players"));
        }
    }

    protected void a(ScoreboardTeam scoreboardTeam, NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            this.a.addPlayerToTeam(((NBTTagString)nBTTagList.get((int)i)).data, scoreboardTeam);
        }
    }

    protected void c(NBTTagCompound nBTTagCompound) {
        for (int i = 0; i < 3; ++i) {
            if (!nBTTagCompound.hasKey("slot_" + i)) continue;
            String string = nBTTagCompound.getString("slot_" + i);
            ScoreboardObjective scoreboardObjective = this.a.getObjective(string);
            this.a.setDisplaySlot(i, scoreboardObjective);
        }
    }

    protected void b(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            IScoreboardCriteria iScoreboardCriteria = (IScoreboardCriteria)IScoreboardCriteria.a.get(nBTTagCompound.getString("CriteriaName"));
            ScoreboardObjective scoreboardObjective = this.a.registerObjective(nBTTagCompound.getString("Name"), iScoreboardCriteria);
            scoreboardObjective.setDisplayName(nBTTagCompound.getString("DisplayName"));
        }
    }

    protected void c(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            ScoreboardObjective scoreboardObjective = this.a.getObjective(nBTTagCompound.getString("Objective"));
            ScoreboardScore scoreboardScore = this.a.getPlayerScoreForObjective(nBTTagCompound.getString("Name"), scoreboardObjective);
            scoreboardScore.setScore(nBTTagCompound.getInt("Score"));
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        if (this.a == null) {
            MinecraftServer.getServer().getLogger().warning("Tried to save scoreboard without having a scoreboard...");
            return;
        }
        nBTTagCompound.set("Objectives", this.b());
        nBTTagCompound.set("PlayerScores", this.e());
        nBTTagCompound.set("Teams", this.a());
        this.d(nBTTagCompound);
    }

    protected NBTTagList a() {
        NBTTagList nBTTagList = new NBTTagList();
        Collection collection = this.a.getTeams();
        for (ScoreboardTeam scoreboardTeam : collection) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setString("Name", scoreboardTeam.getName());
            nBTTagCompound.setString("DisplayName", scoreboardTeam.getDisplayName());
            nBTTagCompound.setString("Prefix", scoreboardTeam.getPrefix());
            nBTTagCompound.setString("Suffix", scoreboardTeam.getSuffix());
            nBTTagCompound.setBoolean("AllowFriendlyFire", scoreboardTeam.allowFriendlyFire());
            nBTTagCompound.setBoolean("SeeFriendlyInvisibles", scoreboardTeam.canSeeFriendlyInvisibles());
            NBTTagList nBTTagList2 = new NBTTagList();
            for (String string : scoreboardTeam.getPlayerNameSet()) {
                nBTTagList2.add(new NBTTagString("", string));
            }
            nBTTagCompound.set("Players", nBTTagList2);
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    protected void d(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            ScoreboardObjective scoreboardObjective = this.a.getObjectiveForSlot(i);
            if (scoreboardObjective == null) continue;
            nBTTagCompound2.setString("slot_" + i, scoreboardObjective.getName());
            bl = true;
        }
        if (bl) {
            nBTTagCompound.setCompound("DisplaySlots", nBTTagCompound2);
        }
    }

    protected NBTTagList b() {
        NBTTagList nBTTagList = new NBTTagList();
        Collection collection = this.a.getObjectives();
        for (ScoreboardObjective scoreboardObjective : collection) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setString("Name", scoreboardObjective.getName());
            nBTTagCompound.setString("CriteriaName", scoreboardObjective.getCriteria().getName());
            nBTTagCompound.setString("DisplayName", scoreboardObjective.getDisplayName());
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    protected NBTTagList e() {
        NBTTagList nBTTagList = new NBTTagList();
        Collection collection = this.a.getScores();
        for (ScoreboardScore scoreboardScore : collection) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setString("Name", scoreboardScore.getPlayerName());
            nBTTagCompound.setString("Objective", scoreboardScore.getObjective().getName());
            nBTTagCompound.setInt("Score", scoreboardScore.getScore());
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }
}

