/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.IScoreboardCriteria;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardTeam;

public class Scoreboard {
    private final Map objectivesByName = new HashMap();
    private final Map objectivesByCriteria = new HashMap();
    private final Map playerScores = new HashMap();
    private final ScoreboardObjective[] displaySlots = new ScoreboardObjective[3];
    private final Map teamsByName = new HashMap();
    private final Map teamsByPlayer = new HashMap();

    public ScoreboardObjective getObjective(String string) {
        return (ScoreboardObjective)this.objectivesByName.get(string);
    }

    public ScoreboardObjective registerObjective(String string, IScoreboardCriteria iScoreboardCriteria) {
        ScoreboardObjective scoreboardObjective = this.getObjective(string);
        if (scoreboardObjective != null) {
            throw new IllegalArgumentException("An objective with the name '" + string + "' already exists!");
        }
        scoreboardObjective = new ScoreboardObjective(this, string, iScoreboardCriteria);
        ArrayList<ScoreboardObjective> arrayList = (ArrayList<ScoreboardObjective>)this.objectivesByCriteria.get(iScoreboardCriteria);
        if (arrayList == null) {
            arrayList = new ArrayList<ScoreboardObjective>();
            this.objectivesByCriteria.put(iScoreboardCriteria, arrayList);
        }
        arrayList.add(scoreboardObjective);
        this.objectivesByName.put(string, scoreboardObjective);
        this.handleObjectiveAdded(scoreboardObjective);
        return scoreboardObjective;
    }

    public Collection getObjectivesForCriteria(IScoreboardCriteria iScoreboardCriteria) {
        Collection collection = (Collection)this.objectivesByCriteria.get(iScoreboardCriteria);
        return collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public ScoreboardScore getPlayerScoreForObjective(String string, ScoreboardObjective scoreboardObjective) {
        ScoreboardScore scoreboardScore;
        HashMap<ScoreboardObjective, ScoreboardScore> hashMap = (HashMap<ScoreboardObjective, ScoreboardScore>)this.playerScores.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<ScoreboardObjective, ScoreboardScore>();
            this.playerScores.put(string, hashMap);
        }
        if ((scoreboardScore = (ScoreboardScore)hashMap.get(scoreboardObjective)) == null) {
            scoreboardScore = new ScoreboardScore(this, scoreboardObjective, string);
            hashMap.put(scoreboardObjective, scoreboardScore);
        }
        return scoreboardScore;
    }

    public Collection getScoresForObjective(ScoreboardObjective scoreboardObjective) {
        ArrayList<ScoreboardScore> arrayList = new ArrayList<ScoreboardScore>();
        for (Map map : this.playerScores.values()) {
            ScoreboardScore scoreboardScore = (ScoreboardScore)map.get(scoreboardObjective);
            if (scoreboardScore == null) continue;
            arrayList.add(scoreboardScore);
        }
        Collections.sort(arrayList, ScoreboardScore.a);
        return arrayList;
    }

    public Collection getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection getPlayers() {
        return this.playerScores.keySet();
    }

    public void resetPlayerScores(String string) {
        Map map = (Map)this.playerScores.remove(string);
        if (map != null) {
            this.handlePlayerRemoved(string);
        }
    }

    public Collection getScores() {
        Collection collection = this.playerScores.values();
        ArrayList arrayList = new ArrayList();
        for (Map map : collection) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public Map getPlayerObjectives(String string) {
        HashMap hashMap = (HashMap)this.playerScores.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    public void unregisterObjective(ScoreboardObjective scoreboardObjective) {
        this.objectivesByName.remove(scoreboardObjective.getName());
        for (int i = 0; i < 3; ++i) {
            if (this.getObjectiveForSlot(i) != scoreboardObjective) continue;
            this.setDisplaySlot(i, null);
        }
        List list = (List)this.objectivesByCriteria.get(scoreboardObjective.getCriteria());
        if (list != null) {
            list.remove(scoreboardObjective);
        }
        for (Map map : this.playerScores.values()) {
            map.remove(scoreboardObjective);
        }
        this.handleObjectiveRemoved(scoreboardObjective);
    }

    public void setDisplaySlot(int n, ScoreboardObjective scoreboardObjective) {
        this.displaySlots[n] = scoreboardObjective;
    }

    public ScoreboardObjective getObjectiveForSlot(int n) {
        return this.displaySlots[n];
    }

    public ScoreboardTeam getTeam(String string) {
        return (ScoreboardTeam)this.teamsByName.get(string);
    }

    public ScoreboardTeam createTeam(String string) {
        ScoreboardTeam scoreboardTeam = this.getTeam(string);
        if (scoreboardTeam != null) {
            throw new IllegalArgumentException("An objective with the name '" + string + "' already exists!");
        }
        scoreboardTeam = new ScoreboardTeam(this, string);
        this.teamsByName.put(string, scoreboardTeam);
        this.handleTeamAdded(scoreboardTeam);
        return scoreboardTeam;
    }

    public void removeTeam(ScoreboardTeam scoreboardTeam) {
        this.teamsByName.remove(scoreboardTeam.getName());
        for (String string : scoreboardTeam.getPlayerNameSet()) {
            this.teamsByPlayer.remove(string);
        }
        this.handleTeamRemoved(scoreboardTeam);
    }

    public void addPlayerToTeam(String string, ScoreboardTeam scoreboardTeam) {
        if (this.getPlayerTeam(string) != null) {
            this.removePlayerFromTeam(string);
        }
        this.teamsByPlayer.put(string, scoreboardTeam);
        scoreboardTeam.getPlayerNameSet().add(string);
    }

    public boolean removePlayerFromTeam(String string) {
        ScoreboardTeam scoreboardTeam = this.getPlayerTeam(string);
        if (scoreboardTeam != null) {
            this.removePlayerFromTeam(string, scoreboardTeam);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String string, ScoreboardTeam scoreboardTeam) {
        if (this.getPlayerTeam(string) != scoreboardTeam) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + scoreboardTeam.getName() + "'.");
        }
        this.teamsByPlayer.remove(string);
        scoreboardTeam.getPlayerNameSet().remove(string);
    }

    public Collection getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection getTeams() {
        return this.teamsByName.values();
    }

    public ScoreboardTeam getPlayerTeam(String string) {
        return (ScoreboardTeam)this.teamsByPlayer.get(string);
    }

    public void handleObjectiveAdded(ScoreboardObjective scoreboardObjective) {
    }

    public void handleObjectiveChanged(ScoreboardObjective scoreboardObjective) {
    }

    public void handleObjectiveRemoved(ScoreboardObjective scoreboardObjective) {
    }

    public void handleScoreChanged(ScoreboardScore scoreboardScore) {
    }

    public void handlePlayerRemoved(String string) {
    }

    public void handleTeamAdded(ScoreboardTeam scoreboardTeam) {
    }

    public void handleTeamChanged(ScoreboardTeam scoreboardTeam) {
    }

    public void handleTeamRemoved(ScoreboardTeam scoreboardTeam) {
    }

    public static String getSlotName(int n) {
        switch (n) {
            case 0: {
                return "list";
            }
            case 1: {
                return "sidebar";
            }
            case 2: {
                return "belowName";
            }
        }
        return null;
    }

    public static int getSlotForName(String string) {
        if (string.equalsIgnoreCase("list")) {
            return 0;
        }
        if (string.equalsIgnoreCase("sidebar")) {
            return 1;
        }
        if (string.equalsIgnoreCase("belowName")) {
            return 2;
        }
        return -1;
    }
}

