/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RemoteConnectionThread;
import net.minecraft.server.RemoteStatusChallenge;
import net.minecraft.server.RemoteStatusReply;
import net.minecraft.server.StatusChallengeUtils;

public class RemoteStatusListener
extends RemoteConnectionThread {
    private long clearedTime;
    private int bindPort;
    private int serverPort;
    private int maxPlayers;
    private String localAddress;
    private String worldName;
    private DatagramSocket socket;
    private byte[] n = new byte[1460];
    private DatagramPacket o;
    private Map p;
    private String hostname;
    private String motd;
    private Map challenges;
    private long t;
    private RemoteStatusReply cachedReply;
    private long cacheTime;

    public RemoteStatusListener(IMinecraftServer iMinecraftServer) {
        super(iMinecraftServer);
        this.bindPort = iMinecraftServer.a("query.port", 0);
        this.motd = iMinecraftServer.w();
        this.serverPort = iMinecraftServer.x();
        this.localAddress = iMinecraftServer.y();
        this.maxPlayers = iMinecraftServer.B();
        this.worldName = iMinecraftServer.L();
        this.cacheTime = 0L;
        this.hostname = "0.0.0.0";
        if (0 == this.motd.length() || this.hostname.equals(this.motd)) {
            this.motd = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.hostname = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.warning("Unable to determine local host IP, please set server-ip in '" + iMinecraftServer.b_() + "' : " + unknownHostException.getMessage());
            }
        } else {
            this.hostname = this.motd;
        }
        if (0 == this.bindPort) {
            this.bindPort = this.serverPort;
            this.info("Setting default query port to " + this.bindPort);
            iMinecraftServer.a("query.port", (Object)this.bindPort);
            iMinecraftServer.a("debug", false);
            iMinecraftServer.a();
        }
        this.p = new HashMap();
        this.cachedReply = new RemoteStatusReply(1460);
        this.challenges = new HashMap();
        this.t = new Date().getTime();
    }

    private void send(byte[] byArray, DatagramPacket datagramPacket) {
        this.socket.send(new DatagramPacket(byArray, byArray.length, datagramPacket.getSocketAddress()));
    }

    private boolean parsePacket(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        SocketAddress socketAddress = datagramPacket.getSocketAddress();
        this.debug("Packet len " + n + " [" + socketAddress + "]");
        if (3 > n || -2 != byArray[0] || -3 != byArray[1]) {
            this.debug("Invalid packet [" + socketAddress + "]");
            return false;
        }
        this.debug("Packet '" + StatusChallengeUtils.a(byArray[2]) + "' [" + socketAddress + "]");
        switch (byArray[2]) {
            case 9: {
                this.createChallenge(datagramPacket);
                this.debug("Challenge [" + socketAddress + "]");
                return true;
            }
            case 0: {
                if (!this.hasChallenged(datagramPacket).booleanValue()) {
                    this.debug("Invalid challenge [" + socketAddress + "]");
                    return false;
                }
                if (15 == n) {
                    this.send(this.getFullReply(datagramPacket), datagramPacket);
                    this.debug("Rules [" + socketAddress + "]");
                    break;
                }
                RemoteStatusReply remoteStatusReply = new RemoteStatusReply(1460);
                remoteStatusReply.write(0);
                remoteStatusReply.write(this.getIdentityToken(datagramPacket.getSocketAddress()));
                remoteStatusReply.write(this.localAddress);
                remoteStatusReply.write("SMP");
                remoteStatusReply.write(this.worldName);
                remoteStatusReply.write(Integer.toString(this.d()));
                remoteStatusReply.write(Integer.toString(this.maxPlayers));
                remoteStatusReply.write((short)this.serverPort);
                remoteStatusReply.write(this.hostname);
                this.send(remoteStatusReply.getBytes(), datagramPacket);
                this.debug("Status [" + socketAddress + "]");
            }
        }
        return true;
    }

    private byte[] getFullReply(DatagramPacket datagramPacket) {
        long l = MinecraftServer.aq();
        if (l < this.cacheTime + 5000L) {
            byte[] byArray = this.cachedReply.getBytes();
            byte[] byArray2 = this.getIdentityToken(datagramPacket.getSocketAddress());
            byArray[1] = byArray2[0];
            byArray[2] = byArray2[1];
            byArray[3] = byArray2[2];
            byArray[4] = byArray2[3];
            return byArray;
        }
        this.cacheTime = l;
        this.cachedReply.reset();
        this.cachedReply.write(0);
        this.cachedReply.write(this.getIdentityToken(datagramPacket.getSocketAddress()));
        this.cachedReply.write("splitnum");
        this.cachedReply.write(128);
        this.cachedReply.write(0);
        this.cachedReply.write("hostname");
        this.cachedReply.write(this.localAddress);
        this.cachedReply.write("gametype");
        this.cachedReply.write("SMP");
        this.cachedReply.write("game_id");
        this.cachedReply.write("MINECRAFT");
        this.cachedReply.write("version");
        this.cachedReply.write(this.server.getVersion());
        this.cachedReply.write("plugins");
        this.cachedReply.write(this.server.getPlugins());
        this.cachedReply.write("map");
        this.cachedReply.write(this.worldName);
        this.cachedReply.write("numplayers");
        this.cachedReply.write("" + this.d());
        this.cachedReply.write("maxplayers");
        this.cachedReply.write("" + this.maxPlayers);
        this.cachedReply.write("hostport");
        this.cachedReply.write("" + this.serverPort);
        this.cachedReply.write("hostip");
        this.cachedReply.write(this.hostname);
        this.cachedReply.write(0);
        this.cachedReply.write(1);
        this.cachedReply.write("player_");
        this.cachedReply.write(0);
        String[] stringArray = this.server.getPlayers();
        byte by = (byte)stringArray.length;
        for (byte by2 = (byte)(by - 1); by2 >= 0; by2 = (byte)(by2 - 1)) {
            this.cachedReply.write(stringArray[by2]);
        }
        this.cachedReply.write(0);
        return this.cachedReply.getBytes();
    }

    private byte[] getIdentityToken(SocketAddress socketAddress) {
        return ((RemoteStatusChallenge)this.challenges.get(socketAddress)).getIdentityToken();
    }

    private Boolean hasChallenged(DatagramPacket datagramPacket) {
        SocketAddress socketAddress = datagramPacket.getSocketAddress();
        if (!this.challenges.containsKey(socketAddress)) {
            return false;
        }
        byte[] byArray = datagramPacket.getData();
        if (((RemoteStatusChallenge)this.challenges.get(socketAddress)).getToken() != StatusChallengeUtils.c(byArray, 7, datagramPacket.getLength())) {
            return false;
        }
        return true;
    }

    private void createChallenge(DatagramPacket datagramPacket) {
        RemoteStatusChallenge remoteStatusChallenge = new RemoteStatusChallenge(this, datagramPacket);
        this.challenges.put(datagramPacket.getSocketAddress(), remoteStatusChallenge);
        this.send(remoteStatusChallenge.getChallengeResponse(), datagramPacket);
    }

    private void cleanChallenges() {
        if (!this.running) {
            return;
        }
        long l = MinecraftServer.aq();
        if (l < this.clearedTime + 30000L) {
            return;
        }
        this.clearedTime = l;
        Iterator iterator = this.challenges.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((RemoteStatusChallenge)entry.getValue()).isExpired(l).booleanValue()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.info("Query running on " + this.motd + ":" + this.bindPort);
        this.clearedTime = MinecraftServer.aq();
        this.o = new DatagramPacket(this.n, this.n.length);
        try {
            while (this.running) {
                try {
                    this.socket.receive(this.o);
                    this.cleanChallenges();
                    this.parsePacket(this.o);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.cleanChallenges();
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException iOException) {
                    this.a(iOException);
                }
            }
        }
        finally {
            this.e();
        }
    }

    @Override
    public void a() {
        if (this.running) {
            return;
        }
        if (0 >= this.bindPort || 65535 < this.bindPort) {
            this.warning("Invalid query port " + this.bindPort + " found in '" + this.server.b_() + "' (queries disabled)");
            return;
        }
        if (this.g()) {
            super.a();
        }
    }

    private void a(Exception exception) {
        if (!this.running) {
            return;
        }
        this.warning("Unexpected exception, buggy JRE? (" + exception.toString() + ")");
        if (!this.g()) {
            this.error("Failed to recover from buggy JRE, shutting down!");
            this.running = false;
        }
    }

    private boolean g() {
        try {
            this.socket = new DatagramSocket(this.bindPort, InetAddress.getByName(this.motd));
            this.a(this.socket);
            this.socket.setSoTimeout(500);
            return true;
        }
        catch (SocketException socketException) {
            this.warning("Unable to initialise query system on " + this.motd + ":" + this.bindPort + " (Socket): " + socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            this.warning("Unable to initialise query system on " + this.motd + ":" + this.bindPort + " (Unknown Host): " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            this.warning("Unable to initialise query system on " + this.motd + ":" + this.bindPort + " (E): " + exception.getMessage());
        }
        return false;
    }
}

