/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.BanEntry;
import net.minecraft.server.BanList;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.DemoPlayerInteractManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.EnumChatFormat;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.INetworkManager;
import net.minecraft.server.IPlayerFileData;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MobEffect;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet16BlockItemSwitch;
import net.minecraft.server.Packet1Login;
import net.minecraft.server.Packet201PlayerInfo;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet209SetScoreboardTeam;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet43SetExperience;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.Packet6SpawnPosition;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerChunkMap;
import net.minecraft.server.PlayerConnection;
import net.minecraft.server.PlayerDistanceComparator;
import net.minecraft.server.PlayerInteractManager;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ScoreboardTeam;
import net.minecraft.server.ScoreboardTeamBase;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class PlayerList {
    private static final SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List players = new ArrayList();
    private final BanList banByName = new BanList(new File("banned-players.txt"));
    private final BanList banByIP = new BanList(new File("banned-ips.txt"));
    private Set operators = new HashSet();
    private Set whitelist = new HashSet();
    private IPlayerFileData playerFileData;
    private boolean hasWhitelist;
    protected int maxPlayers;
    protected int c;
    private EnumGamemode l;
    private boolean m;
    private int n;

    public PlayerList(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        this.banByName.setEnabled(false);
        this.banByIP.setEnabled(false);
        this.maxPlayers = 8;
    }

    public void a(INetworkManager iNetworkManager, EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound = this.a(entityPlayer);
        entityPlayer.spawnIn(this.server.getWorldServer(entityPlayer.dimension));
        entityPlayer.playerInteractManager.a((WorldServer)entityPlayer.world);
        String string = "local";
        if (iNetworkManager.getSocketAddress() != null) {
            string = iNetworkManager.getSocketAddress().toString();
        }
        this.server.getLogger().info(entityPlayer.getName() + "[" + string + "] logged in with entity id " + entityPlayer.id + " at (" + entityPlayer.locX + ", " + entityPlayer.locY + ", " + entityPlayer.locZ + ")");
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
        this.a(entityPlayer, null, worldServer);
        PlayerConnection playerConnection = new PlayerConnection(this.server, iNetworkManager, entityPlayer);
        playerConnection.sendPacket(new Packet1Login(entityPlayer.id, worldServer.getWorldData().getType(), entityPlayer.playerInteractManager.getGameMode(), worldServer.getWorldData().isHardcore(), worldServer.worldProvider.dimension, worldServer.difficulty, worldServer.getHeight(), this.getMaxPlayers()));
        playerConnection.sendPacket(new Packet250CustomPayload("MC|Brand", this.getServer().getServerModName().getBytes(Charsets.UTF_8)));
        playerConnection.sendPacket(new Packet6SpawnPosition(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z));
        playerConnection.sendPacket(new Packet202Abilities(entityPlayer.abilities));
        playerConnection.sendPacket(new Packet16BlockItemSwitch(entityPlayer.inventory.itemInHandIndex));
        this.a((ScoreboardServer)worldServer.getScoreboard(), entityPlayer);
        this.b(entityPlayer, worldServer);
        this.sendMessage(ChatMessage.b("multiplayer.player.joined", entityPlayer.getScoreboardDisplayName()).a(EnumChatFormat.YELLOW));
        this.c(entityPlayer);
        playerConnection.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        this.server.ag().a(playerConnection);
        playerConnection.sendPacket(new Packet4UpdateTime(worldServer.getTime(), worldServer.getDayTime(), worldServer.getGameRules().getBoolean("doDaylightCycle")));
        if (this.server.getTexturePack().length() > 0) {
            entityPlayer.a(this.server.getTexturePack(), this.server.U());
        }
        Object object = entityPlayer.getEffects().iterator();
        while (object.hasNext()) {
            MobEffect mobEffect = (MobEffect)object.next();
            playerConnection.sendPacket(new Packet41MobEffect(entityPlayer.id, mobEffect));
        }
        entityPlayer.syncInventory();
        if (nBTTagCompound != null && nBTTagCompound.hasKey("Riding") && (object = EntityTypes.a(nBTTagCompound.getCompound("Riding"), (World)worldServer)) != null) {
            ((Entity)object).p = true;
            worldServer.addEntity((Entity)object);
            entityPlayer.mount((Entity)object);
            ((Entity)object).p = false;
        }
    }

    protected void a(ScoreboardServer scoreboardServer, EntityPlayer entityPlayer) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : scoreboardServer.getTeams()) {
            entityPlayer.playerConnection.sendPacket(new Packet209SetScoreboardTeam((ScoreboardTeam)object, 0));
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            object = scoreboardServer.getObjectiveForSlot(i);
            if (object == null || hashSet.contains(object)) continue;
            List list = scoreboardServer.getScoreboardScorePacketsForObjective((ScoreboardObjective)object);
            for (Packet packet : list) {
                entityPlayer.playerConnection.sendPacket(packet);
            }
            hashSet.add(object);
        }
    }

    public void setPlayerFileData(WorldServer[] worldServerArray) {
        this.playerFileData = worldServerArray[0].getDataManager().getPlayerFileData();
    }

    public void a(EntityPlayer entityPlayer, WorldServer worldServer) {
        WorldServer worldServer2 = entityPlayer.p();
        if (worldServer != null) {
            worldServer.getPlayerChunkMap().removePlayer(entityPlayer);
        }
        worldServer2.getPlayerChunkMap().addPlayer(entityPlayer);
        worldServer2.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
    }

    public int a() {
        return PlayerChunkMap.getFurthestViewableBlock(this.o());
    }

    public NBTTagCompound a(EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound;
        NBTTagCompound nBTTagCompound2 = this.server.worldServer[0].getWorldData().i();
        if (entityPlayer.getName().equals(this.server.J()) && nBTTagCompound2 != null) {
            entityPlayer.f(nBTTagCompound2);
            nBTTagCompound = nBTTagCompound2;
            System.out.println("loading single player");
        } else {
            nBTTagCompound = this.playerFileData.load(entityPlayer);
        }
        return nBTTagCompound;
    }

    protected void b(EntityPlayer entityPlayer) {
        this.playerFileData.save(entityPlayer);
    }

    public void c(EntityPlayer entityPlayer) {
        this.sendAll(new Packet201PlayerInfo(entityPlayer.getName(), true, 1000));
        this.players.add(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        worldServer.addEntity(entityPlayer);
        this.a(entityPlayer, null);
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer2 = (EntityPlayer)this.players.get(i);
            entityPlayer.playerConnection.sendPacket(new Packet201PlayerInfo(entityPlayer2.getName(), true, entityPlayer2.ping));
        }
    }

    public void d(EntityPlayer entityPlayer) {
        entityPlayer.p().getPlayerChunkMap().movePlayer(entityPlayer);
    }

    public void disconnect(EntityPlayer entityPlayer) {
        this.b(entityPlayer);
        WorldServer worldServer = entityPlayer.p();
        if (entityPlayer.vehicle != null) {
            worldServer.removeEntity(entityPlayer.vehicle);
            System.out.println("removing player mount");
        }
        worldServer.kill(entityPlayer);
        worldServer.getPlayerChunkMap().removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.sendAll(new Packet201PlayerInfo(entityPlayer.getName(), false, 9999));
    }

    public String attemptLogin(SocketAddress socketAddress, String string) {
        if (this.banByName.isBanned(string)) {
            BanEntry banEntry = (BanEntry)this.banByName.getEntries().get(string);
            String string2 = "You are banned from this server!\nReason: " + banEntry.getReason();
            if (banEntry.getExpires() != null) {
                string2 = string2 + "\nYour ban will be removed on " + d.format(banEntry.getExpires());
            }
            return string2;
        }
        if (!this.isWhitelisted(string)) {
            return "You are not white-listed on this server!";
        }
        String string3 = socketAddress.toString();
        string3 = string3.substring(string3.indexOf("/") + 1);
        if (this.banByIP.isBanned(string3 = string3.substring(0, string3.indexOf(":")))) {
            BanEntry banEntry = (BanEntry)this.banByIP.getEntries().get(string3);
            String string4 = "Your IP address is banned from this server!\nReason: " + banEntry.getReason();
            if (banEntry.getExpires() != null) {
                string4 = string4 + "\nYour ban will be removed on " + d.format(banEntry.getExpires());
            }
            return string4;
        }
        if (this.players.size() >= this.maxPlayers) {
            return "The server is full!";
        }
        return null;
    }

    public EntityPlayer processLogin(String string) {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!entityPlayer.getName().equalsIgnoreCase(string)) continue;
            arrayList.add(entityPlayer);
        }
        for (EntityPlayer entityPlayer : arrayList) {
            entityPlayer.playerConnection.disconnect("You logged in from another location");
        }
        PlayerInteractManager playerInteractManager = this.server.O() ? new DemoPlayerInteractManager(this.server.getWorldServer(0)) : new PlayerInteractManager(this.server.getWorldServer(0));
        return new EntityPlayer(this.server, this.server.getWorldServer(0), string, playerInteractManager);
    }

    public EntityPlayer moveToWorld(EntityPlayer entityPlayer, int n, boolean bl) {
        ChunkCoordinates chunkCoordinates;
        entityPlayer.p().getTracker().untrackPlayer(entityPlayer);
        entityPlayer.p().getTracker().untrackEntity(entityPlayer);
        entityPlayer.p().getPlayerChunkMap().removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).removeEntity(entityPlayer);
        ChunkCoordinates chunkCoordinates2 = entityPlayer.getBed();
        boolean bl2 = entityPlayer.isRespawnForced();
        entityPlayer.dimension = n;
        PlayerInteractManager playerInteractManager = this.server.O() ? new DemoPlayerInteractManager(this.server.getWorldServer(entityPlayer.dimension)) : new PlayerInteractManager(this.server.getWorldServer(entityPlayer.dimension));
        EntityPlayer entityPlayer2 = new EntityPlayer(this.server, this.server.getWorldServer(entityPlayer.dimension), entityPlayer.getName(), playerInteractManager);
        entityPlayer2.playerConnection = entityPlayer.playerConnection;
        entityPlayer2.copyTo(entityPlayer, bl);
        entityPlayer2.id = entityPlayer.id;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        this.a(entityPlayer2, entityPlayer, worldServer);
        if (chunkCoordinates2 != null) {
            chunkCoordinates = EntityHuman.getBed(this.server.getWorldServer(entityPlayer.dimension), chunkCoordinates2, bl2);
            if (chunkCoordinates != null) {
                entityPlayer2.setPositionRotation((float)chunkCoordinates.x + 0.5f, (float)chunkCoordinates.y + 0.1f, (float)chunkCoordinates.z + 0.5f, 0.0f, 0.0f);
                entityPlayer2.setRespawnPosition(chunkCoordinates2, bl2);
            } else {
                entityPlayer2.playerConnection.sendPacket(new Packet70Bed(0, 0));
            }
        }
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer2.locX >> 4, (int)entityPlayer2.locZ >> 4);
        while (!worldServer.getCubes(entityPlayer2, entityPlayer2.boundingBox).isEmpty()) {
            entityPlayer2.setPosition(entityPlayer2.locX, entityPlayer2.locY + 1.0, entityPlayer2.locZ);
        }
        entityPlayer2.playerConnection.sendPacket(new Packet9Respawn(entityPlayer2.dimension, (byte)entityPlayer2.world.difficulty, entityPlayer2.world.getWorldData().getType(), entityPlayer2.world.getHeight(), entityPlayer2.playerInteractManager.getGameMode()));
        chunkCoordinates = worldServer.getSpawn();
        entityPlayer2.playerConnection.a(entityPlayer2.locX, entityPlayer2.locY, entityPlayer2.locZ, entityPlayer2.yaw, entityPlayer2.pitch);
        entityPlayer2.playerConnection.sendPacket(new Packet6SpawnPosition(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z));
        entityPlayer2.playerConnection.sendPacket(new Packet43SetExperience(entityPlayer2.exp, entityPlayer2.expTotal, entityPlayer2.expLevel));
        this.b(entityPlayer2, worldServer);
        worldServer.getPlayerChunkMap().addPlayer(entityPlayer2);
        worldServer.addEntity(entityPlayer2);
        this.players.add(entityPlayer2);
        entityPlayer2.syncInventory();
        entityPlayer2.setHealth(entityPlayer2.getHealth());
        return entityPlayer2;
    }

    public void changeDimension(EntityPlayer entityPlayer, int n) {
        int n2 = entityPlayer.dimension;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.dimension = n;
        WorldServer worldServer2 = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.playerConnection.sendPacket(new Packet9Respawn(entityPlayer.dimension, (byte)entityPlayer.world.difficulty, worldServer2.getWorldData().getType(), worldServer2.getHeight(), entityPlayer.playerInteractManager.getGameMode()));
        worldServer.removeEntity(entityPlayer);
        entityPlayer.dead = false;
        this.a(entityPlayer, n2, worldServer, worldServer2);
        this.a(entityPlayer, worldServer);
        entityPlayer.playerConnection.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        entityPlayer.playerInteractManager.a(worldServer2);
        this.b(entityPlayer, worldServer2);
        this.updateClient(entityPlayer);
        for (MobEffect mobEffect : entityPlayer.getEffects()) {
            entityPlayer.playerConnection.sendPacket(new Packet41MobEffect(entityPlayer.id, mobEffect));
        }
    }

    public void a(Entity entity, int n, WorldServer worldServer, WorldServer worldServer2) {
        double d = entity.locX;
        double d2 = entity.locZ;
        double d3 = 8.0;
        double d4 = entity.locX;
        double d5 = entity.locY;
        double d6 = entity.locZ;
        float f = entity.yaw;
        worldServer.methodProfiler.a("moving");
        if (entity.dimension == -1) {
            entity.setPositionRotation(d /= d3, entity.locY, d2 /= d3, entity.yaw, entity.pitch);
            if (entity.isAlive()) {
                worldServer.entityJoinedWorld(entity, false);
            }
        } else if (entity.dimension == 0) {
            entity.setPositionRotation(d *= d3, entity.locY, d2 *= d3, entity.yaw, entity.pitch);
            if (entity.isAlive()) {
                worldServer.entityJoinedWorld(entity, false);
            }
        } else {
            ChunkCoordinates chunkCoordinates = n == 1 ? worldServer2.getSpawn() : worldServer2.getDimensionSpawn();
            d = chunkCoordinates.x;
            entity.locY = chunkCoordinates.y;
            d2 = chunkCoordinates.z;
            entity.setPositionRotation(d, entity.locY, d2, 90.0f, 0.0f);
            if (entity.isAlive()) {
                worldServer.entityJoinedWorld(entity, false);
            }
        }
        worldServer.methodProfiler.b();
        if (n != 1) {
            worldServer.methodProfiler.a("placing");
            d = MathHelper.a((int)d, -29999872, 29999872);
            d2 = MathHelper.a((int)d2, -29999872, 29999872);
            if (entity.isAlive()) {
                worldServer2.addEntity(entity);
                entity.setPositionRotation(d, entity.locY, d2, entity.yaw, entity.pitch);
                worldServer2.entityJoinedWorld(entity, false);
                worldServer2.t().a(entity, d4, d5, d6, f);
            }
            worldServer.methodProfiler.b();
        }
        entity.spawnIn(worldServer2);
    }

    public void tick() {
        if (++this.n > 600) {
            this.n = 0;
        }
        if (this.n < this.players.size()) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(this.n);
            this.sendAll(new Packet201PlayerInfo(entityPlayer.getName(), true, entityPlayer.ping));
        }
    }

    public void sendAll(Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            ((EntityPlayer)this.players.get((int)i)).playerConnection.sendPacket(packet);
        }
    }

    public void a(Packet packet, int n) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer.dimension != n) continue;
            entityPlayer.playerConnection.sendPacket(packet);
        }
    }

    public String c() {
        String string = "";
        for (int i = 0; i < this.players.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + ((EntityPlayer)this.players.get(i)).getName();
        }
        return string;
    }

    public String[] d() {
        String[] stringArray = new String[this.players.size()];
        for (int i = 0; i < this.players.size(); ++i) {
            stringArray[i] = ((EntityPlayer)this.players.get(i)).getName();
        }
        return stringArray;
    }

    public BanList getNameBans() {
        return this.banByName;
    }

    public BanList getIPBans() {
        return this.banByIP;
    }

    public void addOp(String string) {
        this.operators.add(string.toLowerCase());
    }

    public void removeOp(String string) {
        this.operators.remove(string.toLowerCase());
    }

    public boolean isWhitelisted(String string) {
        string = string.trim().toLowerCase();
        return !this.hasWhitelist || this.operators.contains(string) || this.whitelist.contains(string);
    }

    public boolean isOp(String string) {
        return this.operators.contains(string.trim().toLowerCase()) || this.server.K() && this.server.worldServer[0].getWorldData().allowCommands() && this.server.J().equalsIgnoreCase(string) || this.m;
    }

    public EntityPlayer getPlayer(String string) {
        for (EntityPlayer entityPlayer : this.players) {
            if (!entityPlayer.getName().equalsIgnoreCase(string)) continue;
            return entityPlayer;
        }
        return null;
    }

    public List a(ChunkCoordinates chunkCoordinates, int n, int n2, int n3, int n4, int n5, int n6, Map map, String string, String string2, World world) {
        if (this.players.isEmpty()) {
            return null;
        }
        List<EntityPlayer> list = new ArrayList();
        boolean bl = n3 < 0;
        boolean bl2 = string != null && string.startsWith("!");
        boolean bl3 = string2 != null && string2.startsWith("!");
        int n7 = n * n;
        int n8 = n2 * n2;
        n3 = MathHelper.a(n3);
        if (bl2) {
            string = string.substring(1);
        }
        if (bl3) {
            string2 = string2.substring(1);
        }
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (world != null && entityPlayer.world != world || string != null && bl2 == string.equalsIgnoreCase(entityPlayer.getLocalizedName())) continue;
            if (string2 != null) {
                String string3;
                ScoreboardTeamBase scoreboardTeamBase = entityPlayer.getScoreboardTeam();
                String string4 = string3 = scoreboardTeamBase == null ? "" : scoreboardTeamBase.getName();
                if (bl3 == string2.equalsIgnoreCase(string3)) continue;
            }
            if (chunkCoordinates != null && (n > 0 || n2 > 0)) {
                float f = chunkCoordinates.e(entityPlayer.b());
                if (n > 0 && f < (float)n7 || n2 > 0 && f > (float)n8) continue;
            }
            if (!this.a((EntityHuman)entityPlayer, map) || n4 != EnumGamemode.NONE.a() && n4 != entityPlayer.playerInteractManager.getGameMode().a() || n5 > 0 && entityPlayer.expLevel < n5 || entityPlayer.expLevel > n6) continue;
            list.add(entityPlayer);
        }
        if (chunkCoordinates != null) {
            Collections.sort(list, new PlayerDistanceComparator(chunkCoordinates));
        }
        if (bl) {
            Collections.reverse(list);
        }
        if (n3 > 0) {
            list = list.subList(0, Math.min(n3, list.size()));
        }
        return list;
    }

    private boolean a(EntityHuman entityHuman, Map map) {
        if (map == null || map.size() == 0) {
            return true;
        }
        for (Map.Entry entry : map.entrySet()) {
            Scoreboard scoreboard;
            ScoreboardObjective scoreboardObjective;
            String string = (String)entry.getKey();
            boolean bl = false;
            if (string.endsWith("_min") && string.length() > 4) {
                bl = true;
                string = string.substring(0, string.length() - 4);
            }
            if ((scoreboardObjective = (scoreboard = entityHuman.getScoreboard()).getObjective(string)) == null) {
                return false;
            }
            ScoreboardScore scoreboardScore = entityHuman.getScoreboard().getPlayerScoreForObjective(entityHuman.getLocalizedName(), scoreboardObjective);
            int n = scoreboardScore.getScore();
            if (n < (Integer)entry.getValue() && bl) {
                return false;
            }
            if (n <= (Integer)entry.getValue() || bl) continue;
            return false;
        }
        return true;
    }

    public void sendPacketNearby(double d, double d2, double d3, double d4, int n, Packet packet) {
        this.sendPacketNearby(null, d, d2, d3, d4, n, packet);
    }

    public void sendPacketNearby(EntityHuman entityHuman, double d, double d2, double d3, double d4, int n, Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d5;
            double d6;
            double d7;
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer == entityHuman || entityPlayer.dimension != n || !((d7 = d - entityPlayer.locX) * d7 + (d6 = d2 - entityPlayer.locY) * d6 + (d5 = d3 - entityPlayer.locZ) * d5 < d4 * d4)) continue;
            entityPlayer.playerConnection.sendPacket(packet);
        }
    }

    public void savePlayers() {
        for (int i = 0; i < this.players.size(); ++i) {
            this.b((EntityPlayer)this.players.get(i));
        }
    }

    public void addWhitelist(String string) {
        this.whitelist.add(string);
    }

    public void removeWhitelist(String string) {
        this.whitelist.remove(string);
    }

    public Set getWhitelisted() {
        return this.whitelist;
    }

    public Set getOPs() {
        return this.operators;
    }

    public void reloadWhitelist() {
    }

    public void b(EntityPlayer entityPlayer, WorldServer worldServer) {
        entityPlayer.playerConnection.sendPacket(new Packet4UpdateTime(worldServer.getTime(), worldServer.getDayTime(), worldServer.getGameRules().getBoolean("doDaylightCycle")));
        if (worldServer.Q()) {
            entityPlayer.playerConnection.sendPacket(new Packet70Bed(1, 0));
        }
    }

    public void updateClient(EntityPlayer entityPlayer) {
        entityPlayer.updateInventory(entityPlayer.defaultContainer);
        entityPlayer.triggerHealthUpdate();
        entityPlayer.playerConnection.sendPacket(new Packet16BlockItemSwitch(entityPlayer.inventory.itemInHandIndex));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String[] getSeenPlayers() {
        return this.server.worldServer[0].getDataManager().getPlayerFileData().getSeenPlayers();
    }

    public boolean getHasWhitelist() {
        return this.hasWhitelist;
    }

    public void setHasWhitelist(boolean bl) {
        this.hasWhitelist = bl;
    }

    public List i(String string) {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (EntityPlayer entityPlayer : this.players) {
            if (!entityPlayer.q().equals(string)) continue;
            arrayList.add(entityPlayer);
        }
        return arrayList;
    }

    public int o() {
        return this.c;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public NBTTagCompound q() {
        return null;
    }

    private void a(EntityPlayer entityPlayer, EntityPlayer entityPlayer2, World world) {
        if (entityPlayer2 != null) {
            entityPlayer.playerInteractManager.setGameMode(entityPlayer2.playerInteractManager.getGameMode());
        } else if (this.l != null) {
            entityPlayer.playerInteractManager.setGameMode(this.l);
        }
        entityPlayer.playerInteractManager.b(world.getWorldData().getGameType());
    }

    public void r() {
        while (!this.players.isEmpty()) {
            ((EntityPlayer)this.players.get((int)0)).playerConnection.disconnect("Server closed");
        }
    }

    public void sendMessage(ChatMessage chatMessage, boolean bl) {
        this.server.sendMessage(chatMessage);
        this.sendAll(new Packet3Chat(chatMessage, bl));
    }

    public void sendMessage(ChatMessage chatMessage) {
        this.sendMessage(chatMessage, true);
    }
}

